/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.codefresh;

import com.google.inject.Inject;
import hudson.Extension;
import hudson.Launcher;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.util.ListBoxModel;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.List;
import org.jenkinsci.plugins.codefresh.CFApi;
import org.jenkinsci.plugins.codefresh.CFPipeline;
import org.jenkinsci.plugins.codefresh.CFVariable;
import org.jenkinsci.plugins.codefresh.CodefreshPipelineBuilder;
import org.jenkinsci.plugins.workflow.steps.AbstractStepDescriptorImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractStepImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractSynchronousNonBlockingStepExecution;
import org.jenkinsci.plugins.workflow.steps.StepContextParameter;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;

public class CodefreshPipelineStep
extends AbstractStepImpl {
    private String cfPipeline = "";
    private String cfBranch = "";
    private List<CFVariable> cfVars = null;

    @DataBoundConstructor
    public CodefreshPipelineStep() {
    }

    public String getCfPipeline() {
        return this.cfPipeline;
    }

    public List<CFVariable> getCfVars() {
        return this.cfVars;
    }

    @DataBoundSetter
    public void setCfPipeline(String cfPipeline) {
        this.cfPipeline = cfPipeline;
    }

    @DataBoundSetter
    public void setCfBranch(String cfBranch) {
        this.cfBranch = cfBranch;
    }

    public String getCfBranch() {
        return this.cfBranch;
    }

    @DataBoundSetter
    public void setCfVars(List<CFVariable> cfVars) {
        this.cfVars = cfVars;
    }

    public static final class Execution
    extends AbstractSynchronousNonBlockingStepExecution<Boolean> {
        @Inject
        private transient CodefreshPipelineStep step;
        @StepContextParameter
        private transient Run run;
        @StepContextParameter
        private transient Launcher launcher;
        @StepContextParameter
        private transient TaskListener listener;
        private static final long serialVersionUID = 1L;

        protected Boolean run() throws Exception {
            CodefreshPipelineBuilder.SelectPipeline service = null;
            CodefreshPipelineBuilder.SetCFVars vars = null;
            if (this.step.cfPipeline != null) {
                service = new CodefreshPipelineBuilder.SelectPipeline(this.step.cfPipeline, this.step.cfBranch);
            }
            if (this.step.cfVars != null) {
                vars = new CodefreshPipelineBuilder.SetCFVars(this.step.cfVars);
            }
            CodefreshPipelineBuilder builder = new CodefreshPipelineBuilder(service, vars);
            return builder.performStep(this.run, this.listener);
        }
    }

    @Extension
    public static final class DescriptorImpl
    extends AbstractStepDescriptorImpl {
        public DescriptorImpl() {
            super(Execution.class);
        }

        public String getFunctionName() {
            return "codefreshRun";
        }

        public String getDisplayName() {
            return "Trigger a Codefresh Pipeline";
        }

        public ListBoxModel doFillCfPipelineItems(@QueryParameter(value="cfPipeline") String cfPipeline) throws IOException, MalformedURLException {
            ListBoxModel items = new ListBoxModel();
            CFApi api = new CFApi();
            for (CFPipeline srv : api.getPipelines()) {
                String name = srv.getName();
                items.add((Object)new ListBoxModel.Option(name, name, cfPipeline.equals(name)));
            }
            return items;
        }
    }
}

