/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.codefresh;

import com.google.inject.Inject;
import hudson.Extension;
import hudson.Launcher;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.util.ListBoxModel;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.List;
import org.jenkinsci.plugins.codefresh.CFApi;
import org.jenkinsci.plugins.codefresh.CFComposition;
import org.jenkinsci.plugins.codefresh.CFLaunchBuilder;
import org.jenkinsci.plugins.codefresh.CFVariable;
import org.jenkinsci.plugins.workflow.steps.AbstractStepDescriptorImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractStepImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractSynchronousNonBlockingStepExecution;
import org.jenkinsci.plugins.workflow.steps.StepContextParameter;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;

public class CodefreshLaunchStep
extends AbstractStepImpl {
    private String cfComposition = "";
    private List<CFVariable> cfVars = null;

    @DataBoundConstructor
    public CodefreshLaunchStep() {
    }

    public List<CFVariable> getCfVars() {
        return this.cfVars;
    }

    public String getCfComposition() {
        return this.cfComposition;
    }

    @DataBoundSetter
    public void setCfComposition(String cfComposition) {
        this.cfComposition = cfComposition;
    }

    @DataBoundSetter
    public void setCfVars(List<CFVariable> cfVars) {
        this.cfVars = cfVars;
    }

    public static final class Execution
    extends AbstractSynchronousNonBlockingStepExecution<Boolean> {
        @Inject
        private transient CodefreshLaunchStep step;
        @StepContextParameter
        private transient Run run;
        @StepContextParameter
        private transient Launcher launcher;
        @StepContextParameter
        private transient TaskListener listener;
        private static final long serialVersionUID = 1L;

        protected Boolean run() throws Exception {
            CFLaunchBuilder.SetCFVars setVars = new CFLaunchBuilder.SetCFVars(this.step.cfVars);
            CFLaunchBuilder builder = new CFLaunchBuilder(this.step.cfComposition, setVars);
            return builder.performStep(this.run, this.listener);
        }
    }

    @Extension
    public static final class DescriptorImpl
    extends AbstractStepDescriptorImpl {
        public DescriptorImpl() {
            super(Execution.class);
        }

        public String getFunctionName() {
            return "codefreshLaunch";
        }

        public String getDisplayName() {
            return "Launch a Codefresh Composition";
        }

        public ListBoxModel doFillCfCompositionItems(@QueryParameter(value="cfComposition") String cfComposition) throws IOException, MalformedURLException {
            ListBoxModel items = new ListBoxModel();
            Object cfUrl = null;
            boolean selfSignedCert = false;
            CFApi api = new CFApi();
            for (CFComposition composition : api.getCompositions()) {
                String name = composition.getName();
                items.add((Object)new ListBoxModel.Option(name, name, cfComposition.equals(name)));
            }
            return items;
        }
    }
}

