/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.codedx.monitor;

import com.codedx.api.client.CodeDxClient;
import com.codedx.api.client.CodeDxClientException;
import com.codedx.api.client.StartAnalysisResponse;
import hudson.AbortException;
import java.io.IOException;
import java.io.PrintStream;
import org.jenkinsci.plugins.codedx.monitor.AnalysisMonitor;
import org.jenkinsci.plugins.codedx.monitor.DirectAnalysisMonitor;

public class GitJobAnalysisMonitor
implements AnalysisMonitor {
    StartAnalysisResponse originalAnalysisResponse;
    StartAnalysisResponse newAnalysisResponse;
    PrintStream logger;

    public GitJobAnalysisMonitor(StartAnalysisResponse originalAnalysisResponse, PrintStream logger) {
        this.originalAnalysisResponse = originalAnalysisResponse;
        this.logger = logger;
    }

    @Override
    public int waitForStart(CodeDxClient client) throws InterruptedException, IOException, CodeDxClientException {
        String gitJobId = this.originalAnalysisResponse.getJobId();
        boolean isRunning = true;
        this.logger.println("Monitoring git clone job...");
        do {
            Thread.sleep(3000L);
            String status = client.getJobStatus(gitJobId);
            if (status == null) continue;
            if ("queued".equals(status) || "running".equals(status)) {
                this.logger.println("Git clone status is " + status);
                continue;
            }
            if ("failed".equals(status)) {
                throw new AbortException("Fatal Error! The Code Dx git clone job failed.");
            }
            isRunning = false;
        } while (isRunning);
        this.logger.println("Git clone job completed");
        this.newAnalysisResponse = client.getGitJobResult(gitJobId);
        return this.newAnalysisResponse.getAnalysisId();
    }

    @Override
    public String waitForFinish(CodeDxClient client) throws IOException, InterruptedException, CodeDxClientException {
        DirectAnalysisMonitor monitor = new DirectAnalysisMonitor(this.newAnalysisResponse, this.logger);
        return monitor.waitForFinish(client);
    }
}

