/*
 * Decompiled with CFR 0.152.
 */
package com.codedx.api.client;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.Charset;

public class ProjectContext {
    int projectId;
    String branchName;
    String contextString;

    public ProjectContext(int projectId) {
        this(projectId, null);
    }

    public ProjectContext(int projectId, String branchName) {
        this.projectId = projectId;
        this.branchName = branchName;
        this.contextString = Integer.toString(projectId);
        if (branchName != null) {
            try {
                this.contextString = this.contextString + ";branch=" + URLEncoder.encode(branchName, Charset.defaultCharset().name());
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
    }

    public int getProjectId() {
        return this.projectId;
    }

    public String getBranchName() {
        return this.branchName;
    }

    public ProjectContext withBranch(String branchName) {
        return new ProjectContext(this.projectId, branchName);
    }

    public String toString() {
        return this.contextString;
    }
}

