/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.codedx;

import com.secdec.codedx.api.client.CodeDxClient;
import com.secdec.codedx.api.client.CodeDxClientException;
import com.secdec.codedx.api.client.CodeDxRepeatingClient;
import com.secdec.codedx.api.client.CountGroup;
import com.secdec.codedx.api.client.Filter;
import com.secdec.codedx.api.client.Project;
import com.secdec.codedx.api.client.StartAnalysisResponse;
import com.secdec.codedx.api.client.TriageStatus;
import com.secdec.codedx.security.JenkinsSSLConnectionSocketFactoryFactory;
import com.secdec.codedx.util.CodeDxVersion;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.Descriptor;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Publisher;
import hudson.tasks.Recorder;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.net.ssl.SSLHandshakeException;
import javax.servlet.ServletException;
import jenkins.tasks.SimpleBuildStep;
import net.sf.json.JSONObject;
import org.apache.commons.io.IOUtils;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.HttpClientBuilder;
import org.jenkinsci.plugins.codedx.AnalysisResultChecker;
import org.jenkinsci.plugins.codedx.AnalysisResultConfiguration;
import org.jenkinsci.plugins.codedx.Archiver;
import org.jenkinsci.plugins.codedx.CodeDxBuildAction;
import org.jenkinsci.plugins.codedx.CodeDxResult;
import org.jenkinsci.plugins.codedx.Util;
import org.jenkinsci.plugins.codedx.model.CodeDxGroupStatistics;
import org.jenkinsci.plugins.codedx.model.CodeDxReportStatistics;
import org.jenkinsci.plugins.tokenmacro.MacroEvaluationException;
import org.jenkinsci.plugins.tokenmacro.TokenMacro;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

public class CodeDxPublisher
extends Recorder
implements SimpleBuildStep {
    private final String url;
    private final String key;
    private final String projectId;
    private String sourceAndBinaryFiles;
    private String toolOutputFiles;
    private String excludedSourceAndBinaryFiles;
    private String analysisName;
    private AnalysisResultConfiguration analysisResultConfiguration;
    private transient CodeDxClient client;
    private String selfSignedCertificateFingerprint;
    private static final Logger logger = Logger.getLogger(CodeDxPublisher.class.getName());

    @DataBoundConstructor
    public CodeDxPublisher(String url, String key, String projectId, String analysisName) {
        this.projectId = projectId;
        this.url = url;
        this.key = key;
        this.analysisName = analysisName.trim();
        this.sourceAndBinaryFiles = "";
        this.excludedSourceAndBinaryFiles = "";
        this.toolOutputFiles = "";
        this.analysisResultConfiguration = null;
        this.selfSignedCertificateFingerprint = null;
        this.setupClient();
    }

    private void setupClient() {
        if (this.client == null) {
            this.client = CodeDxPublisher.buildClient(this.url, this.key, this.selfSignedCertificateFingerprint);
        }
    }

    public AnalysisResultConfiguration getAnalysisResultConfiguration() {
        return this.analysisResultConfiguration;
    }

    @DataBoundSetter
    public void setAnalysisResultConfiguration(AnalysisResultConfiguration analysisResultConfiguration) {
        this.analysisResultConfiguration = analysisResultConfiguration;
    }

    public String getProjectId() {
        return this.projectId;
    }

    public String getUrl() {
        return this.url;
    }

    public String getKey() {
        return this.key;
    }

    public String getSourceAndBinaryFiles() {
        return this.sourceAndBinaryFiles;
    }

    @DataBoundSetter
    public void setSourceAndBinaryFiles(String sourceAndBinaryFiles) {
        this.sourceAndBinaryFiles = sourceAndBinaryFiles;
    }

    public String getToolOutputFiles() {
        return this.toolOutputFiles;
    }

    @DataBoundSetter
    public void setToolOutputFiles(String toolOutputFiles) {
        this.toolOutputFiles = toolOutputFiles;
    }

    public String getExcludedSourceAndBinaryFiles() {
        return this.excludedSourceAndBinaryFiles;
    }

    @DataBoundSetter
    public void setExcludedSourceAndBinaryFiles(String excludedSourceAndBinaryFiles) {
        this.excludedSourceAndBinaryFiles = excludedSourceAndBinaryFiles;
    }

    public String getSelfSignedCertificateFingerprint() {
        return this.selfSignedCertificateFingerprint;
    }

    @DataBoundSetter
    public void setSelfSignedCertificateFingerprint(String selfSignedCertificateFingerprint) {
        this.selfSignedCertificateFingerprint = selfSignedCertificateFingerprint;
        this.client = null;
        this.setupClient();
    }

    public String getAnalysisName() {
        return this.analysisName;
    }

    private String getLatestAnalysisUrl() {
        if (this.projectId.length() != 0 && !this.projectId.equals("-1")) {
            this.setupClient();
            return this.client.buildLatestFindingsUrl(Integer.parseInt(this.projectId));
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public void perform(Run<?, ?> build, FilePath workspace, Launcher launcher, TaskListener listener) throws InterruptedException, IOException {
        block49: {
            String[] files;
            Date startingDate = new Date();
            this.setupClient();
            HashMap<String, InputStream> toSend = new HashMap<String, InputStream>();
            PrintStream buildOutput = listener.getLogger();
            buildOutput.println("Publishing build to Code Dx:");
            if (this.projectId.length() == 0 || this.projectId.equals("-1")) {
                buildOutput.println("No project has been selected");
                return;
            }
            buildOutput.println(String.format("Publishing to Code Dx server at %s to Code Dx project %s: ", this.url, this.projectId));
            buildOutput.println("Creating source/binary zip...");
            FilePath sourceAndBinaryZip = Archiver.archive(workspace, Util.commaSeparatedToArray(this.sourceAndBinaryFiles), Util.commaSeparatedToArray(this.excludedSourceAndBinaryFiles), "source", buildOutput);
            if (sourceAndBinaryZip != null) {
                try {
                    buildOutput.println("Adding source/binary zip...");
                    toSend.put("Jenkins-SourceAndBinary", sourceAndBinaryZip.read());
                }
                catch (IOException e) {
                    buildOutput.println("Failed to add source/binary zip.");
                }
            } else {
                buildOutput.println("No matching source/binary files.");
            }
            for (String file : files = Util.commaSeparatedToArray(this.toolOutputFiles)) {
                if (file.length() == 0) continue;
                FilePath path = workspace.child(file);
                if (path.exists()) {
                    try {
                        buildOutput.println("Add tool output file " + path.getRemote() + " to request.");
                        toSend.put(path.getName(), path.read());
                    }
                    catch (IOException iOException) {
                        buildOutput.println("Failed to add tool output file: " + path);
                    }
                    continue;
                }
                buildOutput.println("Path specified but could not be found: " + path);
            }
            if (toSend.size() <= 0) break block49;
            CodeDxRepeatingClient repeatingClient = new CodeDxRepeatingClient(this.client, buildOutput);
            CodeDxVersion cdxVersion = null;
            try {
                cdxVersion = repeatingClient.getCodeDxVersion();
                buildOutput.println("Got Code Dx version: " + cdxVersion);
            }
            catch (CodeDxClientException e) {
                throw new IOException("Failed to get Code Dx version; aborting build.", e);
            }
            try {
                StartAnalysisResponse response;
                buildOutput.println("Submitting files to Code Dx for analysis");
                int projectIdInt = Integer.parseInt(this.projectId);
                try {
                    response = repeatingClient.startAnalysis(Integer.parseInt(this.projectId), toSend);
                }
                catch (CodeDxClientException e) {
                    try {
                        void var15_28;
                        switch (e.getHttpCode()) {
                            case 400: {
                                String string = " (Bad Request: have you included files from unsupported Tools? Code Dx Standard Edition does not support uploading tool results)";
                                break;
                            }
                            case 403: {
                                String string = " (Forbidden: have you configured your key and permissions correctly?)";
                                break;
                            }
                            case 404: {
                                String string = " (Project Not Found: is it possible it was deleted?)";
                                break;
                            }
                            case 500: {
                                String string = " (Internal Server Error: Please check your Code Dx server logs for more details)";
                                break;
                            }
                            default: {
                                String string = "";
                            }
                        }
                        String message = String.format("Failed to start analysis%s.", var15_28) + '\n' + String.format("Response Status: %d: %s", e.getHttpCode(), e.getResponseMessage()) + '\n' + String.format("Response Content: %s", e.getResponseContent()) + '\n' + Util.getStackTrace(e);
                        throw new IOException(message);
                    }
                    catch (Throwable throwable) {
                        for (Map.Entry entry : toSend.entrySet()) {
                            IOUtils.closeQuietly((InputStream)((InputStream)entry.getValue()));
                        }
                        throw throwable;
                    }
                }
                for (Map.Entry entry : toSend.entrySet()) {
                    IOUtils.closeQuietly((InputStream)((InputStream)entry.getValue()));
                }
                buildOutput.println("Code Dx accepted files for analysis");
                if (response != null) {
                    if (this.analysisName == null || this.analysisName.length() == 0) {
                        buildOutput.println("No 'Analysis Name' was chosen.");
                    } else {
                        buildOutput.println("Analysis Name (raw): " + this.analysisName);
                        String expandedAnalysisName = "";
                        try {
                            expandedAnalysisName = TokenMacro.expand(build, (FilePath)workspace, (TaskListener)listener, (String)this.analysisName);
                            buildOutput.println("Analysis Name expression expanded to: " + expandedAnalysisName);
                        }
                        catch (MacroEvaluationException macroEvaluationException) {
                            buildOutput.println("Failed to expand Analysis Name expression using TokenMacro. Falling back to built-in Jenkins functionality");
                            macroEvaluationException.printStackTrace(buildOutput);
                            expandedAnalysisName = build.getEnvironment(listener).expand(this.analysisName);
                        }
                        buildOutput.println("Analysis Name: " + expandedAnalysisName);
                        buildOutput.println("Analysis Id: " + response.getAnalysisId());
                        if (cdxVersion.compareTo(CodeDxVersion.MIN_FOR_ANALYSIS_NAMES) < 0) {
                            buildOutput.println("The connected Code Dx server is only version " + cdxVersion + ", which doesn't support naming analyses (minimum supported version is " + CodeDxVersion.MIN_FOR_ANALYSIS_NAMES + "). The analysis name will not be set.");
                        } else {
                            try {
                                repeatingClient.setAnalysisName(projectIdInt, response.getAnalysisId(), expandedAnalysisName);
                                buildOutput.println("Successfully updated analysis name.");
                            }
                            catch (CodeDxClientException codeDxClientException) {
                                throw new IOException("Got error from Code Dx API Client while trying to set the analysis name", codeDxClientException);
                            }
                        }
                    }
                }
                if (this.analysisResultConfiguration == null) {
                    logger.info("Project not configured to wait on analysis results");
                    return;
                }
                String status = null;
                Object var15_32 = null;
                try {
                    do {
                        Thread.sleep(3000L);
                        String string = status;
                        if (response != null) {
                            status = repeatingClient.getJobStatus(response.getJobId());
                        }
                        if (status == null || status.equals(string)) continue;
                        if ("queued".equals(status)) {
                            buildOutput.println("Code Dx analysis is queued");
                            continue;
                        }
                        if (!"running".equals(status)) continue;
                        buildOutput.println("Code Dx analysis is running");
                    } while ("queued".equals(status) || "running".equals(status));
                }
                catch (CodeDxClientException e) {
                    throw new IOException("Fatal Error! There was a problem querying for the analysis status.", e);
                }
                if ("completed".equals(status)) {
                    try {
                        buildOutput.println("Analysis succeeded");
                        buildOutput.println("Fetching severity counts");
                        Filter notGoneFilter = new Filter();
                        notGoneFilter.setNotStatus(new String[]{"gone"});
                        List<CountGroup> severityCounts = repeatingClient.getFindingsGroupedCounts(projectIdInt, notGoneFilter, "severity");
                        buildOutput.println("Fetching status counts");
                        Filter notAssignedFilter = new Filter();
                        notAssignedFilter.setNotStatus(new String[]{"assigned", "gone"});
                        List<CountGroup> statusCounts = repeatingClient.getFindingsGroupedCounts(projectIdInt, notAssignedFilter, "status");
                        Filter assignedFilter = new Filter();
                        assignedFilter.setStatus(new String[]{"assigned"});
                        buildOutput.println("Fetching assigned count");
                        int assignedCount = repeatingClient.getFindingsCount(projectIdInt, assignedFilter);
                        if (assignedCount > 0) {
                            CountGroup assignedGroup = new CountGroup();
                            assignedGroup.setName("Assigned");
                            assignedGroup.setCount(assignedCount);
                            statusCounts.add(assignedGroup);
                        }
                        buildOutput.println("Building table and charts");
                        HashMap<String, CodeDxReportStatistics> statMap = new HashMap<String, CodeDxReportStatistics>();
                        statMap.put("severity", this.createStatistics(severityCounts));
                        statMap.put("status", this.createStatistics(statusCounts));
                        CodeDxResult result = new CodeDxResult(statMap, build);
                        buildOutput.println("Adding CodeDx build action");
                        build.addAction((Action)new CodeDxBuildAction(build, this.analysisResultConfiguration, this.getLatestAnalysisUrl(), result));
                        AnalysisResultChecker checker = new AnalysisResultChecker(repeatingClient, cdxVersion, this.analysisResultConfiguration.getFailureSeverity(), this.analysisResultConfiguration.getUnstableSeverity(), startingDate, this.analysisResultConfiguration.isFailureOnlyNew(), this.analysisResultConfiguration.isUnstableOnlyNew(), projectIdInt, buildOutput);
                        build.setResult(checker.checkResult());
                    }
                    catch (CodeDxClientException e) {
                        throw new IOException("Fatal Error! There was a problem retrieving analysis results.", e);
                    }
                }
                buildOutput.println("Analysis status: " + status);
            }
            catch (NumberFormatException e) {
                throw new IOException("Invalid project Id");
            }
            finally {
                if (sourceAndBinaryZip != null) {
                    sourceAndBinaryZip.delete();
                }
            }
        }
        throw new IOException("Nothing to send, this doesn't seem right! Please check your 'Code Dx > Source and Binary Files' configuration.");
    }

    public static CodeDxClient buildClient(String url, String key, String fingerprint) {
        CodeDxClient client = new CodeDxClient(url, key);
        try {
            if (fingerprint != null) {
                fingerprint = fingerprint.replaceAll("[^a-fA-F0-9]", "");
            }
            URL parsedUrl = new URL(url);
            SSLConnectionSocketFactory socketFactory = JenkinsSSLConnectionSocketFactoryFactory.getFactory(fingerprint, parsedUrl.getHost());
            HttpClientBuilder builder = HttpClientBuilder.create();
            builder.setSSLSocketFactory((LayeredConnectionSocketFactory)socketFactory);
            client = new CodeDxClient(url, key, builder);
        }
        catch (MalformedURLException e) {
            logger.warning("A valid CodeDxClient could not be built. Malformed URL: " + url);
        }
        catch (GeneralSecurityException e) {
            logger.warning("A valid CodeDxClient could not be built. GeneralSecurityException: url: " + url + ", fingerprint: " + fingerprint);
        }
        catch (Exception e) {
            logger.warning("An exception was thrown while building the client " + e);
            e.printStackTrace();
        }
        return client;
    }

    private String[] getUsers(Map<String, TriageStatus> assignedStatuses) {
        ArrayList<String> users = new ArrayList<String>();
        for (TriageStatus status : assignedStatuses.values()) {
            if (!status.getType().equals("user")) continue;
            users.add(status.getDisplay());
        }
        return users.toArray(new String[0]);
    }

    private CodeDxReportStatistics createStatistics(List<CountGroup> countGroups) {
        ArrayList<CodeDxGroupStatistics> groupStatsList = new ArrayList<CodeDxGroupStatistics>();
        for (CountGroup group : countGroups) {
            CodeDxGroupStatistics stats = new CodeDxGroupStatistics(group.getName(), group.getCount());
            groupStatsList.add(stats);
        }
        return new CodeDxReportStatistics(groupStatsList);
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    private static boolean isFingerprintMismatch(SSLHandshakeException exception) {
        return exception.getMessage().contains("None of the TrustManagers trust this certificate chain");
    }

    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        public DescriptorImpl() {
            this.load();
        }

        public boolean isApplicable(Class<? extends AbstractProject> aClass) {
            return true;
        }

        public String getDisplayName() {
            return "Publish to Code Dx";
        }

        public FormValidation doCheckProjectId(@QueryParameter String value) throws IOException, ServletException {
            if (value.length() == 0) {
                return FormValidation.error((String)"Please set a project. If none are shown above, then be sure that system settings are configured correctly.");
            }
            if (Integer.parseInt(value) == -1) {
                return FormValidation.error((String)"Failed to get available projects, please ensure systems settings are configured correctly.");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckKey(@QueryParameter String value) throws IOException, ServletException {
            if (value.length() == 0) {
                return FormValidation.error((String)"Please set a Key.");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckUrl(@QueryParameter String value, @QueryParameter String selfSignedCertificateFingerprint) throws IOException, ServletException {
            CodeDxClient client = CodeDxPublisher.buildClient(value, "", selfSignedCertificateFingerprint);
            if (value.length() == 0) {
                return FormValidation.error((String)"Please set a URL.");
            }
            try {
                new URL(value);
            }
            catch (MalformedURLException malformedURLException) {
                return FormValidation.error((String)"Malformed URL");
            }
            if (value.toLowerCase().startsWith("http:")) {
                return FormValidation.warning((String)"HTTP is considered insecure, it is recommended that you use HTTPS.");
            }
            if (value.toLowerCase().startsWith("https:")) {
                block7: {
                    try {
                        client.getProjects();
                    }
                    catch (Exception e) {
                        if (!(e instanceof SSLHandshakeException)) break block7;
                        return FormValidation.warning((String)"The SSL Certificate presented by the server is invalid. If this is expected, please input an SHA1 Fingerprint in the \"Advanced\" option");
                    }
                }
                return FormValidation.ok();
            }
            return FormValidation.error((String)"Invalid protocol, please use HTTPS or HTTP.");
        }

        public FormValidation doCheckSelfSignedCertificateFingerprint(@QueryParameter String value, @QueryParameter String url) {
            block4: {
                if (url != null && !url.isEmpty() && value != null && !value.isEmpty()) {
                    CodeDxClient client = CodeDxPublisher.buildClient(url, "", value);
                    try {
                        client.getProjects();
                    }
                    catch (Exception e) {
                        if (!(e instanceof SSLHandshakeException)) break block4;
                        logger.warning("When retrieving projects: " + e);
                        e.printStackTrace();
                        if (CodeDxPublisher.isFingerprintMismatch((SSLHandshakeException)e)) {
                            return FormValidation.warning((String)"The fingerprint doesn't match the fingerprint of the certificate presented by the server");
                        }
                        return FormValidation.warning((String)"A secure connection to the server could not be established");
                    }
                }
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckSourceAndBinaryFiles(@QueryParameter String value, @QueryParameter String toolOutputFiles, @AncestorInPath AbstractProject project) {
            if (project == null) {
                return FormValidation.ok();
            }
            if (value.length() == 0) {
                if (toolOutputFiles.length() == 0) {
                    return FormValidation.error((String)"You must specify \"Tool Output Files\" and/or \"Source and Binary Files\"");
                }
                return FormValidation.warning((String)"It is recommended that at least source files are provided to Code Dx.");
            }
            return Util.checkCSVGlobMatches(value, project.getSomeWorkspace());
        }

        public FormValidation doCheckExcludedSourceAndBinaryFiles(@QueryParameter String value, @AncestorInPath AbstractProject project) {
            if (project == null) {
                return FormValidation.ok();
            }
            return Util.checkCSVGlobMatches(value, project.getSomeWorkspace());
        }

        public FormValidation doCheckToolOutputFiles(@QueryParameter String value, @QueryParameter String sourceAndBinaryFiles, @AncestorInPath AbstractProject project) {
            if (project == null) {
                return FormValidation.ok();
            }
            if (value.length() == 0 && sourceAndBinaryFiles.length() == 0) {
                return FormValidation.error((String)"You must specify \"Tool Output Files\" and/or \"Source and Binary Files\"");
            }
            return Util.checkCSVFileMatches(value, project.getSomeWorkspace());
        }

        public ListBoxModel doFillProjectIdItems(@QueryParameter String url, @QueryParameter String selfSignedCertificateFingerprint, @QueryParameter String key, @AncestorInPath AbstractProject project) {
            ListBoxModel listBox = new ListBoxModel();
            CodeDxClient client = CodeDxPublisher.buildClient(url, key, selfSignedCertificateFingerprint);
            try {
                List<Project> projects = client.getProjects();
                HashMap<String, Boolean> duplicates = new HashMap<String, Boolean>();
                for (Project proj : projects) {
                    if (!duplicates.containsKey(proj.getName())) {
                        duplicates.put(proj.getName(), false);
                        continue;
                    }
                    duplicates.put(proj.getName(), true);
                }
                for (Project proj : projects) {
                    if (!((Boolean)duplicates.get(proj.getName())).booleanValue()) {
                        listBox.add(proj.getName(), Integer.toString(proj.getId()));
                        continue;
                    }
                    listBox.add(proj.getName() + " (id:" + proj.getId() + ")", Integer.toString(proj.getId()));
                }
            }
            catch (Exception e) {
                logger.warning("Exception when populating projects dropdown " + e);
                listBox.add("", "-1");
            }
            return listBox;
        }

        public ListBoxModel doFillFailureSeverityItems() {
            return this.getSeverityItems();
        }

        public ListBoxModel doFillUnstableSeverityItems() {
            return this.getSeverityItems();
        }

        private ListBoxModel getSeverityItems() {
            ListBoxModel listBox = new ListBoxModel();
            listBox.add("None", "None");
            listBox.add("Info or Higher", "Info");
            listBox.add("Low or Higher", "Low");
            listBox.add("Medium or Higher", "Medium");
            listBox.add("High or Higher", "High");
            listBox.add("Critical", "Critical");
            return listBox;
        }

        public boolean configure(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            this.save();
            System.out.println("Code Dx descriptor configure method");
            return super.configure(req, formData);
        }

        public Publisher newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            return (Publisher)super.newInstance(req, formData);
        }
    }
}

