/*
 * Decompiled with CFR 0.152.
 */
package com.secdec.codedx.security;

import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.LinkedList;
import java.util.List;
import javax.net.ssl.X509TrustManager;

public class CompositeX509TrustManager
implements X509TrustManager {
    private final List<X509TrustManager> trustManagers = new LinkedList<X509TrustManager>();

    public CompositeX509TrustManager(List<X509TrustManager> trustManagers) {
        for (X509TrustManager tm : trustManagers) {
            if (tm == null) continue;
            this.trustManagers.add(tm);
        }
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        for (X509TrustManager trustManager : this.trustManagers) {
            try {
                trustManager.checkClientTrusted(chain, authType);
                return;
            }
            catch (CertificateException certificateException) {
            }
        }
        throw new CertificateException("None of the TrustManagers trust this certificate chain");
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        for (X509TrustManager trustManager : this.trustManagers) {
            try {
                trustManager.checkServerTrusted(chain, authType);
                return;
            }
            catch (CertificateException certificateException) {
            }
        }
        throw new CertificateException("None of the TrustManagers trust this certificate chain");
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        LinkedList<X509Certificate> certificates = new LinkedList<X509Certificate>();
        for (X509TrustManager trustManager : this.trustManagers) {
            for (X509Certificate cert : trustManager.getAcceptedIssuers()) {
                certificates.add(cert);
            }
        }
        return certificates.toArray(new X509Certificate[certificates.size()]);
    }
}

