/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.codedx;

import hudson.model.AbstractBuild;
import hudson.model.Action;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import org.jenkinsci.plugins.codedx.CodeDxDiffGroup;
import org.jenkinsci.plugins.codedx.CodeDxDiffSummary;
import org.jenkinsci.plugins.codedx.CodeDxResult;
import org.jenkinsci.plugins.codedx.model.CodeDxReportStatistics;
import org.kohsuke.stapler.StaplerProxy;

public class CodeDxBuildAction
implements Action,
Serializable,
StaplerProxy {
    private static final long serialVersionUID = 0L;
    public static final String URL_NAME = "codedxResult";
    private AbstractBuild<?, ?> build;
    private CodeDxResult result;

    public CodeDxBuildAction(AbstractBuild<?, ?> build, CodeDxResult result) {
        this.build = build;
        this.result = result;
    }

    public String getIconFileName() {
        return null;
    }

    public String getDisplayName() {
        return null;
    }

    public String getUrlName() {
        return URL_NAME;
    }

    public CodeDxDiffSummary getSeverityDiffSummary() {
        ArrayList<String> order = new ArrayList<String>();
        order.add("Critical");
        order.add("High");
        order.add("Medium");
        order.add("Low");
        order.add("Info");
        order.add("Unspecified");
        HashMap<String, String> iconMap = new HashMap<String, String>();
        iconMap.put("Critical", "/plugin/codedx/icons/critical.png");
        iconMap.put("High", "/plugin/codedx/icons/high.png");
        iconMap.put("Medium", "/plugin/codedx/icons/medium.png");
        iconMap.put("Low", "/plugin/codedx/icons/low.png");
        iconMap.put("Info", "/plugin/codedx/icons/info.png");
        iconMap.put("Unspecified", "/plugin/codedx/icons/unspecified.png");
        return CodeDxDiffSummary.getDiffSummary(this.getPreviousSeverityStats(), this.result.getStatistics("severity"), "Severity", new DiffGroupComparator(order), iconMap);
    }

    public CodeDxDiffSummary getStatusDiffSummary() {
        ArrayList<String> order = new ArrayList<String>();
        order.add("Fixed");
        order.add("Mitigated");
        order.add("Ignored");
        order.add("False Positive");
        order.add("Unresolved");
        order.add("Escalated");
        order.add("Assigned");
        order.add("New");
        order.add("Gone");
        return CodeDxDiffSummary.getDiffSummary(this.getPreviousStatusStats(), this.result.getStatistics("status"), "Status", new DiffGroupComparator(order), new HashMap<String, String>());
    }

    public CodeDxResult getResult() {
        return this.result;
    }

    private CodeDxReportStatistics getPreviousSeverityStats() {
        CodeDxResult previous = this.getPreviousResult();
        if (previous == null) {
            return null;
        }
        return previous.getStatistics("severity");
    }

    private CodeDxReportStatistics getPreviousStatusStats() {
        CodeDxResult previous = this.getPreviousResult();
        if (previous == null) {
            return null;
        }
        return previous.getStatistics("status");
    }

    CodeDxResult getPreviousResult() {
        CodeDxBuildAction previousAction = this.getPreviousAction();
        CodeDxResult previousResult = null;
        if (previousAction != null) {
            previousResult = previousAction.getResult();
        }
        return previousResult;
    }

    CodeDxBuildAction getPreviousAction() {
        if (this.build == null) {
            return null;
        }
        for (AbstractBuild previousBuild = this.build.getPreviousBuild(); previousBuild != null; previousBuild = previousBuild.getPreviousBuild()) {
            CodeDxResult result;
            CodeDxBuildAction action = (CodeDxBuildAction)previousBuild.getAction(CodeDxBuildAction.class);
            if (action == null || (result = action.getResult()) == null || result.isEmpty()) continue;
            return action;
        }
        return null;
    }

    public AbstractBuild<?, ?> getBuild() {
        return this.build;
    }

    public Object getTarget() {
        return this.result;
    }

    private class DiffGroupComparator
    implements Comparator<CodeDxDiffGroup> {
        List<String> groupOrdering = new ArrayList<String>();

        public DiffGroupComparator(List<String> groupOrdering) {
            this.groupOrdering = groupOrdering;
        }

        @Override
        public int compare(CodeDxDiffGroup o1, CodeDxDiffGroup o2) {
            int index1 = this.groupOrdering.indexOf(o1.getName());
            int index2 = this.groupOrdering.indexOf(o2.getName());
            return Integer.compare(index1, index2);
        }
    }
}

