/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.codedx;

import hudson.FilePath;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Archiver {
    private static final Logger log = Logger.getLogger(Archiver.class.getName());

    public static FilePath Archive(FilePath workspace, String[] paths, String[] excludePaths, String prefix, PrintStream logger) throws IOException, InterruptedException {
        HashSet<String> includeFiles = new HashSet<String>();
        HashSet<String> excludeFiles = new HashSet<String>();
        for (String path : paths) {
            if (path == null || path.length() <= 0) continue;
            for (FilePath match : workspace.list(path)) {
                includeFiles.add(match.getRemote());
            }
        }
        for (String path : excludePaths) {
            if (path == null || path.length() <= 0) continue;
            for (FilePath match : workspace.list(path)) {
                excludeFiles.add(match.getRemote());
            }
        }
        if (includeFiles.size() == 0) {
            return null;
        }
        FilePath result = workspace.createTempFile(prefix, ".zip");
        workspace.zip(result.write(), (FileFilter)new SourceAndBinaryFileFilter(includeFiles, excludeFiles));
        return result;
    }

    private static class SourceAndBinaryFileFilter
    implements FileFilter,
    Serializable {
        private Set<String> includeFiles;
        private Set<String> excludeFiles;

        public SourceAndBinaryFileFilter(Set<String> includeFiles, Set<String> excludeFiles) {
            this.includeFiles = includeFiles;
            this.excludeFiles = excludeFiles;
        }

        @Override
        public boolean accept(File file) {
            boolean include;
            boolean bl = include = this.includeFiles.contains(file.getAbsolutePath()) && !this.excludeFiles.contains(file.getAbsolutePath());
            if (include) {
                log.log(Level.FINE, "Adding" + file + " to zip");
            }
            return include;
        }
    }
}

