/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.codedx;

import com.secdec.codedx.api.client.CodeDxClient;
import com.secdec.codedx.api.client.CodeDxClientException;
import com.secdec.codedx.api.client.Filter;
import hudson.model.Result;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Arrays;
import org.apache.http.client.ClientProtocolException;

public class AnalysisResultChecker {
    private CodeDxClient client;
    private String failureSeverity;
    private String unstableSeverity;
    private boolean failureOnlyNew;
    private boolean unstableOnlyNew;
    private int runId;
    private PrintStream logger;

    public AnalysisResultChecker(CodeDxClient client, String failureSeverity, String unstableSeverity, boolean failureOnlyNew, boolean unstableOnlyNew, int runId, PrintStream logger) {
        this.client = client;
        this.failureSeverity = failureSeverity;
        this.unstableSeverity = unstableSeverity;
        this.failureOnlyNew = failureOnlyNew;
        this.unstableOnlyNew = unstableOnlyNew;
        this.runId = runId;
        this.logger = logger;
    }

    public Result checkResult() throws ClientProtocolException, CodeDxClientException, IOException {
        this.logger.println("Checking for findings that indicate build failure...");
        if (!"None".equalsIgnoreCase(this.failureSeverity) && this.client.getFindingsCount(this.runId, this.createFilter(this.failureSeverity, this.failureOnlyNew)) > 0) {
            this.logger.println(String.format("Failure: Code Dx reported %s or higher severity issues.", this.failureSeverity));
            return Result.FAILURE;
        }
        this.logger.println("Checking for findings that indicate unstable build.");
        if (!"None".equalsIgnoreCase(this.unstableSeverity) && this.client.getFindingsCount(this.runId, this.createFilter(this.unstableSeverity, this.unstableOnlyNew)) > 0) {
            this.logger.println("Unstable!");
            return Result.UNSTABLE;
        }
        this.logger.println("CodeDx results indicate success!");
        return Result.SUCCESS;
    }

    private Filter createFilter(String minSeverity, boolean onlyNew) {
        Filter filter = new Filter();
        filter.setSeverity(this.getSeverities(minSeverity));
        filter.setStatus(this.getStatuses(onlyNew));
        this.logger.println("Using filter: " + filter.toString());
        return filter;
    }

    private String[] getSeverities(String minSeverity) {
        String[] possibleSeverities = new String[]{"Info", "Low", "Medium", "High", "Unspecified"};
        for (int i = 0; i < possibleSeverities.length; ++i) {
            if (!possibleSeverities[i].equalsIgnoreCase(minSeverity)) continue;
            return Arrays.copyOfRange(possibleSeverities, i, possibleSeverities.length);
        }
        return new String[0];
    }

    private String[] getStatuses(boolean onlyNew) {
        if (onlyNew) {
            return new String[]{"new"};
        }
        return new String[]{"assigned", "escalated", "new", "unresolved"};
    }
}

