/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.clover.results;

import hudson.model.Run;
import hudson.plugins.clover.CloverBuildAction;
import hudson.plugins.clover.results.AbstractCloverMetrics;
import hudson.plugins.clover.results.AbstractPackageAggregatedMetrics;
import hudson.plugins.clover.results.ClassCoverage;
import hudson.plugins.clover.results.FileCoverage;
import hudson.plugins.clover.results.PackageCoverage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

public class ProjectCoverage
extends AbstractPackageAggregatedMetrics {
    private List<PackageCoverage> packageCoverages = new ArrayList<PackageCoverage>();

    public boolean addPackageCoverage(PackageCoverage result) {
        return this.packageCoverages.add(result);
    }

    public List<PackageCoverage> getPackageCoverages() {
        return this.packageCoverages;
    }

    public List<PackageCoverage> getChildren() {
        return this.getPackageCoverages();
    }

    @Override
    public PackageCoverage findPackageCoverage(String name) {
        for (PackageCoverage i : this.packageCoverages) {
            if (!name.equals(i.getName())) continue;
            return i;
        }
        return null;
    }

    @Override
    public FileCoverage findFileCoverage(String name) {
        for (PackageCoverage i : this.packageCoverages) {
            FileCoverage j = i.findFileCoverage(name);
            if (j == null) continue;
            return j;
        }
        return null;
    }

    @Override
    public ClassCoverage findClassCoverage(String name) {
        for (PackageCoverage i : this.packageCoverages) {
            ClassCoverage j;
            String prefix = i.getName() + '.';
            if (!name.startsWith(prefix) || (j = i.findClassCoverage(name)) == null) continue;
            return j;
        }
        return null;
    }

    public PackageCoverage getDynamic(String token, StaplerRequest req, StaplerResponse rsp) throws IOException {
        return this.findPackageCoverage(token);
    }

    @Override
    public AbstractCloverMetrics getPreviousResult() {
        CloverBuildAction action = this.getPreviousCloverBuildAction();
        if (action == null) {
            return null;
        }
        return action.getResult();
    }

    @Override
    public void setOwner(Run<?, ?> owner) {
        super.setOwner(owner);
        for (PackageCoverage p : this.packageCoverages) {
            p.setOwner(owner);
        }
    }
}

