/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.clover;

import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.Descriptor;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.plugins.clover.CloverBuildAction;
import hudson.plugins.clover.CloverCoverageParser;
import hudson.plugins.clover.CloverHtmlBuildAction;
import hudson.plugins.clover.Messages;
import hudson.plugins.clover.results.ProjectCoverage;
import hudson.plugins.clover.slave.GetPathFileCallable;
import hudson.plugins.clover.targets.CoverageMetric;
import hudson.plugins.clover.targets.CoverageTarget;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Publisher;
import hudson.tasks.Recorder;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import jenkins.tasks.SimpleBuildStep;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;

public class CloverPublisher
extends Recorder
implements SimpleBuildStep {
    private final String cloverReportDir;
    private final String cloverReportFileName;
    private CoverageTarget healthyTarget;
    private CoverageTarget unhealthyTarget;
    private CoverageTarget failingTarget;
    @Extension
    public static final DescriptorImpl DESCRIPTOR = new DescriptorImpl();

    public CloverPublisher(String cloverReportDir, String cloverReportFileName) {
        this.cloverReportDir = cloverReportDir;
        this.cloverReportFileName = cloverReportFileName;
        this.healthyTarget = new CoverageTarget();
        this.unhealthyTarget = new CoverageTarget();
        this.failingTarget = new CoverageTarget();
    }

    @DataBoundConstructor
    public CloverPublisher(String cloverReportDir, String cloverReportFileName, CoverageTarget healthyTarget, CoverageTarget unhealthyTarget, CoverageTarget failingTarget) {
        this.cloverReportDir = cloverReportDir;
        this.cloverReportFileName = cloverReportFileName;
        this.healthyTarget = healthyTarget;
        this.unhealthyTarget = unhealthyTarget;
        this.failingTarget = failingTarget;
    }

    public String getCloverReportDir() {
        return this.cloverReportDir;
    }

    public String getCloverReportFileName() {
        return this.cloverReportFileName == null || this.cloverReportFileName.trim().length() == 0 ? "clover.xml" : this.cloverReportFileName;
    }

    public CoverageTarget getHealthyTarget() {
        return this.healthyTarget;
    }

    public void setHealthyTarget(CoverageTarget healthyTarget) {
        this.healthyTarget = healthyTarget;
    }

    public CoverageTarget getUnhealthyTarget() {
        return this.unhealthyTarget;
    }

    public void setUnhealthyTarget(CoverageTarget unhealthyTarget) {
        this.unhealthyTarget = unhealthyTarget;
    }

    public CoverageTarget getFailingTarget() {
        return this.failingTarget;
    }

    public void setFailingTarget(CoverageTarget failingTarget) {
        this.failingTarget = failingTarget;
    }

    static File getCloverXmlReport(Run<?, ?> build) {
        return new File(build.getRootDir(), "clover.xml");
    }

    public void perform(@Nonnull Run<?, ?> run, @Nonnull FilePath workspace, @Nonnull Launcher launcher, @Nonnull TaskListener listener) throws InterruptedException, IOException {
        this.performImpl(run, workspace, listener);
    }

    private void performImpl(Run<?, ?> run, FilePath workspace, TaskListener listener) throws IOException, InterruptedException {
        EnvVars env = run.getEnvironment(listener);
        File buildRootDir = run.getRootDir();
        FilePath buildTarget = new FilePath(buildRootDir);
        String reportDir = env.expand(this.cloverReportDir);
        FilePath coverageReportDir = workspace.child(reportDir);
        try {
            boolean missingReport;
            listener.getLogger().println("Publishing Clover coverage report...");
            if (!coverageReportDir.exists()) {
                coverageReportDir = this.findOneDirDeep(workspace, reportDir);
            }
            boolean buildFailure = run.getResult() != null && run.getResult().isWorseOrEqualTo(Result.FAILURE);
            boolean bl = missingReport = !coverageReportDir.exists();
            if (buildFailure && missingReport) {
                listener.getLogger().println("No Clover report will be published due to a " + (buildFailure ? "Build Failure" : "missing report"));
                return;
            }
            boolean htmlExists = this.copyHtmlReport(coverageReportDir, buildTarget, listener);
            boolean xmlExists = this.copyXmlReport(coverageReportDir, buildTarget, listener, env.expand(this.getCloverReportFileName()));
            if (htmlExists) {
                run.addAction((Action)new CloverHtmlBuildAction(buildTarget));
            }
            this.processCloverXml(run, workspace, listener, coverageReportDir, buildTarget);
        }
        catch (IOException e) {
            Util.displayIOException((IOException)e, (TaskListener)listener);
            e.printStackTrace(listener.fatalError("Unable to copy coverage from " + coverageReportDir + " to " + buildTarget));
            run.setResult(Result.FAILURE);
        }
    }

    private void processCloverXml(Run<?, ?> build, FilePath workspace, TaskListener listener, FilePath coverageReport, FilePath buildTarget) throws InterruptedException {
        listener.getLogger().println("Processing Clover XML report ...");
        String workspacePath = this.withTrailingSeparator(this.getWorkspacePath(listener, workspace));
        File cloverXmlReport = CloverPublisher.getCloverXmlReport(build);
        if (cloverXmlReport.exists()) {
            ProjectCoverage result = null;
            try {
                result = CloverCoverageParser.parse(cloverXmlReport, workspacePath);
            }
            catch (IOException e) {
                Util.displayIOException((IOException)e, (TaskListener)listener);
                e.printStackTrace(listener.fatalError("Unable to copy coverage from " + coverageReport + " to " + buildTarget));
                build.setResult(Result.FAILURE);
            }
            listener.getLogger().println("Publishing Clover coverage results...");
            build.addAction((Action)CloverBuildAction.load(workspacePath, result, this.healthyTarget, this.unhealthyTarget));
            Set<CoverageMetric> failingMetrics = this.getFailingMetrics(result);
            if (!failingMetrics.isEmpty()) {
                this.logFailingMetrics(listener, failingMetrics);
                build.setResult(Result.UNSTABLE);
            }
        } else {
            this.flagMissingCloverXml(listener, build);
        }
    }

    @Nonnull
    private String getWorkspacePath(TaskListener listener, FilePath workspace) throws InterruptedException {
        try {
            return (String)workspace.act((FilePath.FileCallable)new GetPathFileCallable());
        }
        catch (IOException e) {
            listener.getLogger().println("IOException when checking workspace path:" + e.getMessage());
            return "";
        }
    }

    @Nonnull
    private String withTrailingSeparator(@Nonnull String path) {
        return path.endsWith(File.separator) ? path : path + File.separator;
    }

    @Nonnull
    private Set<CoverageMetric> getFailingMetrics(ProjectCoverage result) {
        return this.failingTarget != null ? this.failingTarget.getFailingMetrics(result) : Collections.emptySet();
    }

    private void logFailingMetrics(TaskListener listener, Set<CoverageMetric> failingMetrics) {
        listener.getLogger().println("Code coverage enforcement failed for the following metrics:");
        for (CoverageMetric metric : failingMetrics) {
            listener.getLogger().println("    " + (Object)((Object)metric));
        }
        listener.getLogger().println("Setting Build to unstable.");
    }

    private boolean copyXmlReport(FilePath coverageReport, FilePath buildTarget, TaskListener listener, String fileName) throws IOException, InterruptedException {
        FilePath cloverXmlPath = this.findOneDirDeep(coverageReport, fileName);
        if (cloverXmlPath.exists()) {
            listener.getLogger().println("Publishing Clover XML report...");
            FilePath toFile = buildTarget.child("clover.xml");
            cloverXmlPath.copyTo(toFile);
            return true;
        }
        listener.getLogger().println(String.format("Clover XML file '%s' does not exist in '%s' and was not copied!", fileName, coverageReport));
        return false;
    }

    private boolean copyHtmlReport(FilePath coverageReport, FilePath buildTarget, TaskListener listener) throws IOException, InterruptedException {
        FilePath htmlIndexHtmlPath = this.findOneDirDeep(coverageReport, "index.html");
        if (htmlIndexHtmlPath.exists()) {
            FilePath htmlDirPath = htmlIndexHtmlPath.getParent();
            listener.getLogger().println("Publishing Clover HTML report...");
            htmlDirPath.copyRecursiveTo("**/*", buildTarget);
            return true;
        }
        listener.getLogger().println(String.format("Clover HTML report '%s' does not exist and was not copied!", coverageReport));
        return false;
    }

    private FilePath findOneDirDeep(FilePath startDir, String filename) throws IOException, InterruptedException {
        List dirs;
        FilePath dirContainingFile = startDir;
        if (!dirContainingFile.child(filename).exists() && (dirs = dirContainingFile.listDirectories()) != null) {
            for (FilePath dir : dirs) {
                if (!dir.child(filename).exists()) continue;
                dirContainingFile = dir;
                break;
            }
        }
        return dirContainingFile.child(filename);
    }

    private void flagMissingCloverXml(TaskListener listener, Run<?, ?> build) {
        listener.getLogger().println("Could not find '" + this.cloverReportDir + "/" + this.getCloverReportFileName() + "'.  Did you generate the XML report for Clover?");
    }

    public BuildStepDescriptor<Publisher> getDescriptor() {
        return DESCRIPTOR;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.BUILD;
    }

    public static final class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        DescriptorImpl() {
            super(CloverPublisher.class);
        }

        public String getDisplayName() {
            return Messages.CloverPublisher_DisplayName();
        }

        public boolean configure(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            req.bindParameters((Object)this, "clover.");
            this.save();
            return super.configure(req, formData);
        }

        public CloverPublisher newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            CloverPublisher instance = new CloverPublisher(req.getParameter("clover.cloverReportDir"), req.getParameter("clover.cloverReportFileName"), this.fromRequest(req, "cloverHealthyTarget."), this.fromRequest(req, "cloverUnhealthyTarget."), this.fromRequest(req, "cloverFailingTarget."));
            if (instance.healthyTarget.isEmpty()) {
                instance.healthyTarget = new CoverageTarget(70, 80, 80);
            }
            return instance;
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        private CoverageTarget fromRequest(StaplerRequest req, String namePrefix) {
            return new CoverageTarget(this.getIntParameter(req, namePrefix + "methodCoverage"), this.getIntParameter(req, namePrefix + "conditionalCoverage"), this.getIntParameter(req, namePrefix + "statementCoverage"));
        }

        private Integer getIntParameter(StaplerRequest req, String name) {
            try {
                return Integer.valueOf(req.getParameter(name));
            }
            catch (NumberFormatException ex) {
                return null;
            }
        }
    }
}

