/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.clover;

import hudson.FilePath;
import hudson.model.Actionable;
import hudson.model.DirectoryBrowserSupport;
import hudson.model.Job;
import hudson.model.ModelObject;
import hudson.model.ProminentProjectAction;
import hudson.model.Result;
import hudson.model.Run;
import hudson.plugins.clover.CloverBuildAction;
import hudson.plugins.clover.Messages;
import hudson.util.Graph;
import java.io.File;
import java.io.IOException;
import javax.servlet.ServletException;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

public class CloverProjectAction
extends Actionable
implements ProminentProjectAction {
    static final String ICON = "/plugin/clover/clover_48x48.png";
    private final transient Job<?, ?> project;

    public CloverProjectAction(Job<?, ?> project) {
        this.project = project;
    }

    public String getIconFileName() {
        File reportDir = this.getLastBuildReportDir();
        if (reportDir != null && (new File(reportDir, "index.html").exists() || new File(reportDir, "clover.pdf").exists() || new File(reportDir, "clover.xml").exists())) {
            return ICON;
        }
        return null;
    }

    private File getLastBuildReportDir() {
        if (this.project.getLastBuild() == null) {
            return null;
        }
        File reportDir = this.project.getLastBuild().getRootDir();
        return reportDir;
    }

    public String getDisplayName() {
        File reportDir = this.getLastBuildReportDir();
        if (reportDir == null) {
            return null;
        }
        if (new File(reportDir, "index.html").exists()) {
            return Messages.CloverProjectAction_HTML_DisplayName();
        }
        if (new File(reportDir, "clover.pdf").exists()) {
            return Messages.CloverProjectAction_PDF_DisplayName();
        }
        if (new File(reportDir, "clover.xml").exists()) {
            return Messages.CloverProjectAction_XML_DisplayName();
        }
        return null;
    }

    public String getUrlName() {
        return "clover";
    }

    public CloverBuildAction getLastSuccessfulResult() {
        for (Run b = this.project.getLastBuild(); b != null; b = b.getPreviousBuild()) {
            CloverBuildAction r;
            if (b.getResult() == Result.FAILURE || (r = (CloverBuildAction)b.getAction(CloverBuildAction.class)) == null) continue;
            return r;
        }
        return null;
    }

    public Graph getTrendGraph() {
        CloverBuildAction action = this.getLastSuccessfulResult();
        if (action != null) {
            return action.getResult().getTrendGraph();
        }
        return null;
    }

    public DirectoryBrowserSupport doDynamic(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException, InterruptedException {
        if (this.project.getLastBuild() != null && this.getDisplayName() != null) {
            return new DirectoryBrowserSupport((ModelObject)this, new FilePath(this.project.getLastBuild().getRootDir()), "Clover Html Report", "/clover/clover.gif", false);
        }
        return null;
    }

    public String getSearchUrl() {
        return this.getUrlName();
    }
}

