/*
 * Decompiled with CFR 0.152.
 */
package com.hpe.cloudfoundryjenkins;

import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardUsernamePasswordCredentials;
import com.cloudbees.plugins.credentials.domains.URIRequirementBuilder;
import com.hpe.cloudfoundryjenkins.CloudFoundryPushPublisher;
import com.hpe.cloudfoundryjenkins.CloudFoundryPushTask;
import hudson.ProxyConfiguration;
import hudson.model.ItemGroup;
import hudson.model.TaskListener;
import hudson.security.ACL;
import hudson.util.FormValidation;
import hudson.util.Secret;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.net.ssl.SSLPeerUnverifiedException;
import jenkins.model.Jenkins;
import org.acegisecurity.Authentication;
import org.apache.commons.lang.StringUtils;
import org.cloudfoundry.client.v2.ClientV2Exception;
import org.cloudfoundry.client.v2.info.GetInfoRequest;
import org.cloudfoundry.reactor.ConnectionContext;
import org.cloudfoundry.reactor.TokenProvider;
import org.cloudfoundry.reactor.client.ReactorCloudFoundryClient;
import org.cloudfoundry.reactor.tokenprovider.PasswordGrantTokenProvider;

public class CloudFoundryUtils {
    static final String DEFAULT_MANIFEST_PATH = "manifest.yml";
    static final int DEFAULT_PLUGIN_TIMEOUT = 120;

    static Optional<org.cloudfoundry.reactor.ProxyConfiguration> buildProxyConfiguration(URL targetURL) {
        Jenkins jenkins = Jenkins.getInstance();
        if (jenkins == null) {
            return Optional.empty();
        }
        ProxyConfiguration proxyConfig = jenkins.proxy;
        if (proxyConfig == null) {
            return Optional.empty();
        }
        String host = targetURL.getHost();
        for (Pattern p : proxyConfig.getNoProxyHostPatterns()) {
            if (!p.matcher(host).matches()) continue;
            return Optional.empty();
        }
        return Optional.of(org.cloudfoundry.reactor.ProxyConfiguration.builder().host(proxyConfig.name).port(proxyConfig.port).build());
    }

    static FormValidation doTestConnection(ItemGroup context, String target, String credentialsId, String organization, String cloudSpace, String selfSigned) {
        try {
            List standardCredentials = CredentialsProvider.lookupCredentials(StandardUsernamePasswordCredentials.class, (ItemGroup)context, (Authentication)ACL.SYSTEM, (List)URIRequirementBuilder.fromUri((String)target).build());
            StandardUsernamePasswordCredentials credentials = (StandardUsernamePasswordCredentials)CredentialsMatchers.firstOrNull((Iterable)standardCredentials, (CredentialsMatcher)CredentialsMatchers.withId((String)credentialsId));
            CloudFoundryPushTask task = new CloudFoundryPushTask(target, organization, cloudSpace, credentialsId, selfSigned, String.valueOf(120), Collections.emptyList(), CloudFoundryPushPublisher.ManifestChoice.defaultManifestFileConfig());
            ConnectionContext connectionContext = task.createConnectionContext(null, null, TaskListener.NULL);
            PasswordGrantTokenProvider.Builder tokenProviderBuilder = PasswordGrantTokenProvider.builder();
            if (credentials != null) {
                tokenProviderBuilder = tokenProviderBuilder.username(credentials.getUsername()).password(Secret.toString((Secret)credentials.getPassword()));
            }
            PasswordGrantTokenProvider tokenProvider = tokenProviderBuilder.build();
            ReactorCloudFoundryClient client = ReactorCloudFoundryClient.builder().connectionContext(connectionContext).tokenProvider((TokenProvider)tokenProvider).build();
            client.info().get(GetInfoRequest.builder().build()).timeout(Duration.ofSeconds(120L)).block();
            URL targetUrl = task.targetUrl(target);
            ArrayList<String> warnings = new ArrayList<String>();
            if (!targetUrl.getHost().startsWith("api.")) {
                warnings.add("Your target's hostname does not start with \"api.\".<br />Make sure it is the real API endpoint and not a redirection, or it may cause some problems.");
            }
            if (!StringUtils.isEmpty((String)targetUrl.getPath()) && !targetUrl.getPath().equals("/")) {
                warnings.add("Your target specifies a path which will be ignored when making CloudFoundry API calls");
            }
            if (warnings.isEmpty()) {
                return FormValidation.okWithMarkup((String)"<b>Connection successful!</b>");
            }
            return FormValidation.warningWithMarkup((String)("Connection successful, but:<ul><li>" + warnings.stream().collect(Collectors.joining("</li><li>")) + "</li></ul>"));
        }
        catch (MalformedURLException e) {
            return FormValidation.error((String)"Malformed target URL");
        }
        catch (RuntimeException e) {
            Throwable cause;
            Throwable throwable = cause = e.getCause() != null ? e.getCause() : e;
            if (cause instanceof ClientV2Exception) {
                return FormValidation.error((String)"Client error. Code=%i, Error Code=%s, Description=%s", (Object[])new Object[]{((ClientV2Exception)e).getCode(), ((ClientV2Exception)e).getErrorCode(), ((ClientV2Exception)e).getDescription()});
            }
            if (cause instanceof UnknownHostException) {
                return FormValidation.error((String)"Unknown host");
            }
            if (cause instanceof SSLPeerUnverifiedException) {
                return FormValidation.error((String)"Target's certificate is not verified (Add it to Java's keystore, or check the \"Allow self-signed\" box)");
            }
            return FormValidation.error((Throwable)e, (String)"Unknown error");
        }
        catch (Exception e) {
            return FormValidation.error((Throwable)e, (String)"Unknown Exception");
        }
    }
}

