/*
 * Decompiled with CFR 0.152.
 */
package com.hpe.cloudfoundryjenkins;

import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardUsernamePasswordCredentials;
import com.cloudbees.plugins.credentials.domains.URIRequirementBuilder;
import com.hpe.cloudfoundryjenkins.CloudFoundryPushPublisher;
import com.hpe.cloudfoundryjenkins.CloudFoundryUtils;
import com.hpe.cloudfoundryjenkins.ManifestUtils;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.Item;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.security.ACL;
import hudson.util.Secret;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.acegisecurity.Authentication;
import org.apache.commons.lang.StringUtils;
import org.cloudfoundry.client.CloudFoundryClient;
import org.cloudfoundry.doppler.DopplerClient;
import org.cloudfoundry.operations.CloudFoundryOperations;
import org.cloudfoundry.operations.DefaultCloudFoundryOperations;
import org.cloudfoundry.operations.applications.ApplicationManifest;
import org.cloudfoundry.operations.applications.LogsRequest;
import org.cloudfoundry.operations.applications.PushApplicationManifestRequest;
import org.cloudfoundry.operations.services.CreateServiceInstanceRequest;
import org.cloudfoundry.operations.services.DeleteServiceInstanceRequest;
import org.cloudfoundry.reactor.ConnectionContext;
import org.cloudfoundry.reactor.DefaultConnectionContext;
import org.cloudfoundry.reactor.TokenProvider;
import org.cloudfoundry.reactor.client.ReactorCloudFoundryClient;
import org.cloudfoundry.reactor.doppler.ReactorDopplerClient;
import org.cloudfoundry.reactor.tokenprovider.PasswordGrantTokenProvider;
import org.cloudfoundry.reactor.uaa.ReactorUaaClient;
import org.cloudfoundry.uaa.UaaClient;
import org.jenkinsci.plugins.tokenmacro.MacroEvaluationException;
import org.jenkinsci.plugins.tokenmacro.TokenMacro;
import reactor.core.publisher.Flux;

public class CloudFoundryPushTask {
    private final String target;
    private final String organization;
    private final String cloudSpace;
    private final String credentialsId;
    private final String selfSigned;
    private final String pluginTimeout;
    private final List<CloudFoundryPushPublisher.Service> servicesToCreate;
    private final CloudFoundryPushPublisher.ManifestChoice manifestChoice;
    private static final Pattern TARGET_PATTERN = Pattern.compile("((?<scheme>https?)://)?(?<targetFqdn>[^:/]+)(:(?<port>\\d+))?(/.*)?");

    public CloudFoundryPushTask(String target, String organization, String cloudSpace, String credentialsId, String selfSigned, String pluginTimeout, List<CloudFoundryPushPublisher.Service> servicesToCreate, CloudFoundryPushPublisher.ManifestChoice manifestChoice) {
        this.target = target;
        this.organization = organization;
        this.cloudSpace = cloudSpace;
        this.credentialsId = credentialsId;
        this.selfSigned = selfSigned;
        this.pluginTimeout = pluginTimeout;
        this.servicesToCreate = servicesToCreate;
        this.manifestChoice = manifestChoice;
    }

    public boolean perform(FilePath workspace, Run run, Launcher launcher, TaskListener listener) {
        if (workspace == null) {
            throw new IllegalStateException("Workspace cannot be null");
        }
        listener.getLogger().println("Cloud Foundry Plugin:");
        try {
            List standardCredentials = CredentialsProvider.lookupCredentials(StandardUsernamePasswordCredentials.class, (Item)run.getParent(), (Authentication)ACL.SYSTEM, (List)URIRequirementBuilder.fromUri((String)TokenMacro.expandAll((Run)run, (FilePath)workspace, (TaskListener)listener, (String)this.target)).build());
            StandardUsernamePasswordCredentials credentials = (StandardUsernamePasswordCredentials)CredentialsMatchers.firstOrNull((Iterable)standardCredentials, (CredentialsMatcher)CredentialsMatchers.withId((String)TokenMacro.expandAll((Run)run, (FilePath)workspace, (TaskListener)listener, (String)this.credentialsId)));
            if (credentials == null) {
                listener.getLogger().println("ERROR: No credentials have been given.");
                return false;
            }
            ConnectionContext connectionContext = this.createConnectionContext(run, workspace, listener);
            PasswordGrantTokenProvider tokenProvider = PasswordGrantTokenProvider.builder().username(credentials.getUsername()).password(Secret.toString((Secret)credentials.getPassword())).build();
            ReactorCloudFoundryClient client = ReactorCloudFoundryClient.builder().connectionContext(connectionContext).tokenProvider((TokenProvider)tokenProvider).build();
            ReactorDopplerClient dopplerClient = ReactorDopplerClient.builder().connectionContext(connectionContext).tokenProvider((TokenProvider)tokenProvider).build();
            ReactorUaaClient uaaClient = ReactorUaaClient.builder().connectionContext(connectionContext).tokenProvider((TokenProvider)tokenProvider).build();
            DefaultCloudFoundryOperations cloudFoundryOperations = DefaultCloudFoundryOperations.builder().cloudFoundryClient((CloudFoundryClient)client).dopplerClient((DopplerClient)dopplerClient).uaaClient((UaaClient)uaaClient).organization(TokenMacro.expandAll((Run)run, (FilePath)workspace, (TaskListener)listener, (String)this.organization)).space(TokenMacro.expandAll((Run)run, (FilePath)workspace, (TaskListener)listener, (String)this.cloudSpace)).build();
            Flux currentServicesList = cloudFoundryOperations.services().listInstances();
            List currentServicesNames = (List)currentServicesList.map(service -> service.getName()).collectList().block();
            for (CloudFoundryPushPublisher.Service service2 : this.servicesToCreate) {
                String serviceName = TokenMacro.expandAll((Run)run, (FilePath)workspace, (TaskListener)listener, (String)service2.name);
                boolean createService = true;
                if (currentServicesNames.contains(serviceName)) {
                    if (service2.resetService) {
                        listener.getLogger().println("Service " + serviceName + " already exists, resetting.");
                        cloudFoundryOperations.services().deleteInstance(DeleteServiceInstanceRequest.builder().name(serviceName).build()).block();
                        listener.getLogger().println("Service deleted.");
                    } else {
                        createService = false;
                        listener.getLogger().println("Service " + serviceName + " already exists, skipping creation.");
                    }
                }
                if (!createService) continue;
                listener.getLogger().println("Creating service " + serviceName);
                cloudFoundryOperations.services().createInstance(CreateServiceInstanceRequest.builder().serviceName(TokenMacro.expandAll((Run)run, (FilePath)workspace, (TaskListener)listener, (String)service2.type)).serviceInstanceName(serviceName).planName(TokenMacro.expandAll((Run)run, (FilePath)workspace, (TaskListener)listener, (String)service2.plan)).build()).block();
            }
            FilePath masterPath = this.pathOnMaster(workspace);
            boolean isOnSlave = false;
            if (masterPath == null || !masterPath.equals((Object)workspace)) {
                masterPath = this.transferArtifactsToMaster(masterPath, workspace, this.manifestChoice, listener);
                isOnSlave = true;
            }
            List<ApplicationManifest> manifests = ManifestUtils.loadManifests(masterPath, this.manifestChoice, isOnSlave, run, workspace, listener);
            String s = TokenMacro.expandAll((Run)run, (FilePath)workspace, (TaskListener)listener, (String)this.pluginTimeout);
            long opTimeout = StringUtils.isBlank((String)s) ? 0L : Long.parseLong(s);
            for (ApplicationManifest manifest : manifests) {
                cloudFoundryOperations.applications().pushManifest(PushApplicationManifestRequest.builder().manifest(manifest).build()).timeout(Duration.ofSeconds(opTimeout)).doOnError(e -> e.printStackTrace(listener.getLogger())).block();
                this.printStagingLogs((CloudFoundryOperations)cloudFoundryOperations, listener, manifest.getName(), opTimeout);
            }
            if (!masterPath.equals((Object)workspace)) {
                masterPath.deleteRecursive();
            }
            return true;
        }
        catch (MalformedURLException e2) {
            listener.getLogger().println("ERROR: The target URL is not valid: " + e2.getMessage());
            return false;
        }
        catch (IOException e3) {
            listener.getLogger().println("ERROR: IOException: " + e3.getMessage());
            return false;
        }
        catch (InterruptedException e4) {
            listener.getLogger().println("ERROR: InterruptedException: " + e4.getMessage());
            return false;
        }
        catch (Exception e5) {
            e5.printStackTrace(listener.getLogger());
            return false;
        }
    }

    private FilePath pathOnMaster(FilePath path) throws IOException, InterruptedException {
        if (path.getChannel() != FilePath.localChannel) {
            File tempFile = Files.createTempDirectory("appDir", new FileAttribute[0]).toFile();
            tempFile.deleteOnExit();
            return new FilePath(tempFile);
        }
        return path;
    }

    private FilePath transferArtifactsToMaster(FilePath masterPath, FilePath workspacePath, CloudFoundryPushPublisher.ManifestChoice manifestChoice, TaskListener listener) throws IOException, InterruptedException {
        FilePath results = masterPath;
        if (masterPath != null && !masterPath.equals((Object)workspacePath)) {
            listener.getLogger().println("INFO: Looks like we are on a distributed system... Transferring build artifacts from the slave to the master.");
            FilePath appPath = new FilePath(workspacePath, manifestChoice.appPath == null ? "" : manifestChoice.appPath);
            FilePath zipFilePath = new FilePath(masterPath, "appFile");
            try (FileOutputStream outputStream = new FileOutputStream(Paths.get(zipFilePath.toURI()).toFile());){
                listener.getLogger().println(String.format("INFO: Transferring from %s to %s", appPath.getRemote(), masterPath.getRemote()));
                appPath.zip((OutputStream)outputStream);
            }
            zipFilePath.unzip(masterPath);
            try {
                zipFilePath.delete();
            }
            catch (IOException ex) {
                listener.getLogger().println("WARNING: temporary files were not deleted successfully.");
            }
            File[] listFiles = new File(masterPath.toURI()).listFiles();
            if (listFiles != null && listFiles.length == 1) {
                results = new FilePath(listFiles[0]);
            } else {
                throw new IllegalStateException("Unzipped output directory was empty.");
            }
        }
        return results;
    }

    private void printStagingLogs(CloudFoundryOperations cloudFoundryOperations, TaskListener listener, String appName, long printStagingLogsTimeout) {
        cloudFoundryOperations.applications().logs(LogsRequest.builder().name(appName).recent(Boolean.TRUE).build()).timeout(Duration.ofSeconds(printStagingLogsTimeout)).doOnNext(applicationLog -> listener.getLogger().println(applicationLog.getMessage())).blockLast();
    }

    protected URL targetUrl(String tokenExpandedTarget) throws MalformedURLException {
        String scheme = "https";
        String targetFqdn = tokenExpandedTarget;
        Integer port = null;
        Matcher targetMatcher = TARGET_PATTERN.matcher(this.target);
        if (targetMatcher.find()) {
            if (targetMatcher.group("scheme") != null) {
                scheme = targetMatcher.group("scheme");
            }
            targetFqdn = targetMatcher.group("targetFqdn");
            String portNumber = targetMatcher.group("port");
            if (portNumber != null) {
                port = Integer.parseInt(portNumber);
            }
        }
        StringBuilder sb = new StringBuilder(scheme).append("://").append(targetFqdn);
        if (port != null) {
            sb = sb.append(":").append(port.toString());
        }
        return new URL(sb.toString());
    }

    protected ConnectionContext createConnectionContext(Run run, FilePath workspace, TaskListener listener) throws MalformedURLException, MacroEvaluationException, IOException, InterruptedException {
        String tokenExpandedTarget;
        String scheme = "https";
        Boolean secure = null;
        String targetFqdn = tokenExpandedTarget = run != null ? TokenMacro.expandAll((Run)run, (FilePath)workspace, (TaskListener)listener, (String)this.target) : this.target;
        Integer port = null;
        Matcher targetMatcher = TARGET_PATTERN.matcher(targetFqdn);
        if (targetMatcher.find()) {
            if (targetMatcher.group("scheme") != null && !(secure = Boolean.valueOf((scheme = targetMatcher.group("scheme")).endsWith("s"))).booleanValue()) {
                port = 80;
            }
            targetFqdn = targetMatcher.group("targetFqdn");
            String portNumber = targetMatcher.group("port");
            if (portNumber != null) {
                port = Integer.parseInt(portNumber);
            }
        }
        String skipSslValidation = run != null ? TokenMacro.expandAll((Run)run, (FilePath)workspace, (TaskListener)listener, (String)this.selfSigned) : this.selfSigned;
        DefaultConnectionContext.Builder builder = DefaultConnectionContext.builder().apiHost(targetFqdn).proxyConfiguration(CloudFoundryUtils.buildProxyConfiguration(this.targetUrl(tokenExpandedTarget))).skipSslValidation(Boolean.parseBoolean(skipSslValidation));
        if (secure != null) {
            builder = builder.secure(secure.booleanValue());
        }
        if (port != null) {
            builder = builder.port(port.intValue());
        }
        return builder.build();
    }
}

