/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.plugins.advisor.client.model;

import com.cloudbees.jenkins.plugins.advisor.utils.EmailUtil;
import com.cloudbees.jenkins.plugins.advisor.utils.EmailValidator;
import hudson.Extension;
import hudson.RelativePath;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import hudson.util.FormValidation;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class Recipient
extends AbstractDescribableImpl<Recipient> {
    private String email;

    @DataBoundConstructor
    public Recipient(String email) {
        this.email = EmailUtil.fixEmptyAndTrimAllSpaces(email);
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = EmailUtil.fixEmptyAndTrimAllSpaces(email);
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<Recipient> {
        public String getDisplayName() {
            return "";
        }

        public FormValidation doCheckEmail(@QueryParameter String value) {
            return EmailValidator.validateEmail(value);
        }

        public FormValidation doTestSendEmail(@QueryParameter(value="email") String value, @RelativePath(value="..") @QueryParameter(value="acceptToS") boolean acceptToS) {
            return EmailValidator.testSendEmail(value, acceptToS);
        }
    }
}

