/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.plugins.advisor;

import com.cloudbees.jenkins.plugins.advisor.AdvisorGlobalConfiguration;
import com.cloudbees.jenkins.plugins.advisor.Messages;
import hudson.Extension;
import hudson.model.AdministrativeMonitor;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.HttpResponses;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.interceptor.RequirePOST;

@Extension
public class BundleUploadMonitor
extends AdministrativeMonitor {
    public boolean isActivated() {
        AdvisorGlobalConfiguration config = AdvisorGlobalConfiguration.getInstance();
        return config.isPluginEnabled() && config.getLastBundleResult() != null && (config.getLastBundleResult().contains("ERROR") || config.getLastBundleResult().contains("Bundle upload failed"));
    }

    public String getDisplayName() {
        return Messages.BundleUploadMonitor_DisplayName();
    }

    @Restricted(value={NoExternalUse.class})
    @RequirePOST
    public HttpResponse doAct(@QueryParameter(fixEmpty=true) String yes) {
        AdvisorGlobalConfiguration config = AdvisorGlobalConfiguration.getInstance();
        return yes != null ? HttpResponses.redirectViaContextPath((String)config.getUrlName()) : HttpResponses.forwardToPreviousPage();
    }

    public String getFailureMessage() {
        return AdvisorGlobalConfiguration.getInstance().getLastBundleResult();
    }
}

