/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.hudson.plugins.folder;

import com.cloudbees.hudson.plugins.folder.AbstractFolder;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.BulkChange;
import hudson.model.TopLevelItem;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang.StringUtils;

public abstract class ChildNameGenerator<P extends AbstractFolder<I>, I extends TopLevelItem> {
    private static final Logger LOGGER = Logger.getLogger(ChildNameGenerator.class.getName());
    public static final String CHILD_NAME_FILE = "name-utf8.txt";
    private static final Map<Trace, String> idealNames = new WeakHashMap<Trace, String>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public static Trace beforeCreateItem(@NonNull AbstractFolder<?> project, @NonNull String itemName, @NonNull String idealName) {
        Trace trace = new Trace(project, itemName);
        Map<Trace, String> map = idealNames;
        synchronized (map) {
            idealNames.put(trace, idealName);
        }
        return trace;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void afterItemCreated(@NonNull Trace trace) {
        Map<Trace, String> map = idealNames;
        synchronized (map) {
            idealNames.remove(trace);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CheckForNull
    protected final String idealNameFromItem(@NonNull P parent, @NonNull I item) {
        String itemName = item.getName();
        if (itemName == null) {
            return null;
        }
        Map<Trace, String> map = idealNames;
        synchronized (map) {
            return idealNames.get(new Trace((AbstractFolder<?>)((Object)parent), itemName));
        }
    }

    @CheckForNull
    public abstract String itemNameFromItem(@NonNull P var1, @NonNull I var2);

    @CheckForNull
    public abstract String dirNameFromItem(@NonNull P var1, @NonNull I var2);

    @NonNull
    final String dirName(@NonNull P parent, @NonNull I item) {
        String name = this.dirNameFromItem(parent, item);
        if (name == null) {
            name = this.dirNameFromLegacy(parent, item.getName());
        }
        return name;
    }

    @NonNull
    final ResultWithOptionalSave<File> ensureItemDirectory(@NonNull P parent, @NonNull I item, @NonNull File legacyDir) throws IOException {
        File newSubdir;
        String legacyName = legacyDir.getName();
        String dirName = this.dirNameFromItem(parent, item);
        boolean itemNeedsSave = false;
        if (dirName == null) {
            dirName = this.dirNameFromLegacy(parent, legacyName);
            newSubdir = ((AbstractFolder)((Object)parent)).getRootDirFor(dirName);
            if (!legacyName.equals(dirName)) {
                try (BulkChange ignored = new BulkChange(item);){
                    this.recordLegacyName(parent, item, legacyName);
                    itemNeedsSave = true;
                }
                catch (IOException e) {
                    throw new IOException("Failed to load " + dirName + " as could not record legacy name", e);
                }
            }
        } else {
            newSubdir = ((AbstractFolder)((Object)parent)).getRootDirFor(dirName);
        }
        if (!legacyName.equals(dirName)) {
            if (!newSubdir.exists()) {
                LOGGER.log(Level.INFO, () -> "Moving " + legacyDir + " to " + newSubdir + " in accordance with folder naming rules");
                if (!legacyDir.renameTo(newSubdir)) {
                    throw new IOException("Failed to move " + legacyDir + " to " + newSubdir);
                }
            } else {
                throw new IOException("Cannot move " + legacyDir + " to " + newSubdir + " as it already exists");
            }
        }
        return new ResultWithOptionalSave<File>(newSubdir, itemNeedsSave);
    }

    @NonNull
    public abstract String itemNameFromLegacy(@NonNull P var1, @NonNull String var2);

    @NonNull
    public abstract String dirNameFromLegacy(@NonNull P var1, @NonNull String var2);

    public abstract void recordLegacyName(P var1, I var2, String var3) throws IOException;

    @NonNull
    public final String readItemName(@NonNull File directory) {
        String childName = directory.getName();
        File nameFile = new File(directory, CHILD_NAME_FILE);
        if (nameFile.isFile()) {
            try {
                childName = StringUtils.defaultString((String)StringUtils.trimToNull((String)Files.readString(nameFile.toPath(), StandardCharsets.UTF_8)), (String)directory.getName());
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, () -> "Could not read " + nameFile + ", assuming child name is " + directory.getName());
            }
        }
        return childName;
    }

    @NonNull
    public final ResultWithOptionalSave<String> writeItemName(@NonNull P parent, @NonNull I item, @NonNull File itemDirectory, @NonNull String childName) {
        boolean itemNeedsSave = false;
        String name = this.itemNameFromItem(parent, item);
        if (name == null && !childName.equals(name = this.itemNameFromLegacy(parent, childName))) {
            try (BulkChange ignored = new BulkChange(item);){
                this.recordLegacyName(parent, item, childName);
                itemNeedsSave = true;
            }
            catch (IOException e) {
                throw new UncheckedIOException("Failed to load " + name + " as could not record legacy name", e);
            }
        }
        File nameFile = new File(itemDirectory, CHILD_NAME_FILE);
        try {
            Path itemPath = itemDirectory.toPath();
            if (Files.notExists(itemPath, new LinkOption[0])) {
                Files.createDirectories(itemPath, new FileAttribute[0]);
            }
            Files.writeString(nameFile.toPath(), (CharSequence)name, StandardCharsets.UTF_8, new OpenOption[0]);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to load " + name + " as could not write " + nameFile, e);
        }
        return new ResultWithOptionalSave<String>(name, itemNeedsSave);
    }

    public static final class Trace
    implements Closeable {
        @NonNull
        private final AbstractFolder<?> folder;
        @NonNull
        private final String itemName;

        private Trace(@NonNull AbstractFolder<?> folder, @NonNull String itemName) {
            this.folder = folder;
            this.itemName = itemName;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Trace that = (Trace)o;
            return this.folder == that.folder && this.itemName.equals(that.itemName);
        }

        public int hashCode() {
            int result = ((Object)this.folder).hashCode();
            result = 31 * result + this.itemName.hashCode();
            return result;
        }

        @Override
        public void close() {
            ChildNameGenerator.afterItemCreated(this);
        }
    }

    static class ResultWithOptionalSave<I> {
        private final I wrapped;
        private final boolean itemNeedsSave;

        private ResultWithOptionalSave(I wrapped, boolean itemNeedsSave) {
            this.wrapped = wrapped;
            this.itemNeedsSave = itemNeedsSave;
        }

        I getWrapped() {
            return this.wrapped;
        }

        boolean isItemNeedsSave() {
            return this.itemNeedsSave;
        }

        public String toString() {
            return "FileResult{file=" + this.wrapped + ", itemNeedsSave=" + this.itemNeedsSave + "}";
        }
    }
}

