/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.hudson.plugins.folder.computed;

import com.cloudbees.hudson.plugins.folder.computed.ComputedFolder;
import com.cloudbees.hudson.plugins.folder.computed.FolderComputation;
import com.cloudbees.hudson.plugins.folder.computed.Messages;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Extension;
import hudson.Util;
import hudson.model.Cause;
import hudson.model.Item;
import hudson.model.Items;
import hudson.triggers.TimerTrigger;
import hudson.triggers.Trigger;
import hudson.triggers.TriggerDescriptor;
import hudson.util.ListBoxModel;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;

@SuppressFBWarnings(value={"DMI_RANDOM_USED_ONLY_ONCE"})
public class PeriodicFolderTrigger
extends Trigger<ComputedFolder<?>> {
    private static final Logger LOGGER = Logger.getLogger(PeriodicFolderTrigger.class.getName());
    private final long interval;

    @DataBoundConstructor
    public PeriodicFolderTrigger(String interval) {
        super(PeriodicFolderTrigger.toCrontab(interval));
        long intervalMillis;
        this.interval = intervalMillis = PeriodicFolderTrigger.toIntervalMillis(interval);
    }

    private static String toCrontab(String interval) {
        long millis = PeriodicFolderTrigger.toIntervalMillis(interval);
        if (millis <= TimeUnit.MINUTES.toMillis(5L)) {
            return "* * * * *";
        }
        if (millis <= TimeUnit.MINUTES.toMillis(30L)) {
            return "H/5 * * * *";
        }
        if (millis <= TimeUnit.HOURS.toMillis(1L)) {
            return "H/15 * * * *";
        }
        if (millis <= TimeUnit.HOURS.toMillis(8L)) {
            return "H/30 * * * *";
        }
        if (millis <= TimeUnit.DAYS.toMillis(1L)) {
            return "H H/4 * * *";
        }
        if (millis <= TimeUnit.DAYS.toMillis(2L)) {
            return "H H/12 * * *";
        }
        return "H H * * *";
    }

    private static long toIntervalMillis(String interval) {
        TimeUnit units = TimeUnit.MINUTES;
        if ((interval = interval.toLowerCase()).endsWith("h")) {
            units = TimeUnit.HOURS;
            interval = StringUtils.removeEnd((String)interval, (String)"h");
        }
        if (interval.endsWith("m")) {
            interval = StringUtils.removeEnd((String)interval, (String)"m");
        } else if (interval.endsWith("d")) {
            units = TimeUnit.DAYS;
            interval = StringUtils.removeEnd((String)interval, (String)"d");
        } else if (interval.endsWith("ms")) {
            units = TimeUnit.SECONDS;
            interval = StringUtils.removeEnd((String)interval, (String)"ms");
        } else if (interval.endsWith("s")) {
            units = TimeUnit.SECONDS;
            interval = StringUtils.removeEnd((String)interval, (String)"s");
        }
        long value = 0L;
        try {
            value = Long.parseLong(interval);
        }
        catch (NumberFormatException e) {
            value = 1L;
        }
        return Math.min(TimeUnit.DAYS.toMillis(30L), Math.max(TimeUnit.MINUTES.toMillis(1L), units.toMillis(value)));
    }

    public long getIntervalMillis() {
        return this.interval;
    }

    public String getInterval() {
        if (this.interval < TimeUnit.SECONDS.toMillis(1L)) {
            return Long.toString(this.interval) + "ms";
        }
        if (this.interval < TimeUnit.MINUTES.toMillis(1L)) {
            return Long.toString(TimeUnit.MILLISECONDS.toSeconds(this.interval)) + "s";
        }
        if (this.interval < TimeUnit.HOURS.toMillis(1L)) {
            return Long.toString(TimeUnit.MILLISECONDS.toMinutes(this.interval)) + "m";
        }
        if (this.interval < TimeUnit.DAYS.toMillis(1L)) {
            return Long.toString(TimeUnit.MILLISECONDS.toHours(this.interval)) + "h";
        }
        return Long.toString(TimeUnit.MILLISECONDS.toDays(this.interval)) + "d";
    }

    @SuppressFBWarnings(value={"RCN_REDUNDANT_NULLCHECK_OF_NONNULL_VALUE", "NP_NULL_ON_SOME_PATH"}, justification="ComputedFolder.computation is set in init but that is overridable so let us just make sure; Trigger.job once set is never cleared")
    public void run() {
        long last;
        if (this.job == null) {
            return;
        }
        FolderComputation computation = ((ComputedFolder)this.job).getComputation();
        long l = last = computation != null ? computation.getTimestamp().getTimeInMillis() : 0L;
        if (last == 0L) {
            LOGGER.fine(() -> this.job + " has not yet been computed");
        } else {
            long almostInterval = this.interval - this.interval / 20L - TimeUnit.SECONDS.toMillis(15L);
            long remaining = last + almostInterval - System.currentTimeMillis();
            if (remaining > 0L) {
                LOGGER.fine(() -> this.job + " was last computed at " + new Date(last) + " which is within the adjusted interval of " + Util.getTimeSpanString((long)almostInterval) + " by " + Util.getTimeSpanString((long)remaining));
                return;
            }
            LOGGER.fine(() -> this.job + " was last computed at " + new Date(last) + " which exceeds the adjusted interval of " + Util.getTimeSpanString((long)almostInterval) + " by " + Util.getTimeSpanString((long)(-remaining)));
        }
        if (((ComputedFolder)this.job).scheduleBuild(5, (Cause)new TimerTrigger.TimerTriggerCause())) {
            LOGGER.fine(() -> "triggering " + this.job + " in 5s");
        } else {
            LOGGER.log(Level.WARNING, "Queue refused to schedule {0}", this.job);
        }
    }

    @Extension
    public static class DescriptorImpl
    extends TriggerDescriptor {
        public boolean isApplicable(Item item) {
            return item instanceof ComputedFolder;
        }

        public String getDisplayName() {
            return Messages.PeriodicFolderTrigger_DisplayName();
        }

        public ListBoxModel doFillIntervalItems() {
            ListBoxModel model = new ListBoxModel();
            model.add("1 minute", "1m");
            model.add("2 minutes", "2m");
            model.add("3 minutes", "3m");
            model.add("5 minutes", "5m");
            model.add("10 minutes", "10m");
            model.add("15 minutes", "15m");
            model.add("20 minutes", "20m");
            model.add("25 minutes", "25m");
            model.add("30 minutes", "30m");
            model.add("1 hour", "1h");
            model.add("2 hours", "2h");
            model.add("4 hours", "4h");
            model.add("8 hours", "8h");
            model.add("12 hours", "12h");
            model.add("1 day", "1d");
            model.add("2 days", "2d");
            model.add("1 week", "7d");
            model.add("2 weeks", "14d");
            model.add("4 weeks", "28d");
            return model;
        }

        static {
            Items.XSTREAM2.addCompatibilityAlias("jenkins.branch.IndexAtLeastTrigger", PeriodicFolderTrigger.class);
        }
    }
}

