/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.hudson.plugins.folder.computed;

import com.cloudbees.hudson.plugins.folder.computed.ComputedFolder;
import hudson.Extension;
import hudson.model.PeriodicWork;
import hudson.scheduler.CronTabList;
import hudson.triggers.Trigger;
import java.lang.reflect.Field;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Extension
@Restricted(value={NoExternalUse.class})
public class FolderCron
extends PeriodicWork {
    private static final Logger LOGGER = Logger.getLogger(FolderCron.class.getName());
    private final Calendar cal = new GregorianCalendar();
    private final Field tabsField;

    public FolderCron() throws NoSuchFieldException {
        this.cal.set(13, 0);
        this.cal.set(14, 0);
        this.tabsField = Trigger.class.getDeclaredField("tabs");
        this.tabsField.setAccessible(true);
    }

    public long getRecurrencePeriod() {
        return 60000L;
    }

    public long getInitialDelay() {
        return 60000L - (long)(Calendar.getInstance().get(13) * 1000);
    }

    public void doRun() {
        while (new Date().getTime() >= this.cal.getTimeInMillis()) {
            LOGGER.log(Level.FINE, "cron checking {0}", this.cal.getTime());
            try {
                this.checkTriggers(this.cal);
            }
            catch (Throwable e) {
                LOGGER.log(Level.WARNING, "Cron thread throw an exception", e);
                e.printStackTrace();
            }
            this.cal.add(12, 1);
        }
    }

    public void checkTriggers(Calendar cal) {
        for (ComputedFolder p : Jenkins.getInstance().allItems(ComputedFolder.class)) {
            for (Trigger<?> t : p.getTriggers().values()) {
                CronTabList tabs;
                LOGGER.log(Level.FINE, "cron checking {0}", p.getName());
                try {
                    tabs = (CronTabList)this.tabsField.get(t);
                }
                catch (IllegalAccessException e) {
                    continue;
                }
                if (!tabs.check(cal)) continue;
                LOGGER.log(Level.CONFIG, "cron triggered {0}", p.getName());
                try {
                    t.run();
                }
                catch (Throwable e) {
                    LOGGER.log(Level.WARNING, t.getClass().getName() + ".run() failed for " + p.getName(), e);
                }
            }
        }
    }
}

