/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.hudson.plugins.folder.computed;

import com.cloudbees.hudson.plugins.folder.computed.FolderComputation;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Util;
import hudson.model.Actionable;
import hudson.model.Result;
import hudson.model.TopLevelItem;
import java.io.File;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.List;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.Ancestor;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.HttpResponses;
import org.kohsuke.stapler.StaplerFallback;
import org.kohsuke.stapler.StaplerRequest;

@Restricted(value={NoExternalUse.class})
public class PseudoRun<I extends TopLevelItem>
extends Actionable
implements StaplerFallback {
    private final FolderComputation<I> computation;

    PseudoRun(FolderComputation<I> computation) {
        this.computation = computation;
    }

    public String getDisplayName() {
        return "log";
    }

    public RunUrl decompose(StaplerRequest req) {
        List ancestors = req.getAncestors();
        Ancestor f = null;
        Ancestor l = null;
        for (Ancestor anc : ancestors) {
            if (!(anc.getObject() instanceof PseudoRun)) continue;
            if (f == null) {
                f = anc;
            }
            l = anc;
        }
        if (l == null) {
            return null;
        }
        String base = l.getUrl();
        return new RunUrl(base);
    }

    @NonNull
    public String getTimestampString() {
        long duration = new GregorianCalendar().getTimeInMillis() - this.computation.getTimestamp().getTimeInMillis();
        return Util.getPastTimeString((long)duration);
    }

    @NonNull
    public String getTimestampString2() {
        return Util.XS_DATETIME_FORMATTER.format(this.computation.getTimestamp());
    }

    @CheckForNull
    public Result getResult() {
        return this.computation.getResult();
    }

    @NonNull
    public Calendar getTimestamp() {
        return this.computation.getTimestamp();
    }

    @NonNull
    public String getDurationString() {
        return this.computation.getDurationString();
    }

    public String getSearchUrl() {
        return this.computation.getSearchUrl();
    }

    @NonNull
    public File getLogFile() {
        return this.computation.getLogFile();
    }

    public Object getStaplerFallback() {
        return this.computation;
    }

    public HttpResponse doIndex(StaplerRequest request) {
        return HttpResponses.redirectViaContextPath((String)this.computation.getUrl());
    }

    public HttpResponse doConsole(StaplerRequest request) {
        return HttpResponses.redirectViaContextPath((String)(this.computation.getUrl() + "console"));
    }

    public HttpResponse doConsoleText(StaplerRequest request) {
        return HttpResponses.redirectViaContextPath((String)(this.computation.getUrl() + "consoleText"));
    }

    @Restricted(value={NoExternalUse.class})
    public static final class RunUrl {
        private final String base;

        public RunUrl(String base) {
            this.base = base;
        }

        public String getBaseUrl() {
            return this.base;
        }

        public String getNextBuildUrl() {
            return null;
        }

        public String getPreviousBuildUrl() {
            return null;
        }
    }
}

