/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.hudson.plugins.folder.computed;

import com.cloudbees.hudson.plugins.folder.AbstractFolder;
import com.cloudbees.hudson.plugins.folder.computed.ComputedFolder;
import com.cloudbees.hudson.plugins.folder.computed.OrphanedItemStrategy;
import com.cloudbees.hudson.plugins.folder.computed.OrphanedItemStrategyDescriptor;
import com.cloudbees.hudson.plugins.folder.computed.OrphanedParent;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.Executor;
import hudson.model.Item;
import hudson.model.Job;
import hudson.model.Queue;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.model.TopLevelItem;
import java.io.IOException;
import java.io.ObjectStreamException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.GregorianCalendar;
import java.util.Iterator;
import jenkins.model.CauseOfInterruption;
import jenkins.model.Jenkins;
import jenkins.model.ParameterizedJobMixIn;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class DefaultOrphanedItemStrategy
extends OrphanedItemStrategy {
    private final boolean pruneDeadBranches;
    private final int daysToKeep;
    private final int numToKeep;
    private boolean abortBuilds;

    @DataBoundConstructor
    public DefaultOrphanedItemStrategy(boolean pruneDeadBranches, @CheckForNull String daysToKeepStr, @CheckForNull String numToKeepStr) {
        this.pruneDeadBranches = pruneDeadBranches;
        this.daysToKeep = pruneDeadBranches ? DefaultOrphanedItemStrategy.fromString(daysToKeepStr) : -1;
        this.numToKeep = pruneDeadBranches ? DefaultOrphanedItemStrategy.fromString(numToKeepStr) : -1;
    }

    public DefaultOrphanedItemStrategy(boolean pruneDeadBranches, int daysToKeep, int numToKeep) {
        this.pruneDeadBranches = pruneDeadBranches;
        this.daysToKeep = pruneDeadBranches && daysToKeep > 0 ? daysToKeep : -1;
        this.numToKeep = pruneDeadBranches && numToKeep > 0 ? numToKeep : -1;
    }

    private Object readResolve() throws ObjectStreamException {
        if (this.daysToKeep == 0 || this.numToKeep == 0) {
            return new DefaultOrphanedItemStrategy(this.pruneDeadBranches, this.daysToKeep, this.numToKeep);
        }
        return this;
    }

    public int getDaysToKeep() {
        return this.daysToKeep;
    }

    public int getNumToKeep() {
        return this.numToKeep;
    }

    public boolean isPruneDeadBranches() {
        return this.pruneDeadBranches;
    }

    public boolean isAbortBuilds() {
        return this.abortBuilds;
    }

    @DataBoundSetter
    public void setAbortBuilds(boolean abortBuilds) {
        this.abortBuilds = abortBuilds;
    }

    @NonNull
    public String getDaysToKeepStr() {
        return DefaultOrphanedItemStrategy.toString(this.daysToKeep);
    }

    @NonNull
    public String getNumToKeepStr() {
        return DefaultOrphanedItemStrategy.toString(this.numToKeep);
    }

    @NonNull
    private static String toString(int i) {
        if (i == -1) {
            return "";
        }
        return String.valueOf(i);
    }

    private static int fromString(@CheckForNull String s) {
        if (s == null || s.isBlank()) {
            return -1;
        }
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    private static long lastBuildTime(TopLevelItem item) {
        long t = 0L;
        if (item instanceof ComputedFolder) {
            t = ((ComputedFolder)item).getComputation().getTimestamp().getTimeInMillis();
        }
        for (Job j : item.getAllJobs()) {
            Run b = j.getLastBuild();
            if (b == null) continue;
            t = Math.max(t, b.getTimeInMillis());
        }
        return t;
    }

    private static boolean disabled(TopLevelItem item) {
        if (item instanceof AbstractFolder) {
            return ((AbstractFolder)item).isDisabled();
        }
        if (item instanceof ParameterizedJobMixIn.ParameterizedJob) {
            return ((ParameterizedJobMixIn.ParameterizedJob)item).isDisabled();
        }
        return false;
    }

    @Override
    public <I extends TopLevelItem> Collection<I> orphanedItems(ComputedFolder<I> owner, Collection<I> orphaned, TaskListener listener) throws IOException, InterruptedException {
        if (this.abortBuilds) {
            ArrayList<Run> abortedBuilds = new ArrayList<Run>();
            for (TopLevelItem item : orphaned) {
                for (Object job : item.getAllJobs()) {
                    Run build;
                    Executor executor;
                    Object jenkinsQueue;
                    if (job instanceof Queue.Task) {
                        jenkinsQueue = Jenkins.get().getQueue();
                        Queue.Task task = (Queue.Task)job;
                        for (Queue.Item pendingBuild : jenkinsQueue.getItems(task)) {
                            jenkinsQueue.cancel(pendingBuild);
                        }
                    }
                    jenkinsQueue = job.getBuilds().iterator();
                    while (jenkinsQueue.hasNext() && (executor = (build = (Run)jenkinsQueue.next()).getExecutor()) != null) {
                        executor.interrupt(Result.ABORTED, new CauseOfInterruption[]{new OrphanedParent((Item)item)});
                        abortedBuilds.add(build);
                    }
                }
            }
            long waitForAbortedBuildsStartTimeNanos = System.nanoTime();
            long maxWaitNanos = 60000000000L;
            block4: for (Run abortedBuild : abortedBuilds) {
                while (abortedBuild.isLogUpdated()) {
                    if (System.nanoTime() - waitForAbortedBuildsStartTimeNanos > maxWaitNanos) break block4;
                    Thread.sleep(100L);
                }
            }
        }
        ArrayList<Object> toRemove = new ArrayList<Object>();
        if (this.pruneDeadBranches) {
            listener.getLogger().printf("Evaluating orphaned items in %s%n", owner.getFullDisplayName());
            ArrayList<I> candidates = new ArrayList<I>(orphaned);
            candidates.sort((i1, i2) -> {
                boolean disabled2;
                boolean disabled1 = DefaultOrphanedItemStrategy.disabled(i1);
                if (disabled1 ^ (disabled2 = DefaultOrphanedItemStrategy.disabled(i2))) {
                    return disabled2 ? -1 : 1;
                }
                long ms1 = DefaultOrphanedItemStrategy.lastBuildTime(i1);
                long ms2 = DefaultOrphanedItemStrategy.lastBuildTime(i2);
                return Long.compare(ms2, ms1);
            });
            Iterator iterator = candidates.iterator();
            block6: while (iterator.hasNext()) {
                TopLevelItem item = (TopLevelItem)iterator.next();
                for (Job job : item.getAllJobs()) {
                    for (Run build : job.getBuilds()) {
                        if (!this.abortBuilds && build.isBuilding()) {
                            listener.getLogger().printf("Will not remove %s as %s is still in progress%n", item.getDisplayName(), build.getFullDisplayName());
                            iterator.remove();
                            continue block6;
                        }
                        String whyKeepLog = build.getWhyKeepLog();
                        if (whyKeepLog == null) continue;
                        listener.getLogger().printf("Will not remove %s as %s is marked to not be removed: %s%n", item.getDisplayName(), build.getFullDisplayName(), whyKeepLog);
                        iterator.remove();
                        continue block6;
                    }
                }
            }
            int count = 0;
            if (this.numToKeep != -1) {
                Iterator iterator2 = candidates.iterator();
                while (iterator2.hasNext()) {
                    Object item = (TopLevelItem)iterator2.next();
                    if (++count <= this.numToKeep) {
                        listener.getLogger().printf("Will not remove %s as it is only #%d in the list%n", item.getDisplayName(), count);
                        continue;
                    }
                    listener.getLogger().printf("Will remove %s as it is #%d in the list%n", item.getDisplayName(), count);
                    toRemove.add(item);
                    iterator2.remove();
                }
            }
            if (this.daysToKeep != -1) {
                GregorianCalendar cal = new GregorianCalendar();
                ((Calendar)cal).add(6, -this.daysToKeep);
                for (TopLevelItem item : candidates) {
                    if (DefaultOrphanedItemStrategy.lastBuildTime(item) > cal.getTimeInMillis()) {
                        listener.getLogger().printf("Will not remove %s because it is new%n", item.getDisplayName());
                        continue;
                    }
                    listener.getLogger().printf("Will remove %s as it is too old%n", item.getDisplayName());
                    toRemove.add(item);
                }
            }
            if (this.daysToKeep == -1 && this.numToKeep == -1) {
                for (Object item : candidates) {
                    listener.getLogger().printf("Will remove %s%n", item.getDisplayName());
                    toRemove.add(item);
                }
            }
        }
        return toRemove;
    }

    @Extension
    public static class DescriptorImpl
    extends OrphanedItemStrategyDescriptor {
        public String getDisplayName() {
            return "Default";
        }
    }
}

