/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.hudson.plugins.folder;

import com.cloudbees.hudson.plugins.folder.AbstractFolder;
import com.cloudbees.hudson.plugins.folder.ChildLoader;
import hudson.Extension;
import hudson.model.TopLevelItem;
import hudson.util.CopyOnWriteMap;
import java.io.File;
import java.util.Map;
import java.util.function.Function;

@Extension
public final class DefaultChildLoader
extends ChildLoader {
    @Override
    public <K, V extends TopLevelItem> Map<K, V> loadChildren(AbstractFolder<V> parent, File modulesDir, Function<? super V, ? extends K> key) {
        CopyOnWriteMap.Tree configurations = new CopyOnWriteMap.Tree();
        if (!this.ensureDirExists(modulesDir, parent)) {
            return configurations;
        }
        File[] subdirs = modulesDir.listFiles(File::isDirectory);
        if (subdirs == null) {
            return configurations;
        }
        Map<String, V> byDirName = this.getItemsByDirName(parent);
        for (File subdir : subdirs) {
            TopLevelItem existingItem = (TopLevelItem)byDirName.get(subdir.getName());
            TopLevelItem item = this.loadItem(parent, subdir, existingItem);
            if (item == null) continue;
            configurations.put(key.apply(item), (Object)item);
        }
        return configurations;
    }
}

