/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.hudson.plugins.folder.computed;

import com.cloudbees.hudson.plugins.folder.AbstractFolder;
import com.cloudbees.hudson.plugins.folder.computed.ChildObserver;
import com.cloudbees.hudson.plugins.folder.computed.DefaultOrphanedItemStrategy;
import com.cloudbees.hudson.plugins.folder.computed.DeletingChildrenException;
import com.cloudbees.hudson.plugins.folder.computed.FolderComputation;
import com.cloudbees.hudson.plugins.folder.computed.Messages;
import com.cloudbees.hudson.plugins.folder.computed.OrphanedItemStrategy;
import com.cloudbees.hudson.plugins.folder.computed.OrphanedItemStrategyDescriptor;
import com.cloudbees.hudson.plugins.folder.computed.PseudoRun;
import com.thoughtworks.xstream.XStreamException;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.ExtensionList;
import hudson.Util;
import hudson.model.Action;
import hudson.model.BuildableItem;
import hudson.model.Cause;
import hudson.model.CauseAction;
import hudson.model.Descriptor;
import hudson.model.Failure;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.Items;
import hudson.model.Label;
import hudson.model.Node;
import hudson.model.Queue;
import hudson.model.Result;
import hudson.model.Saveable;
import hudson.model.TaskListener;
import hudson.model.TopLevelItem;
import hudson.model.listeners.ItemListener;
import hudson.model.queue.CauseOfBlockage;
import hudson.triggers.TimerTrigger;
import hudson.triggers.Trigger;
import hudson.triggers.TriggerDescriptor;
import hudson.util.DescribableList;
import io.jenkins.servlet.ServletExceptionWrapper;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import jenkins.model.Jenkins;
import jenkins.model.ParameterizedJobMixIn;
import jenkins.triggers.TriggeredItem;
import jenkins.util.TimeDuration;
import net.jcip.annotations.GuardedBy;
import net.sf.json.JSONObject;
import org.apache.commons.io.FileUtils;
import org.jvnet.localizer.Localizable;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.DoNotUse;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.HttpResponses;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerRequest2;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.StaplerResponse2;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.interceptor.RequirePOST;

public abstract class ComputedFolder<I extends TopLevelItem>
extends AbstractFolder<I>
implements BuildableItem,
TriggeredItem,
Queue.FlyweightTask {
    private static final Logger LOGGER = Logger.getLogger(ComputedFolder.class.getName());
    private OrphanedItemStrategy orphanedItemStrategy;
    private DescribableList<Trigger<?>, TriggerDescriptor> triggers;
    private volatile boolean disabled;
    @NonNull
    private transient FolderComputation<I> computation;
    @NonNull
    private transient ReentrantLock currentObservationsLock;
    private transient Condition currentObservationsChanged;
    @GuardedBy(value="#computationLock")
    private transient Set<String> currentObservations;
    @GuardedBy(value="#computationLock")
    private transient boolean currentObservationsLockDisabled;
    private transient Recalculation recalculate;

    @SuppressFBWarnings(value={"NP_NONNULL_FIELD_NOT_INITIALIZED_IN_CONSTRUCTOR"})
    protected ComputedFolder(ItemGroup parent, String name) {
        super(parent, name);
        this.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void init() {
        super.init();
        if (this.orphanedItemStrategy == null) {
            this.orphanedItemStrategy = new DefaultOrphanedItemStrategy(true, "", "");
        }
        if (this.triggers == null) {
            this.triggers = new DescribableList((Saveable)this);
        } else {
            this.triggers.setOwner((Saveable)this);
        }
        for (Trigger t : this.triggers) {
            t.start((Item)this, Items.currentlyUpdatingByXml());
        }
        Object object = this;
        synchronized (object) {
            this.computation = this.createComputation(null);
        }
        this.currentObservationsLock = new ReentrantLock();
        this.currentObservationsChanged = this.currentObservationsLock.newCondition();
        this.currentObservations = new HashSet<String>();
    }

    public void onCreatedFromScratch() {
        try {
            FileUtils.forceMkdir((File)this.getComputationDir());
        }
        catch (IOException x) {
            LOGGER.log(Level.WARNING, null, x);
        }
        super.onCreatedFromScratch();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onLoad(ItemGroup<? extends Item> parent, String name) throws IOException {
        super.onLoad(parent, name);
        if (((Boolean)reloadingThis.get()).booleanValue()) {
            LOGGER.fine(() -> String.valueOf((Object)this) + " skipping the rest of onLoad");
            return;
        }
        try {
            FileUtils.forceMkdir((File)this.getComputationDir());
        }
        catch (IOException x) {
            LOGGER.log(Level.WARNING, null, x);
        }
        ComputedFolder computedFolder = this;
        synchronized (computedFolder) {
            try {
                this.computation.load();
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, "Failed to load " + String.valueOf(this.computation), e);
            }
        }
    }

    protected abstract void computeChildren(ChildObserver<I> var1, TaskListener var2) throws IOException, InterruptedException;

    protected Collection<I> orphanedItems(Collection<I> orphaned, TaskListener listener) throws IOException, InterruptedException {
        return this.getOrphanedItemStrategy().orphanedItems(this, orphaned, listener);
    }

    public void setOrphanedItemStrategy(@NonNull OrphanedItemStrategy strategy) {
        this.orphanedItemStrategy = strategy;
    }

    final void updateChildren(TaskListener listener) throws IOException, InterruptedException {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "updating {0}", this.getFullName());
        }
        try (FullReindexChildObserver observer = new FullReindexChildObserver();){
            this.computeChildren(observer, listener);
            Map orphaned = observer.orphaned();
            if (!orphaned.isEmpty()) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, "{0}: orphaned {1}", new Object[]{this.getFullName(), orphaned.keySet()});
                }
                Collection forRemoval = this.orphanedItems(orphaned.values(), listener);
                LinkedList<IOException> deletingExceptions = new LinkedList<IOException>();
                for (TopLevelItem existing : orphaned.values()) {
                    if (forRemoval.contains(existing)) {
                        if (LOGGER.isLoggable(Level.FINE)) {
                            LOGGER.log(Level.FINE, "{0}: deleting {1}", new Object[]{this.getFullName(), existing});
                        }
                        try {
                            existing.delete();
                        }
                        catch (IOException x) {
                            deletingExceptions.add(x);
                        }
                        continue;
                    }
                    this.applyDisabled(existing, true);
                }
                if (!deletingExceptions.isEmpty()) {
                    throw new DeletingChildrenException(deletingExceptions);
                }
            }
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "finished updating {0}", this.getFullName());
        }
    }

    private void applyDisabled(I item, boolean disabled) {
        try {
            if (item instanceof AbstractFolder) {
                ((AbstractFolder)((Object)item)).makeDisabled(disabled);
            } else if (item instanceof ParameterizedJobMixIn.ParameterizedJob) {
                ((ParameterizedJobMixIn.ParameterizedJob)item).makeDisabled(disabled);
            }
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Could not " + (disabled ? "disable " : "enable ") + item.getFullName(), e);
        }
    }

    @Deprecated
    @Restricted(value={NoExternalUse.class})
    protected final ChildObserver<I> createEventsChildObserver() {
        LOGGER.log(Level.WARNING, "The {0} implementation of ComputedFolder has not been updated to use openEventsChildObserver(), this may result in 'java.lang.IllegalStateException: JENKINS-23152 ... already existed; will not overwrite with ...' being thrown when processing events", ((Object)((Object)this)).getClass().getName());
        this.currentObservationsLock.lock();
        try {
            if (!this.currentObservationsLockDisabled) {
                this.currentObservationsLockDisabled = true;
                this.currentObservationsChanged.signalAll();
            }
        }
        finally {
            this.currentObservationsLock.unlock();
        }
        return new EventChildObserver();
    }

    protected final ChildObserver<I> openEventsChildObserver() {
        return new EventChildObserver();
    }

    @Override
    public boolean isDisabled() {
        return this.disabled;
    }

    @Override
    protected void setDisabled(boolean disabled) {
        this.disabled = disabled;
    }

    @Override
    public boolean supportsMakeDisabled() {
        return true;
    }

    @Override
    @RequirePOST
    public void doConfigSubmit(StaplerRequest2 req, StaplerResponse2 rsp) throws IOException, jakarta.servlet.ServletException, Descriptor.FormException {
        try {
            this.recalculate = Recalculation.UNKNOWN;
            super.doConfigSubmit(req, rsp);
            if (this.recalculate != Recalculation.NO_RECALCULATION && this.isBuildable()) {
                this.scheduleBuild((Cause)new Cause.UserIdCause());
            }
        }
        finally {
            this.recalculate = null;
        }
    }

    protected final void recalculateAfterSubmitted(boolean recalculate) {
        if (this.recalculate == null) {
            return;
        }
        if (this.recalculate == Recalculation.RECALCULATE) {
            return;
        }
        this.recalculate = recalculate ? Recalculation.RECALCULATE : Recalculation.NO_RECALCULATION;
    }

    @Override
    protected void submit(StaplerRequest2 req, StaplerResponse2 rsp) throws IOException, jakarta.servlet.ServletException, Descriptor.FormException {
        if (Util.isOverridden(ComputedFolder.class, ((Object)((Object)this)).getClass(), (String)"submit", (Class[])new Class[]{StaplerRequest.class, StaplerResponse.class})) {
            try {
                this.submit(StaplerRequest.fromStaplerRequest2((StaplerRequest2)req), StaplerResponse.fromStaplerResponse2((StaplerResponse2)rsp));
            }
            catch (ServletException e) {
                throw ServletExceptionWrapper.toJakartaServletException((ServletException)e);
            }
        }
        String oisDigest = null;
        try {
            oisDigest = Util.getDigestOf((String)Items.XSTREAM2.toXML((Object)this.orphanedItemStrategy));
        }
        catch (XStreamException xStreamException) {
            // empty catch block
        }
        super.submit(req, rsp);
        JSONObject json = req.getSubmittedForm();
        this.orphanedItemStrategy = (OrphanedItemStrategy)((Object)req.bindJSON(OrphanedItemStrategy.class, json.getJSONObject("orphanedItemStrategy")));
        for (Trigger t : this.triggers) {
            t.stop();
        }
        this.triggers.rebuild(req, json, Trigger.for_((Item)this));
        for (Trigger t : this.triggers) {
            t.start((Item)this, true);
        }
        try {
            if (oisDigest == null || !oisDigest.equals(Util.getDigestOf((String)Items.XSTREAM2.toXML((Object)this.orphanedItemStrategy)))) {
                this.recalculateAfterSubmitted(true);
            }
        }
        catch (XStreamException e) {
            this.recalculateAfterSubmitted(true);
        }
    }

    @Override
    @Deprecated
    protected void submit(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException, Descriptor.FormException {
        String oisDigest = null;
        try {
            oisDigest = Util.getDigestOf((String)Items.XSTREAM2.toXML((Object)this.orphanedItemStrategy));
        }
        catch (XStreamException xStreamException) {
            // empty catch block
        }
        super.submit(req, rsp);
        JSONObject json = req.getSubmittedForm();
        this.orphanedItemStrategy = (OrphanedItemStrategy)((Object)req.bindJSON(OrphanedItemStrategy.class, json.getJSONObject("orphanedItemStrategy")));
        for (Trigger t : this.triggers) {
            t.stop();
        }
        this.triggers.rebuild(req, json, Trigger.for_((Item)this));
        for (Trigger t : this.triggers) {
            t.start((Item)this, true);
        }
        try {
            if (oisDigest == null || !oisDigest.equals(Util.getDigestOf((String)Items.XSTREAM2.toXML((Object)this.orphanedItemStrategy)))) {
                this.recalculateAfterSubmitted(true);
            }
        }
        catch (XStreamException e) {
            this.recalculateAfterSubmitted(true);
        }
    }

    @Override
    @Restricted(value={NoExternalUse.class})
    @NonNull
    protected final String getSuccessfulDestination() {
        if (this.recalculate != Recalculation.NO_RECALCULATION && this.isBuildable()) {
            return this.computation.getSearchUrl() + "console";
        }
        return super.getSuccessfulDestination();
    }

    public Map<TriggerDescriptor, Trigger<?>> getTriggers() {
        return this.triggers.toMap();
    }

    @Restricted(value={NoExternalUse.class})
    public List<TriggerDescriptor> getTriggerDescriptors() {
        ArrayList<TriggerDescriptor> result = new ArrayList<TriggerDescriptor>();
        for (TriggerDescriptor d : Trigger.for_((Item)this)) {
            if (d instanceof TimerTrigger.DescriptorImpl) continue;
            result.add(d);
        }
        return result;
    }

    public void addTrigger(Trigger trigger) {
        this.removeTrigger(trigger);
        this.triggers.add((Object)trigger);
        trigger.start((Item)this, true);
    }

    public void removeTrigger(Trigger trigger) {
        Trigger old = (Trigger)this.triggers.get((Descriptor)trigger.getDescriptor());
        if (old != null) {
            old.stop();
            this.triggers.remove((Object)old);
        }
    }

    public List<Action> getActions() {
        ArrayList<Action> actions = new ArrayList<Action>(super.getActions());
        for (Trigger trigger : this.triggers) {
            actions.addAll(trigger.getProjectActions());
        }
        return actions;
    }

    @Exported
    public boolean isBuildable() {
        if (this.isDisabled()) {
            return false;
        }
        ItemGroup p = this.getParent();
        while (p instanceof Item) {
            if (p instanceof AbstractFolder && ((AbstractFolder)p).isDisabled()) {
                return false;
            }
            p = ((Item)p).getParent();
        }
        return true;
    }

    @RequirePOST
    public HttpResponse doBuild(@QueryParameter TimeDuration delay) {
        this.checkPermission(BUILD);
        if (!this.isBuildable()) {
            throw HttpResponses.error((int)500, (Throwable)new IOException(this.getFullName() + " cannot be recomputed"));
        }
        this.scheduleBuild2(delay == null ? 0 : delay.getTimeInSeconds(), new Action[]{new CauseAction((Cause)new Cause.UserIdCause())});
        return HttpResponses.forwardToPreviousPage();
    }

    @CheckForNull
    public Queue.Item scheduleBuild2(int quietPeriod, Action ... actions) {
        if (!this.isBuildable()) {
            return null;
        }
        return Queue.getInstance().schedule2((Queue.Task)this, quietPeriod, Arrays.asList(actions)).getItem();
    }

    public boolean scheduleBuild(Cause c) {
        return this.scheduleBuild2(0, new Action[]{new CauseAction(c)}) != null;
    }

    public boolean scheduleBuild(int quietPeriod, Cause c) {
        return this.scheduleBuild2(quietPeriod, new Action[]{new CauseAction(c)}) != null;
    }

    public CauseOfBlockage getCauseOfBlockage() {
        if (this.computation.isBuilding()) {
            return CauseOfBlockage.fromMessage((Localizable)Messages._ComputedFolder_already_computing());
        }
        return null;
    }

    public void checkAbortPermission() {
        this.checkPermission(CANCEL);
    }

    public boolean hasAbortPermission() {
        return this.hasPermission(CANCEL);
    }

    public Label getAssignedLabel() {
        Jenkins j = Jenkins.getInstanceOrNull();
        if (j == null) {
            return null;
        }
        return j.getSelfLabel();
    }

    public Node getLastBuiltOn() {
        return Jenkins.getInstanceOrNull();
    }

    public long getEstimatedDuration() {
        return this.computation.getEstimatedDuration();
    }

    public final FolderComputation<I> createExecutable() throws IOException {
        if (this.isDisabled()) {
            return null;
        }
        FolderComputation<I> c = this.createComputation(this.computation);
        this.computation = c;
        LOGGER.log(Level.FINE, "Recording {0} @{1}", new Object[]{c, c.getTimestamp()});
        return c;
    }

    @NonNull
    protected FolderComputation<I> createComputation(@CheckForNull FolderComputation<I> previous) {
        return new FolderComputation<I>(this, previous);
    }

    protected File getComputationDir() {
        return new File(this.getRootDir(), "computation");
    }

    public boolean isHasEvents() {
        return this.getComputation().getEventsFile().length() > 0L;
    }

    @NonNull
    public FolderComputation<I> getComputation() {
        return this.computation;
    }

    @Restricted(value={NoExternalUse.class})
    public PseudoRun<I> getLastSuccessfulBuild() {
        FolderComputation<I> computation = this.getComputation();
        Result result = computation.getResult();
        if (result != null && Result.UNSTABLE.isWorseOrEqualTo(result)) {
            return new PseudoRun<I>(computation);
        }
        return null;
    }

    @Restricted(value={NoExternalUse.class})
    public PseudoRun<I> getLastStableBuild() {
        FolderComputation<I> computation = this.getComputation();
        Result result = computation.getResult();
        if (result != null && Result.SUCCESS.isWorseOrEqualTo(result)) {
            return new PseudoRun<I>(computation);
        }
        return null;
    }

    @Restricted(value={NoExternalUse.class})
    public PseudoRun<I> getLastFailedBuild() {
        FolderComputation<I> computation = this.getComputation();
        Result result = computation.getResult();
        if (result != null && Result.UNSTABLE.isBetterThan(result)) {
            return new PseudoRun<I>(computation);
        }
        return null;
    }

    @Override
    protected void checkRename(String newName) {
        if (this.computation.isBuilding()) {
            throw new Failure(Messages.ComputedFolder_ComputationInProgress());
        }
        super.checkRename(newName);
    }

    @NonNull
    public OrphanedItemStrategy getOrphanedItemStrategy() {
        return this.orphanedItemStrategy;
    }

    @Restricted(value={DoNotUse.class})
    @NonNull
    public List<OrphanedItemStrategyDescriptor> getOrphanedItemStrategyDescriptors() {
        ArrayList<OrphanedItemStrategyDescriptor> result = new ArrayList<OrphanedItemStrategyDescriptor>();
        for (OrphanedItemStrategyDescriptor descriptor : ExtensionList.lookup(OrphanedItemStrategyDescriptor.class)) {
            if (!descriptor.isApplicable(((Object)((Object)this)).getClass())) continue;
            result.add(descriptor);
        }
        return result;
    }

    private class FullReindexChildObserver
    extends ChildObserver<I> {
        private final Map<String, I> orphaned;
        private final Set<String> observed;
        private final Set<String> locked;
        private final String fullName;

        private FullReindexChildObserver() {
            this.orphaned = new HashMap(ComputedFolder.this.items);
            this.observed = new HashSet<String>();
            this.locked = new HashSet<String>();
            this.fullName = ComputedFolder.this.getFullName();
        }

        @Override
        public void close() {
            if (!this.locked.isEmpty()) {
                ComputedFolder.this.currentObservationsLock.lock();
                try {
                    ComputedFolder.this.currentObservations.removeAll(this.locked);
                    ComputedFolder.this.currentObservationsChanged.signalAll();
                }
                finally {
                    ComputedFolder.this.currentObservationsLock.unlock();
                }
            }
        }

        @Override
        public I shouldUpdate(String name) throws InterruptedException {
            ComputedFolder.this.currentObservationsLock.lock();
            try {
                while (!ComputedFolder.this.currentObservations.add(name) && !ComputedFolder.this.currentObservationsLockDisabled) {
                    ComputedFolder.this.currentObservationsChanged.await();
                }
                this.locked.add(name);
            }
            finally {
                ComputedFolder.this.currentObservationsLock.unlock();
            }
            TopLevelItem existing = (TopLevelItem)this.orphaned.remove(name);
            if (existing == null) {
                existing = (TopLevelItem)ComputedFolder.this.items.get(name);
            }
            if (existing != null) {
                this.observed.add(name);
                ComputedFolder.this.applyDisabled(existing, false);
            }
            LOGGER.log(Level.FINE, "{0}: existing {1}: {2}", new Object[]{this.fullName, name, existing});
            return existing;
        }

        @Override
        public boolean mayCreate(String name) {
            boolean r = this.observed.add(name);
            LOGGER.log(Level.FINE, "{0}: may create {1}? {2}", new Object[]{this.fullName, name, r});
            if (!r) {
                this.completed(name);
            }
            return r;
        }

        @Override
        public void created(I child) {
            if (child.getParent() != ComputedFolder.this) {
                throw new IllegalStateException("Tried to notify " + String.valueOf((Object)ComputedFolder.this) + " of creation of " + String.valueOf(child) + " with a different parent");
            }
            LOGGER.log(Level.FINE, "{0}: created {1}", new Object[]{this.fullName, child});
            String name = child.getName();
            if (!this.observed.contains(name)) {
                throw new IllegalStateException("Did not call mayCreate, or used the wrong Item.name for " + String.valueOf(child) + " with name " + name + " among " + String.valueOf(this.observed));
            }
            child.onCreatedFromScratch();
            try {
                child.save();
            }
            catch (IOException x) {
                LOGGER.log(Level.WARNING, "Failed to save " + String.valueOf(child), x);
            }
            ComputedFolder.this.itemsPut(name, child);
            Jenkins j = Jenkins.getInstanceOrNull();
            if (j != null) {
                j.rebuildDependencyGraphAsync();
            }
            ItemListener.fireOnCreated(child);
            this.completed(name);
        }

        @Override
        public void completed(String name) {
            if (this.locked.contains(name)) {
                ComputedFolder.this.currentObservationsLock.lock();
                try {
                    this.locked.remove(name);
                    ComputedFolder.this.currentObservations.remove(name);
                    ComputedFolder.this.currentObservationsChanged.signalAll();
                }
                finally {
                    ComputedFolder.this.currentObservationsLock.unlock();
                }
            }
        }

        @Override
        public Set<String> observed() {
            return new HashSet<String>(this.observed);
        }

        @Override
        public Map<String, I> orphaned() {
            return new HashMap(this.orphaned);
        }
    }

    private class EventChildObserver
    extends ChildObserver<I> {
        private final String fullName;
        private final Set<String> observed;
        private final Set<String> locked;

        private EventChildObserver() {
            this.fullName = ComputedFolder.this.getFullName();
            this.observed = new HashSet<String>();
            this.locked = new HashSet<String>();
        }

        @Override
        public void close() {
            if (!this.locked.isEmpty()) {
                ComputedFolder.this.currentObservationsLock.lock();
                try {
                    ComputedFolder.this.currentObservations.removeAll(this.locked);
                    ComputedFolder.this.currentObservationsChanged.signalAll();
                }
                finally {
                    ComputedFolder.this.currentObservationsLock.unlock();
                }
            }
        }

        @Override
        public I shouldUpdate(String name) throws InterruptedException {
            ComputedFolder.this.currentObservationsLock.lock();
            try {
                while (!ComputedFolder.this.currentObservations.add(name) && !ComputedFolder.this.currentObservationsLockDisabled) {
                    ComputedFolder.this.currentObservationsChanged.await();
                }
                this.locked.add(name);
            }
            finally {
                ComputedFolder.this.currentObservationsLock.unlock();
            }
            TopLevelItem existing = (TopLevelItem)ComputedFolder.this.items.get(name);
            if (existing != null) {
                this.observed.add(name);
                ComputedFolder.this.applyDisabled(existing, false);
            }
            LOGGER.log(Level.FINE, "{0}: existing {1}: {2}", new Object[]{this.fullName, name, existing});
            return existing;
        }

        @Override
        public boolean mayCreate(String name) {
            boolean r = !ComputedFolder.this.items.containsKey(name) && this.observed.add(name);
            LOGGER.log(Level.FINE, "{0}: may create {1}? {2}", new Object[]{this.fullName, name, r});
            if (!r) {
                this.completed(name);
            }
            return r;
        }

        @Override
        public void created(I child) {
            if (child.getParent() != ComputedFolder.this) {
                throw new IllegalStateException("Tried to notify " + String.valueOf((Object)ComputedFolder.this) + " of creation of " + String.valueOf(child) + " with a different parent");
            }
            LOGGER.log(Level.FINE, "{0}: created {1}", new Object[]{this.fullName, child});
            String name = child.getName();
            if (!this.observed.contains(name)) {
                throw new IllegalStateException("Did not call mayCreate, or used the wrong Item.name for " + String.valueOf(child) + " with name " + name + " among " + String.valueOf(this.observed));
            }
            child.onCreatedFromScratch();
            try {
                child.save();
            }
            catch (IOException x) {
                LOGGER.log(Level.WARNING, "Failed to save " + String.valueOf(child), x);
            }
            ComputedFolder.this.itemsPut(name, child);
            Jenkins j = Jenkins.getInstanceOrNull();
            if (j != null) {
                j.rebuildDependencyGraphAsync();
            }
            ItemListener.fireOnCreated(child);
            this.completed(name);
        }

        @Override
        public void completed(String name) {
            if (this.locked.contains(name)) {
                ComputedFolder.this.currentObservationsLock.lock();
                try {
                    this.locked.remove(name);
                    ComputedFolder.this.currentObservations.remove(name);
                    ComputedFolder.this.currentObservationsChanged.signalAll();
                }
                finally {
                    ComputedFolder.this.currentObservationsLock.unlock();
                }
            }
        }

        @Override
        public Set<String> observed() {
            return new HashSet<String>(this.observed);
        }

        @Override
        public Map<String, I> orphaned() {
            return new HashMap();
        }
    }

    private static enum Recalculation {
        UNKNOWN,
        RECALCULATE,
        NO_RECALCULATION;

    }
}

