/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.hudson.plugins.folder.views;

import com.cloudbees.hudson.plugins.folder.views.AbstractFolderViewHolder;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.model.AllView;
import hudson.model.Messages;
import hudson.model.View;
import hudson.views.ViewsTabBar;
import java.io.ObjectStreamException;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import jenkins.util.SystemProperties;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.DataBoundConstructor;

public class DefaultFolderViewHolder
extends AbstractFolderViewHolder {
    private static final Logger LOGGER = Logger.getLogger(DefaultFolderViewHolder.class.getName());
    @NonNull
    private CopyOnWriteArrayList<View> views;
    @CheckForNull
    private String primaryView;
    @NonNull
    private ViewsTabBar tabBar;

    @DataBoundConstructor
    public DefaultFolderViewHolder(@NonNull Collection<? extends View> views, @CheckForNull String primaryView, @NonNull ViewsTabBar tabBar) {
        if (views.isEmpty()) {
            throw new IllegalArgumentException("Initial views cannot be empty");
        }
        this.views = new CopyOnWriteArrayList<View>(views);
        this.primaryView = primaryView;
        this.tabBar = tabBar;
    }

    @Override
    public List<View> getViews() {
        return this.views;
    }

    @Override
    public void setViews(List<? extends View> views) {
        if (views.isEmpty()) {
            throw new IllegalArgumentException("Views cannot be empty");
        }
        this.views = new CopyOnWriteArrayList<View>(views);
    }

    @Override
    public String getPrimaryView() {
        return this.primaryView;
    }

    @Override
    public void setPrimaryView(String primaryView) {
        this.primaryView = primaryView;
    }

    @Override
    public ViewsTabBar getTabBar() {
        return this.tabBar;
    }

    @Override
    public void setTabBar(ViewsTabBar tabBar) {
        this.tabBar = tabBar;
    }

    private Object readResolve() throws ObjectStreamException {
        if (this.primaryView != null) {
            this.primaryView = DefaultFolderViewHolder.migrateLegacyPrimaryAllViewLocalizedName(this.views, this.primaryView);
        }
        return this;
    }

    @Restricted(value={NoExternalUse.class})
    @Nonnull
    public static String migrateLegacyPrimaryAllViewLocalizedName(@Nonnull List<View> views, @Nonnull String primaryView) {
        if ("all".equals(primaryView)) {
            return primaryView;
        }
        if (SystemProperties.getBoolean((String)(AllView.class.getName() + ".JENKINS-38606"), (boolean)true)) {
            AllView allView = null;
            for (View v : views) {
                if ("all".equals(v.getViewName())) {
                    return primaryView;
                }
                if (!StringUtils.equals((String)v.getViewName(), (String)primaryView)) continue;
                if (v instanceof AllView) {
                    allView = (AllView)v;
                    continue;
                }
                return primaryView;
            }
            if (allView != null) {
                for (Locale l : Locale.getAvailableLocales()) {
                    if (!primaryView.equals(Messages._Hudson_ViewName().toString(l))) continue;
                    LOGGER.log(Level.INFO, "JENKINS-38606 detected for AllView in {0}; renaming view from {1} to {2}", new Object[]{allView.getOwner(), primaryView, "all"});
                    try {
                        Field name = View.class.getDeclaredField("name");
                        name.setAccessible(true);
                        name.set(allView, "all");
                    }
                    catch (Exception x) {
                        LOGGER.log(Level.WARNING, null, x);
                        return primaryView;
                    }
                    return "all";
                }
            }
        }
        return primaryView;
    }
}

