/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.hudson.plugins.folder.computed;

import com.cloudbees.hudson.plugins.folder.computed.ComputedFolder;
import com.cloudbees.hudson.plugins.folder.computed.OrphanedItemStrategy;
import com.cloudbees.hudson.plugins.folder.computed.OrphanedItemStrategyDescriptor;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.Job;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.model.TopLevelItem;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.GregorianCalendar;
import java.util.Iterator;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;

public class DefaultOrphanedItemStrategy
extends OrphanedItemStrategy {
    private final boolean pruneDeadBranches;
    private final int daysToKeep;
    private final int numToKeep;

    @DataBoundConstructor
    public DefaultOrphanedItemStrategy(boolean pruneDeadBranches, @CheckForNull String daysToKeepStr, @CheckForNull String numToKeepStr) {
        this.pruneDeadBranches = pruneDeadBranches;
        this.daysToKeep = pruneDeadBranches ? DefaultOrphanedItemStrategy.fromString(daysToKeepStr) : -1;
        this.numToKeep = pruneDeadBranches ? DefaultOrphanedItemStrategy.fromString(numToKeepStr) : -1;
    }

    public int getDaysToKeep() {
        return this.daysToKeep;
    }

    public int getNumToKeep() {
        return this.numToKeep;
    }

    public boolean isPruneDeadBranches() {
        return this.pruneDeadBranches;
    }

    @NonNull
    public String getDaysToKeepStr() {
        return DefaultOrphanedItemStrategy.toString(this.daysToKeep);
    }

    @NonNull
    public String getNumToKeepStr() {
        return DefaultOrphanedItemStrategy.toString(this.numToKeep);
    }

    @NonNull
    private static String toString(int i) {
        if (i == -1) {
            return "";
        }
        return String.valueOf(i);
    }

    private static int fromString(@CheckForNull String s) {
        if (StringUtils.isBlank((String)s)) {
            return -1;
        }
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    private static long lastBuildTime(TopLevelItem item) {
        long t = 0L;
        for (Job j : item.getAllJobs()) {
            Run b = j.getLastBuild();
            if (b == null) continue;
            t = Math.max(t, b.getTimeInMillis());
        }
        return t;
    }

    @Override
    public <I extends TopLevelItem> Collection<I> orphanedItems(ComputedFolder<I> owner, Collection<I> orphaned, TaskListener listener) throws IOException, InterruptedException {
        ArrayList<TopLevelItem> toRemove = new ArrayList<TopLevelItem>();
        if (this.pruneDeadBranches && (this.numToKeep != -1 || this.daysToKeep != -1)) {
            listener.getLogger().printf("Evaluating orphaned items in %s%n", owner.getFullDisplayName());
            ArrayList<I> candidates = new ArrayList<I>(orphaned);
            Collections.sort(candidates, new Comparator<I>(){

                @Override
                public int compare(I i1, I i2) {
                    long ms1 = DefaultOrphanedItemStrategy.lastBuildTime(i1);
                    long ms2 = DefaultOrphanedItemStrategy.lastBuildTime(i2);
                    return ms2 < ms1 ? -1 : (ms2 == ms1 ? 0 : 1);
                }
            });
            Iterator iterator = candidates.iterator();
            while (iterator.hasNext()) {
                TopLevelItem item = (TopLevelItem)iterator.next();
                for (Job job : item.getAllJobs()) {
                    for (Run build : job.getBuilds()) {
                        String whyKeepLog;
                        if (build.isBuilding()) {
                            listener.getLogger().printf("Will not remove %s as %s is still in progress%n", item.getDisplayName(), build.getFullDisplayName());
                            iterator.remove();
                        }
                        if ((whyKeepLog = build.getWhyKeepLog()) == null) continue;
                        listener.getLogger().printf("Will not remove %s as %s is marked to not be removed: %s%n", item.getDisplayName(), build.getFullDisplayName(), whyKeepLog);
                        iterator.remove();
                    }
                }
            }
            int count = 0;
            if (this.numToKeep != -1) {
                Iterator iterator2 = candidates.iterator();
                while (iterator2.hasNext()) {
                    TopLevelItem item = (TopLevelItem)iterator2.next();
                    if (++count <= this.numToKeep) {
                        listener.getLogger().printf("Will not remove %s as it is only #%d in the list%n", item.getDisplayName(), count);
                        continue;
                    }
                    listener.getLogger().printf("Will remove %s as it is #%d in the list%n", item.getDisplayName(), count);
                    toRemove.add(item);
                    iterator2.remove();
                }
            }
            if (this.daysToKeep != -1) {
                GregorianCalendar cal = new GregorianCalendar();
                ((Calendar)cal).add(6, -this.daysToKeep);
                for (TopLevelItem item : candidates) {
                    if (DefaultOrphanedItemStrategy.lastBuildTime(item) > cal.getTimeInMillis()) {
                        listener.getLogger().printf("Will not remove %s because it is new%n", item.getDisplayName());
                        continue;
                    }
                    listener.getLogger().printf("Will remove %s as it is too old%n", item.getDisplayName());
                    toRemove.add(item);
                }
            }
        }
        return toRemove;
    }

    @Extension
    public static class DescriptorImpl
    extends OrphanedItemStrategyDescriptor {
        public String getDisplayName() {
            return "Default";
        }
    }
}

