/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.hudson.plugins.folder.properties;

import com.cloudbees.hudson.plugins.folder.AbstractFolder;
import com.cloudbees.hudson.plugins.folder.AbstractFolderProperty;
import com.cloudbees.hudson.plugins.folder.AbstractFolderPropertyDescriptor;
import com.cloudbees.hudson.plugins.folder.properties.Messages;
import com.cloudbees.plugins.credentials.Credentials;
import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsNameProvider;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.CredentialsScope;
import com.cloudbees.plugins.credentials.CredentialsStore;
import com.cloudbees.plugins.credentials.CredentialsStoreAction;
import com.cloudbees.plugins.credentials.common.IdCredentials;
import com.cloudbees.plugins.credentials.domains.Domain;
import com.cloudbees.plugins.credentials.domains.DomainCredentials;
import com.cloudbees.plugins.credentials.domains.DomainRequirement;
import com.cloudbees.plugins.credentials.domains.DomainSpecification;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.DescriptorExtensionList;
import hudson.Extension;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.ModelObject;
import hudson.security.ACL;
import hudson.security.AccessDeniedException2;
import hudson.security.Permission;
import hudson.util.CopyOnWriteMap;
import hudson.util.ListBoxModel;
import java.io.IOException;
import java.io.ObjectStreamException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import jenkins.model.Jenkins;
import net.jcip.annotations.GuardedBy;
import net.sf.json.JSONObject;
import org.acegisecurity.Authentication;
import org.acegisecurity.context.SecurityContext;
import org.acegisecurity.context.SecurityContextHolder;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;

@Extension(optional=true)
public class FolderCredentialsProvider
extends CredentialsProvider {
    private static final Set<CredentialsScope> SCOPES = Collections.singleton(CredentialsScope.GLOBAL);
    @GuardedBy(value="self")
    private static final WeakHashMap<AbstractFolder<?>, FolderCredentialsProperty> emptyProperties = new WeakHashMap();

    public Set<CredentialsScope> getScopes(ModelObject object) {
        if (object instanceof AbstractFolder) {
            return SCOPES;
        }
        return super.getScopes(object);
    }

    @NonNull
    public <C extends Credentials> List<C> getCredentials(@NonNull Class<C> type, @Nullable ItemGroup itemGroup, @Nullable Authentication authentication) {
        return this.getCredentials(type, itemGroup, authentication, Collections.<DomainRequirement>emptyList());
    }

    @NonNull
    public <C extends Credentials> List<C> getCredentials(@NonNull Class<C> type, @Nullable ItemGroup itemGroup, @Nullable Authentication authentication, @NonNull List<DomainRequirement> domainRequirements) {
        ArrayList<Credentials> result = new ArrayList<Credentials>();
        HashSet<String> ids = new HashSet<String>();
        if (ACL.SYSTEM.equals(authentication)) {
            while (itemGroup != null) {
                AbstractFolder folder;
                FolderCredentialsProperty property;
                if (itemGroup instanceof AbstractFolder && (property = (FolderCredentialsProperty)(folder = (AbstractFolder)((Object)AbstractFolder.class.cast(itemGroup))).getProperties().get(FolderCredentialsProperty.class)) != null) {
                    for (Credentials c : DomainCredentials.getCredentials(property.getDomainCredentialsMap(), type, domainRequirements, (CredentialsMatcher)CredentialsMatchers.always())) {
                        if (c instanceof IdCredentials && !ids.add(((IdCredentials)c).getId())) continue;
                        result.add(c);
                    }
                }
                if (!(itemGroup instanceof Item)) break;
                itemGroup = ((Item)Item.class.cast(itemGroup)).getParent();
            }
        }
        return result;
    }

    @NonNull
    public <C extends Credentials> List<C> getCredentials(@NonNull Class<C> type, @NonNull Item item, @Nullable Authentication authentication, @NonNull List<DomainRequirement> domainRequirements) {
        if (item instanceof AbstractFolder) {
            return this.getCredentials(type, (ItemGroup)item, authentication, domainRequirements);
        }
        return super.getCredentials(type, item, authentication, domainRequirements);
    }

    @NonNull
    public <C extends IdCredentials> ListBoxModel getCredentialIds(@NonNull Class<C> type, @Nullable ItemGroup itemGroup, @Nullable Authentication authentication, @NonNull List<DomainRequirement> domainRequirements, @NonNull CredentialsMatcher matcher) {
        ListBoxModel result = new ListBoxModel();
        HashSet<String> ids = new HashSet<String>();
        if (ACL.SYSTEM.equals(authentication)) {
            while (itemGroup != null) {
                AbstractFolder folder;
                FolderCredentialsProperty property;
                if (itemGroup instanceof AbstractFolder && (property = (FolderCredentialsProperty)(folder = (AbstractFolder)((Object)AbstractFolder.class.cast(itemGroup))).getProperties().get(FolderCredentialsProperty.class)) != null) {
                    for (IdCredentials c : DomainCredentials.getCredentials(property.getDomainCredentialsMap(), type, domainRequirements, (CredentialsMatcher)matcher)) {
                        if (!ids.add(c.getId())) continue;
                        result.add(CredentialsNameProvider.name((Credentials)c), c.getId());
                    }
                }
                if (!(itemGroup instanceof Item)) break;
                itemGroup = ((Item)itemGroup).getParent();
            }
        }
        return result;
    }

    @NonNull
    public <C extends IdCredentials> ListBoxModel getCredentialIds(@NonNull Class<C> type, @NonNull Item item, @Nullable Authentication authentication, @NonNull List<DomainRequirement> domainRequirements, @NonNull CredentialsMatcher matcher) {
        if (item instanceof AbstractFolder) {
            return this.getCredentialIds(type, (ItemGroup)item, authentication, domainRequirements, matcher);
        }
        return this.getCredentialIds(type, item.getParent(), authentication, domainRequirements, matcher);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CredentialsStore getStore(@CheckForNull ModelObject object) {
        if (object instanceof AbstractFolder) {
            AbstractFolder folder = (AbstractFolder)((Object)AbstractFolder.class.cast(object));
            FolderCredentialsProperty property = (FolderCredentialsProperty)folder.getProperties().get(FolderCredentialsProperty.class);
            if (property != null) {
                return property.getStore();
            }
            WeakHashMap<AbstractFolder<?>, FolderCredentialsProperty> weakHashMap = emptyProperties;
            synchronized (weakHashMap) {
                property = emptyProperties.get((Object)folder);
                if (property == null) {
                    property = new FolderCredentialsProperty(folder);
                    emptyProperties.put(folder, property);
                }
            }
            return property.getStore();
        }
        return null;
    }

    public String getIconClassName() {
        return "icon-credentials-folder-store";
    }

    public static class FolderCredentialsProperty
    extends AbstractFolderProperty<AbstractFolder<?>> {
        @Deprecated
        private transient List<Credentials> credentials;
        private Map<Domain, List<Credentials>> domainCredentialsMap = new CopyOnWriteMap.Hash();
        private transient StoreImpl store = new StoreImpl();

        FolderCredentialsProperty(AbstractFolder<?> owner) {
            this.setOwner(owner);
            this.domainCredentialsMap = DomainCredentials.migrateListToMap(null, null);
        }

        @Deprecated
        public FolderCredentialsProperty(List<Credentials> credentials) {
            this.domainCredentialsMap = DomainCredentials.migrateListToMap(this.domainCredentialsMap, credentials);
        }

        @DataBoundConstructor
        public FolderCredentialsProperty(DomainCredentials[] domainCredentials) {
            this.domainCredentialsMap = DomainCredentials.asMap(Arrays.asList(domainCredentials));
        }

        @SuppressFBWarnings(value={"IS2_INCONSISTENT_SYNC"}, justification="Only unprotected during deserialization")
        private Object readResolve() throws ObjectStreamException {
            if (this.domainCredentialsMap == null) {
                this.domainCredentialsMap = DomainCredentials.migrateListToMap(this.domainCredentialsMap, this.credentials);
                this.credentials = null;
            }
            return this;
        }

        public <C extends Credentials> List<C> getCredentials(Class<C> type) {
            ArrayList<C> result = new ArrayList<C>();
            for (Credentials credential : this.getCredentials()) {
                if (!type.isInstance(credential)) continue;
                result.add(type.cast(credential));
            }
            return result;
        }

        public List<Credentials> getCredentials() {
            return this.getDomainCredentialsMap().get(Domain.global());
        }

        public List<DomainCredentials> getDomainCredentials() {
            return DomainCredentials.asList(this.getDomainCredentialsMap());
        }

        @NonNull
        public synchronized Map<Domain, List<Credentials>> getDomainCredentialsMap() {
            this.domainCredentialsMap = DomainCredentials.migrateListToMap(this.domainCredentialsMap, this.credentials);
            return this.domainCredentialsMap;
        }

        public synchronized void setDomainCredentialsMap(Map<Domain, List<Credentials>> domainCredentialsMap) {
            this.domainCredentialsMap = DomainCredentials.toCopyOnWriteMap(domainCredentialsMap);
        }

        @NonNull
        public synchronized StoreImpl getStore() {
            if (this.store == null) {
                this.store = new StoreImpl();
            }
            return this.store;
        }

        private void checkPermission(Permission p) {
            if (!this.store.hasPermission(p)) {
                throw new AccessDeniedException2(Jenkins.getAuthentication(), p);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void checkedSave(Permission p) throws IOException {
            this.checkPermission(p);
            SecurityContext orig = ACL.impersonate((Authentication)ACL.SYSTEM);
            try {
                FolderCredentialsProperty property = (FolderCredentialsProperty)this.owner.getProperties().get(FolderCredentialsProperty.class);
                if (property == null) {
                    WeakHashMap weakHashMap = emptyProperties;
                    synchronized (weakHashMap) {
                        this.owner.getProperties().add((Object)this);
                        emptyProperties.remove((Object)this.owner);
                    }
                }
                this.owner.save();
            }
            finally {
                SecurityContextHolder.setContext((SecurityContext)orig);
            }
        }

        private synchronized boolean addDomain(@NonNull Domain domain, List<Credentials> credentials) throws IOException {
            this.checkPermission(CredentialsProvider.MANAGE_DOMAINS);
            Map<Domain, List<Credentials>> domainCredentialsMap = this.getDomainCredentialsMap();
            if (domainCredentialsMap.containsKey(domain)) {
                List<Credentials> list = domainCredentialsMap.get(domain);
                boolean modified = false;
                for (Credentials c : credentials) {
                    if (list.contains(c)) continue;
                    list.add(c);
                    modified = true;
                }
                if (modified) {
                    this.checkedSave(CredentialsProvider.MANAGE_DOMAINS);
                }
                return modified;
            }
            domainCredentialsMap.put(domain, new ArrayList<Credentials>(credentials));
            this.checkedSave(CredentialsProvider.MANAGE_DOMAINS);
            return true;
        }

        private synchronized boolean removeDomain(@NonNull Domain domain) throws IOException {
            this.checkPermission(CredentialsProvider.MANAGE_DOMAINS);
            Map<Domain, List<Credentials>> domainCredentialsMap = this.getDomainCredentialsMap();
            if (domainCredentialsMap.containsKey(domain)) {
                domainCredentialsMap.remove(domain);
                this.checkedSave(CredentialsProvider.MANAGE_DOMAINS);
                return true;
            }
            return false;
        }

        private synchronized boolean updateDomain(@NonNull Domain current, @NonNull Domain replacement) throws IOException {
            this.checkPermission(CredentialsProvider.MANAGE_DOMAINS);
            Map<Domain, List<Credentials>> domainCredentialsMap = this.getDomainCredentialsMap();
            if (domainCredentialsMap.containsKey(current)) {
                domainCredentialsMap.put(replacement, domainCredentialsMap.remove(current));
                this.checkedSave(CredentialsProvider.MANAGE_DOMAINS);
                return true;
            }
            return false;
        }

        private synchronized boolean addCredentials(@NonNull Domain domain, @NonNull Credentials credentials) throws IOException {
            this.checkPermission(CredentialsProvider.CREATE);
            Map<Domain, List<Credentials>> domainCredentialsMap = this.getDomainCredentialsMap();
            if (domainCredentialsMap.containsKey(domain)) {
                List<Credentials> list = domainCredentialsMap.get(domain);
                if (list.contains(credentials)) {
                    return false;
                }
                list.add(credentials);
                this.checkedSave(CredentialsProvider.CREATE);
                return true;
            }
            return false;
        }

        @NonNull
        private synchronized List<Credentials> getCredentials(@NonNull Domain domain) {
            if (this.store.hasPermission(CredentialsProvider.VIEW)) {
                List<Credentials> list = this.getDomainCredentialsMap().get(domain);
                if (list == null || list.isEmpty()) {
                    return Collections.emptyList();
                }
                return Collections.unmodifiableList(new ArrayList<Credentials>(list));
            }
            return Collections.emptyList();
        }

        private synchronized boolean removeCredentials(@NonNull Domain domain, @NonNull Credentials credentials) throws IOException {
            this.checkPermission(CredentialsProvider.DELETE);
            Map<Domain, List<Credentials>> domainCredentialsMap = this.getDomainCredentialsMap();
            if (domainCredentialsMap.containsKey(domain)) {
                List<Credentials> list = domainCredentialsMap.get(domain);
                if (!list.contains(credentials)) {
                    return false;
                }
                list.remove(credentials);
                this.checkedSave(CredentialsProvider.DELETE);
                return true;
            }
            return false;
        }

        private synchronized boolean updateCredentials(@NonNull Domain domain, @NonNull Credentials current, @NonNull Credentials replacement) throws IOException {
            this.checkPermission(CredentialsProvider.UPDATE);
            Map<Domain, List<Credentials>> domainCredentialsMap = this.getDomainCredentialsMap();
            if (domainCredentialsMap.containsKey(domain)) {
                List<Credentials> list = domainCredentialsMap.get(domain);
                int index = list.indexOf(current);
                if (index == -1) {
                    return false;
                }
                list.set(index, replacement);
                this.checkedSave(CredentialsProvider.UPDATE);
                return true;
            }
            return false;
        }

        @Override
        public AbstractFolderProperty<?> reconfigure(StaplerRequest req, JSONObject form) throws Descriptor.FormException {
            return this;
        }

        private class StoreImpl
        extends CredentialsStore {
            private final CredentialsStoreAction storeAction;

            private StoreImpl() {
                this.storeAction = new CredentialsStoreActionImpl();
            }

            public ModelObject getContext() {
                return FolderCredentialsProperty.this.owner;
            }

            public boolean hasPermission(@NonNull Authentication a, @NonNull Permission permission) {
                return FolderCredentialsProperty.this.owner.getACL().hasPermission(a, permission);
            }

            public CredentialsStoreAction getStoreAction() {
                return this.storeAction;
            }

            @NonNull
            public List<Domain> getDomains() {
                return Collections.unmodifiableList(new ArrayList<Domain>(FolderCredentialsProperty.this.getDomainCredentialsMap().keySet()));
            }

            public boolean addDomain(@NonNull Domain domain, List<Credentials> credentials) throws IOException {
                return FolderCredentialsProperty.this.addDomain(domain, credentials);
            }

            public boolean removeDomain(@NonNull Domain domain) throws IOException {
                return FolderCredentialsProperty.this.removeDomain(domain);
            }

            public boolean updateDomain(@NonNull Domain current, @NonNull Domain replacement) throws IOException {
                return FolderCredentialsProperty.this.updateDomain(current, replacement);
            }

            public boolean addCredentials(@NonNull Domain domain, @NonNull Credentials credentials) throws IOException {
                return FolderCredentialsProperty.this.addCredentials(domain, credentials);
            }

            @NonNull
            public List<Credentials> getCredentials(@NonNull Domain domain) {
                return FolderCredentialsProperty.this.getCredentials(domain);
            }

            public boolean removeCredentials(@NonNull Domain domain, @NonNull Credentials credentials) throws IOException {
                return FolderCredentialsProperty.this.removeCredentials(domain, credentials);
            }

            public boolean updateCredentials(@NonNull Domain domain, @NonNull Credentials current, @NonNull Credentials replacement) throws IOException {
                return FolderCredentialsProperty.this.updateCredentials(domain, current, replacement);
            }
        }

        @Extension(optional=true)
        public static class DescriptorImpl
        extends AbstractFolderPropertyDescriptor {
            public String getDisplayName() {
                return Messages.FolderCredentialsProvider_DisplayName();
            }

            public DescriptorExtensionList<DomainSpecification, Descriptor<DomainSpecification>> getSpecificationDescriptors() {
                return Jenkins.getActiveInstance().getDescriptorList(DomainSpecification.class);
            }
        }

        @Restricted(value={NoExternalUse.class})
        public class CredentialsStoreActionImpl
        extends CredentialsStoreAction {
            @NonNull
            public StoreImpl getStore() {
                return FolderCredentialsProperty.this.getStore();
            }

            public String getIconFileName() {
                return this.isVisible() ? "/plugin/credentials/images/48x48/folder-store.png" : null;
            }

            public String getIconClassName() {
                return this.isVisible() ? "icon-credentials-folder-store" : null;
            }

            public String getDisplayName() {
                return "Folder";
            }
        }
    }
}

