/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.hudson.plugins.folder;

import com.cloudbees.hudson.plugins.folder.AbstractFolderDescriptor;
import com.cloudbees.hudson.plugins.folder.AbstractFolderProperty;
import com.cloudbees.hudson.plugins.folder.AbstractFolderPropertyDescriptor;
import com.cloudbees.hudson.plugins.folder.Folder;
import com.cloudbees.hudson.plugins.folder.FolderIcon;
import com.cloudbees.hudson.plugins.folder.health.FolderHealthMetric;
import com.cloudbees.hudson.plugins.folder.health.FolderHealthMetricDescriptor;
import com.cloudbees.hudson.plugins.folder.icons.StockFolderIcon;
import com.cloudbees.hudson.plugins.folder.properties.AuthorizationMatrixProperty;
import hudson.BulkChange;
import hudson.Util;
import hudson.init.InitMilestone;
import hudson.init.Initializer;
import hudson.model.AbstractItem;
import hudson.model.Action;
import hudson.model.AllView;
import hudson.model.Descriptor;
import hudson.model.HealthReport;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.ItemGroupMixIn;
import hudson.model.Items;
import hudson.model.Job;
import hudson.model.ModifiableViewGroup;
import hudson.model.Saveable;
import hudson.model.TopLevelItem;
import hudson.model.View;
import hudson.model.ViewGroup;
import hudson.model.ViewGroupMixIn;
import hudson.model.listeners.ItemListener;
import hudson.search.CollectionSearchIndex;
import hudson.search.SearchIndex;
import hudson.search.SearchIndexBuilder;
import hudson.search.SearchItem;
import hudson.security.ACL;
import hudson.security.AuthorizationStrategy;
import hudson.security.ProjectMatrixAuthorizationStrategy;
import hudson.util.AlternativeUiTextProvider;
import hudson.util.CaseInsensitiveComparator;
import hudson.util.CopyOnWriteMap;
import hudson.util.DescribableList;
import hudson.util.FormApply;
import hudson.util.FormValidation;
import hudson.util.Function1;
import hudson.util.HttpResponses;
import hudson.views.DefaultViewsTabBar;
import hudson.views.ViewsTabBar;
import java.io.File;
import java.io.IOException;
import java.net.URLEncoder;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.servlet.ServletException;
import jenkins.model.Jenkins;
import jenkins.model.Messages;
import jenkins.model.ModelObjectWithChildren;
import jenkins.model.ModelObjectWithContextMenu;
import jenkins.model.ProjectNamingStrategy;
import net.sf.json.JSONObject;
import org.acegisecurity.AccessDeniedException;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.DoNotUse;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerFallback;
import org.kohsuke.stapler.StaplerOverridable;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.interceptor.RequirePOST;

public abstract class AbstractFolder<I extends TopLevelItem>
extends AbstractItem
implements TopLevelItem,
ItemGroup<I>,
ModifiableViewGroup,
StaplerFallback,
ModelObjectWithChildren,
StaplerOverridable {
    private static final Logger LOGGER = Logger.getLogger(AbstractFolder.class.getName());
    private static long loadingTick;
    private static final AtomicInteger jobTotal;
    private static final AtomicInteger jobEncountered;
    private static final AtomicBoolean loadJobTotalRan;
    private static final int TICK_INTERVAL = 15000;
    protected transient Map<String, I> items = new CopyOnWriteMap.Tree(CaseInsensitiveComparator.INSTANCE);
    private DescribableList<AbstractFolderProperty<?>, AbstractFolderPropertyDescriptor> properties;
    private CopyOnWriteArrayList<View> views;
    private volatile ViewsTabBar viewsTabBar;
    private volatile String primaryView;
    private transient ViewGroupMixIn viewGroupMixIn;
    private DescribableList<FolderHealthMetric, FolderHealthMetricDescriptor> healthMetrics;
    private FolderIcon icon;

    @Initializer(before=InitMilestone.JOB_LOADED, fatal=false)
    public static void loadJobTotal() {
        if (!loadJobTotalRan.compareAndSet(false, true)) {
            return;
        }
        AbstractFolder.scan(new File(Jenkins.getActiveInstance().getRootDir(), "jobs"), 0);
    }

    private static void scan(File d, int depth) {
        File[] projects = d.listFiles();
        if (projects == null) {
            return;
        }
        for (File project : projects) {
            File jobs;
            if (!new File(project, "config.xml").isFile()) continue;
            if (depth > 0) {
                jobTotal.incrementAndGet();
            }
            if (!(jobs = new File(project, "jobs")).isDirectory()) continue;
            AbstractFolder.scan(jobs, depth + 1);
        }
    }

    protected AbstractFolder(ItemGroup parent, String name) {
        super(parent, name);
    }

    protected void init() {
        if (this.properties == null) {
            this.properties = new DescribableList((Saveable)this);
        }
        for (AbstractFolderProperty p : this.properties) {
            p.setOwner(this);
        }
        if (this.icon == null) {
            this.icon = new StockFolderIcon();
        }
        if (this.views == null) {
            this.views = new CopyOnWriteArrayList();
        }
        if (this.views.isEmpty()) {
            try {
                this.initViews(this.views);
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, "Failed to set up the initial view", e);
            }
        }
        if (this.viewsTabBar == null) {
            this.viewsTabBar = new DefaultViewsTabBar();
        }
        if (this.primaryView == null) {
            this.primaryView = this.views.get(0).getViewName();
        }
        this.viewGroupMixIn = new ViewGroupMixIn((ViewGroup)this){

            protected List<View> views() {
                return AbstractFolder.this.views;
            }

            protected String primaryView() {
                return AbstractFolder.this.primaryView;
            }

            protected void primaryView(String name) {
                AbstractFolder.this.primaryView = name;
            }
        };
        if (this.healthMetrics == null) {
            ArrayList<FolderHealthMetric> metrics = new ArrayList<FolderHealthMetric>();
            for (FolderHealthMetricDescriptor d : FolderHealthMetricDescriptor.all()) {
                FolderHealthMetric metric = d.createDefault();
                if (metric == null) continue;
                metrics.add(metric);
            }
            this.healthMetrics = new DescribableList((Saveable)this, metrics);
        }
    }

    protected void initViews(List<View> views) throws IOException {
        AllView v = new AllView("All", (ViewGroup)this);
        views.add((View)v);
        v.save();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onLoad(ItemGroup<? extends Item> parent, String name) throws IOException {
        super.onLoad(parent, name);
        this.init();
        final Thread t = Thread.currentThread();
        String n = t.getName();
        try {
            Item current;
            if (this.items == null && (current = parent.getItem(name)) != null && current.getClass() == ((Object)((Object)this)).getClass()) {
                this.items = ((AbstractFolder)current).items;
            }
            this.items = ItemGroupMixIn.loadChildren((ItemGroup)this, (File)this.getJobsDir(), (Function1)new Function1<String, I>(){

                public String call(I item) {
                    String fullName = item.getFullName();
                    t.setName("Loading job " + fullName);
                    float percentage = 100.0f * (float)jobEncountered.incrementAndGet() / (float)Math.max(1, jobTotal.get());
                    long now = System.currentTimeMillis();
                    if (loadingTick == 0L) {
                        loadingTick = now;
                    } else if (now - loadingTick > 15000L) {
                        LOGGER.log(Level.INFO, String.format("Loading job %s (%.1f%%)", fullName, Float.valueOf(percentage)));
                        loadingTick = now;
                    }
                    return item.getName();
                }
            });
        }
        finally {
            t.setName(n);
        }
    }

    public AbstractFolderDescriptor getDescriptor() {
        return (AbstractFolderDescriptor)Jenkins.getActiveInstance().getDescriptorOrDie(((Object)((Object)this)).getClass());
    }

    public DescribableList<AbstractFolderProperty<?>, AbstractFolderPropertyDescriptor> getProperties() {
        return this.properties;
    }

    public void addProperty(AbstractFolderProperty p) throws IOException {
        if (!p.getDescriptor().isApplicable(((Object)((Object)this)).getClass())) {
            throw new IllegalArgumentException(((Object)((Object)p)).getClass().getName() + " cannot be applied to " + ((Object)((Object)this)).getClass().getName());
        }
        p.setOwner(this);
        this.properties.add((Object)p);
    }

    protected File getJobsDir() {
        return new File(this.getRootDir(), "jobs");
    }

    protected final File getRootDirFor(String name) {
        return new File(this.getJobsDir(), name);
    }

    public File getRootDirFor(I child) {
        return this.getRootDirFor(child.getName());
    }

    public String getUrlChildPrefix() {
        return "job";
    }

    public I getJob(String name) {
        return this.getItem(name);
    }

    public String getPronoun() {
        return AlternativeUiTextProvider.get((AlternativeUiTextProvider.Message)PRONOUN, (Object)((Object)this), (String)this.getDescriptor().getDisplayName());
    }

    public Collection<?> getOverrides() {
        ArrayList r = new ArrayList();
        for (AbstractFolderProperty p : this.properties) {
            r.addAll(p.getItemContainerOverrides());
        }
        return r;
    }

    public void addView(View v) throws IOException {
        this.viewGroupMixIn.addView(v);
    }

    public boolean canDelete(View view) {
        return this.viewGroupMixIn.canDelete(view);
    }

    public void deleteView(View view) throws IOException {
        this.viewGroupMixIn.deleteView(view);
    }

    public View getView(String name) {
        return this.viewGroupMixIn.getView(name);
    }

    @Exported
    public Collection<View> getViews() {
        return this.viewGroupMixIn.getViews();
    }

    @Exported
    public View getPrimaryView() {
        return this.viewGroupMixIn.getPrimaryView();
    }

    public void setPrimaryView(View v) {
        this.primaryView = v.getViewName();
    }

    public void onViewRenamed(View view, String oldName, String newName) {
        this.viewGroupMixIn.onViewRenamed(view, oldName, newName);
    }

    public ViewsTabBar getViewsTabBar() {
        return this.viewsTabBar;
    }

    public ItemGroup<? extends TopLevelItem> getItemGroup() {
        return this;
    }

    public List<Action> getViewActions() {
        return Collections.emptyList();
    }

    public View getStaplerFallback() {
        return this.getPrimaryView();
    }

    protected SearchIndexBuilder makeSearchIndex() {
        return super.makeSearchIndex().add((SearchIndex)new CollectionSearchIndex<TopLevelItem>(){

            protected SearchItem get(String key) {
                return Jenkins.getActiveInstance().getItem(key, this.grp());
            }

            protected Collection<TopLevelItem> all() {
                return Items.getAllItems(this.grp(), TopLevelItem.class);
            }

            protected String getName(TopLevelItem j) {
                return j.getRelativeNameFrom(this.grp());
            }

            private ItemGroup<?> grp() {
                return AbstractFolder.this;
            }
        });
    }

    public ModelObjectWithContextMenu.ContextMenu doChildrenContextMenu(StaplerRequest request, StaplerResponse response) {
        ModelObjectWithContextMenu.ContextMenu menu = new ModelObjectWithContextMenu.ContextMenu();
        for (View view : this.getViews()) {
            menu.add(view.getAbsoluteUrl(), view.getDisplayName());
        }
        return menu;
    }

    public synchronized void doCreateView(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException, ParseException, Descriptor.FormException {
        this.checkPermission(View.CREATE);
        this.addView(View.create((StaplerRequest)req, (StaplerResponse)rsp, (ViewGroup)this));
    }

    public FormValidation doViewExistsCheck(@QueryParameter String value) {
        this.checkPermission(View.CREATE);
        String view = Util.fixEmpty((String)value);
        if (view == null) {
            return FormValidation.ok();
        }
        if (this.getView(view) == null) {
            return FormValidation.ok();
        }
        return FormValidation.error((String)Messages.Hudson_ViewAlreadyExists((Object)view));
    }

    public HealthReport getBuildHealth() {
        List<HealthReport> reports = this.getBuildHealthReports();
        return reports.isEmpty() ? new HealthReport() : reports.get(0);
    }

    @Exported(name="healthReport")
    public List<HealthReport> getBuildHealthReports() {
        if (this.healthMetrics == null || this.healthMetrics.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<HealthReport> reports = new ArrayList<HealthReport>();
        ArrayList<FolderHealthMetric.Reporter> reporters = new ArrayList<FolderHealthMetric.Reporter>(this.healthMetrics.size());
        for (FolderHealthMetric metric : this.healthMetrics) {
            reporters.add(metric.reporter());
        }
        for (AbstractFolderProperty p : this.getProperties()) {
            for (FolderHealthMetric metric : p.getHealthMetrics()) {
                reporters.add(metric.reporter());
            }
        }
        Stack<Collection<I>> stack = new Stack<Collection<I>>();
        stack.push(this.getItems());
        while (!stack.isEmpty()) {
            for (Item item : (Iterable)stack.pop()) {
                for (FolderHealthMetric.Reporter reporter : reporters) {
                    reporter.observe(item);
                }
                if (!(item instanceof Folder)) continue;
                stack.push(((Folder)item).getItems());
            }
        }
        for (FolderHealthMetric.Reporter reporter : reporters) {
            reports.addAll(reporter.report());
        }
        for (AbstractFolderProperty p : this.getProperties()) {
            reports.addAll(p.getHealthReports());
        }
        Collections.sort(reports);
        return reports;
    }

    public DescribableList<FolderHealthMetric, FolderHealthMetricDescriptor> getHealthMetrics() {
        return this.healthMetrics;
    }

    public HttpResponse doLastBuild(StaplerRequest req) {
        return HttpResponses.redirectToDot();
    }

    public ACL getACL() {
        AuthorizationMatrixProperty p;
        AuthorizationStrategy as = Jenkins.getActiveInstance().getAuthorizationStrategy();
        if (as.getClass().getName().equals("hudson.security.ProjectMatrixAuthorizationStrategy") && (p = (AuthorizationMatrixProperty)this.getProperties().get(AuthorizationMatrixProperty.class)) != null) {
            return p.getACL().newInheritingACL(((ProjectMatrixAuthorizationStrategy)as).getACL(this.getParent()));
        }
        return super.getACL();
    }

    public FolderIcon getIcon() {
        return this.icon;
    }

    public void setIcon(FolderIcon icon) {
        this.icon = icon;
        icon.setOwner(this);
    }

    public FolderIcon getIconColor() {
        return this.icon;
    }

    public Collection<? extends Job> getAllJobs() {
        HashSet jobs = new HashSet();
        for (Item i : this.getItems()) {
            jobs.addAll(i.getAllJobs());
        }
        return jobs;
    }

    @Exported(name="jobs")
    public Collection<I> getItems() {
        ArrayList<TopLevelItem> viewableItems = new ArrayList<TopLevelItem>();
        for (TopLevelItem item : this.items.values()) {
            if (!item.hasPermission(Item.READ)) continue;
            viewableItems.add(item);
        }
        return viewableItems;
    }

    public I getItem(String name) throws AccessDeniedException {
        if (this.items == null) {
            return null;
        }
        TopLevelItem item = (TopLevelItem)this.items.get(name);
        if (item == null) {
            return null;
        }
        if (!item.hasPermission(Item.READ)) {
            if (item.hasPermission(Item.DISCOVER)) {
                throw new AccessDeniedException("Please log in to access " + name);
            }
            return null;
        }
        return (I)item;
    }

    public void onRenamed(TopLevelItem item, String oldName, String newName) throws IOException {
        this.items.remove(oldName);
        this.items.put(newName, item);
        for (View v : this.views) {
            v.onJobRenamed((Item)item, oldName, newName);
        }
        this.save();
    }

    public void onDeleted(TopLevelItem item) throws IOException {
        ItemListener.fireOnDeleted((Item)item);
        this.items.remove(item.getName());
        for (View v : this.views) {
            v.onJobRenamed((Item)item, item.getName(), null);
        }
        this.save();
    }

    /*
     * Exception decompiling
     */
    protected void performDelete() throws IOException, InterruptedException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public synchronized void save() throws IOException {
        if (BulkChange.contains((Saveable)this)) {
            return;
        }
        super.save();
        ItemListener.fireOnUpdated((Item)this);
    }

    public void renameTo(String newName) throws IOException {
        super.renameTo(newName);
    }

    public synchronized void doSubmitDescription(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
        this.getPrimaryView().doSubmitDescription(req, rsp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequirePOST
    @Restricted(value={NoExternalUse.class})
    public void doConfigSubmit(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException, Descriptor.FormException {
        this.checkPermission(CONFIGURE);
        req.setCharacterEncoding("UTF-8");
        JSONObject json = req.getSubmittedForm();
        BulkChange bc = new BulkChange((Saveable)this);
        try {
            this.description = json.getString("description");
            this.displayName = Util.fixEmpty((String)json.optString("displayNameOrNull"));
            if (json.has("viewsTabBar")) {
                this.viewsTabBar = (ViewsTabBar)req.bindJSON(ViewsTabBar.class, json.getJSONObject("viewsTabBar"));
            }
            if (json.has("primaryView")) {
                this.primaryView = json.getString("primaryView");
            }
            this.properties.rebuild(req, json, this.getDescriptor().getPropertyDescriptors());
            for (AbstractFolderProperty p : this.properties) {
                p.setOwner(this);
            }
            this.healthMetrics.replaceBy((Collection)req.bindJSONToList(FolderHealthMetric.class, json.get("healthMetrics")));
            this.icon = (FolderIcon)((Object)req.bindJSON(FolderIcon.class, req.getSubmittedForm().getJSONObject("icon")));
            this.icon.setOwner(this);
            this.submit(req, rsp);
            this.save();
            bc.commit();
        }
        finally {
            bc.abort();
        }
        String newName = json.getString("name");
        ProjectNamingStrategy namingStrategy = Jenkins.getActiveInstance().getProjectNamingStrategy();
        if (newName != null && !newName.equals(this.name)) {
            Jenkins.checkGoodName((String)newName);
            namingStrategy.checkName(newName);
            rsp.sendRedirect("rename?newName=" + URLEncoder.encode(newName, "UTF-8"));
        } else {
            if (namingStrategy.isForceExistingJobs()) {
                namingStrategy.checkName(this.name);
            }
            FormApply.success((String)".").generateResponse(req, rsp, (Object)this);
        }
    }

    protected void submit(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException, Descriptor.FormException {
    }

    @RequirePOST
    @Restricted(value={DoNotUse.class})
    public void doDoRename(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
        if (!this.hasPermission(CONFIGURE)) {
            this.checkPermission(CREATE);
            this.checkPermission(DELETE);
        }
        String newName = req.getParameter("newName");
        Jenkins.checkGoodName((String)newName);
        String blocker = this.renameBlocker();
        if (blocker != null) {
            rsp.sendRedirect("rename?newName=" + URLEncoder.encode(newName, "UTF-8") + "&blocker=" + URLEncoder.encode(blocker, "UT-8"));
            return;
        }
        this.renameTo(newName);
        rsp.sendRedirect2("../" + newName);
    }

    @CheckForNull
    protected String renameBlocker() {
        for (Job job : this.getAllJobs()) {
            if (!job.isBuilding()) continue;
            return "Unable to rename a folder while a job inside it is building.";
        }
        return null;
    }

    static {
        jobTotal = new AtomicInteger();
        jobEncountered = new AtomicInteger();
        loadJobTotalRan = new AtomicBoolean();
    }
}

