/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.hudson.plugins.folder.properties;

import com.cloudbees.hudson.plugins.folder.Folder;
import com.cloudbees.hudson.plugins.folder.FolderProperty;
import com.cloudbees.hudson.plugins.folder.FolderPropertyDescriptor;
import com.cloudbees.hudson.plugins.folder.properties.Messages;
import com.cloudbees.plugins.credentials.Credentials;
import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.CredentialsScope;
import com.cloudbees.plugins.credentials.CredentialsStore;
import com.cloudbees.plugins.credentials.CredentialsStoreAction;
import com.cloudbees.plugins.credentials.domains.Domain;
import com.cloudbees.plugins.credentials.domains.DomainCredentials;
import com.cloudbees.plugins.credentials.domains.DomainRequirement;
import com.cloudbees.plugins.credentials.domains.DomainSpecification;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import hudson.DescriptorExtensionList;
import hudson.Extension;
import hudson.model.Action;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.ModelObject;
import hudson.security.ACL;
import hudson.security.AccessDeniedException2;
import hudson.security.Permission;
import hudson.util.CopyOnWriteMap;
import java.io.IOException;
import java.io.ObjectStreamException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jenkins.model.Jenkins;
import org.acegisecurity.Authentication;
import org.acegisecurity.context.SecurityContextHolder;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Extension(optional=true)
public class FolderCredentialsProvider
extends CredentialsProvider {
    private static final Set<CredentialsScope> SCOPES = Collections.singleton(CredentialsScope.GLOBAL);

    public Set<CredentialsScope> getScopes(ModelObject object) {
        if (object instanceof Folder) {
            return SCOPES;
        }
        return super.getScopes(object);
    }

    @NonNull
    public <C extends Credentials> List<C> getCredentials(@NonNull Class<C> type, @Nullable ItemGroup itemGroup, @Nullable Authentication authentication) {
        return this.getCredentials(type, itemGroup, authentication, Collections.<DomainRequirement>emptyList());
    }

    @NonNull
    public <C extends Credentials> List<C> getCredentials(@NonNull Class<C> type, @Nullable ItemGroup itemGroup, @Nullable Authentication authentication, @NonNull List<DomainRequirement> domainRequirements) {
        if (authentication == null) {
            authentication = ACL.SYSTEM;
        }
        ArrayList result = new ArrayList();
        if (ACL.SYSTEM.equals(authentication)) {
            while (itemGroup != null) {
                Folder folder;
                FolderCredentialsProperty property;
                if (itemGroup instanceof Folder && (property = (FolderCredentialsProperty)(folder = (Folder)((Object)Folder.class.cast(itemGroup))).getProperties().get(FolderCredentialsProperty.class)) != null) {
                    result.addAll(DomainCredentials.getCredentials(property.getDomainCredentialsMap(), type, domainRequirements, (CredentialsMatcher)CredentialsMatchers.always()));
                }
                if (!(itemGroup instanceof Item)) break;
                itemGroup = ((Item)Item.class.cast(itemGroup)).getParent();
            }
        }
        return result;
    }

    public CredentialsStore getStore(@CheckForNull ModelObject object) {
        Folder folder;
        FolderCredentialsProperty property;
        if (object instanceof Folder && (property = (FolderCredentialsProperty)(folder = (Folder)((Object)Folder.class.cast(object))).getProperties().get(FolderCredentialsProperty.class)) != null) {
            return property.getStore();
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class FolderCredentialsProperty
    extends FolderProperty<Folder> {
        @Deprecated
        private transient List<Credentials> credentials;
        private Map<Domain, List<Credentials>> domainCredentialsMap = new CopyOnWriteMap.Hash();
        private transient StoreImpl store = new StoreImpl();

        @Deprecated
        public FolderCredentialsProperty(List<Credentials> credentials) {
            this.domainCredentialsMap = DomainCredentials.migrateListToMap(this.domainCredentialsMap, credentials);
        }

        @DataBoundConstructor
        public FolderCredentialsProperty(DomainCredentials[] domainCredentials) {
            this.domainCredentialsMap = DomainCredentials.asMap(Arrays.asList(domainCredentials));
        }

        private Object readResolve() throws ObjectStreamException {
            if (this.domainCredentialsMap == null) {
                this.domainCredentialsMap = DomainCredentials.migrateListToMap(this.domainCredentialsMap, this.credentials);
                this.credentials = null;
            }
            return this;
        }

        public <C extends Credentials> List<C> getCredentials(Class<C> type) {
            ArrayList<C> result = new ArrayList<C>();
            for (Credentials credential : this.getCredentials()) {
                if (!type.isInstance(credential)) continue;
                result.add(type.cast(credential));
            }
            return result;
        }

        public List<Credentials> getCredentials() {
            return this.getDomainCredentialsMap().get(Domain.global());
        }

        public List<DomainCredentials> getDomainCredentials() {
            return DomainCredentials.asList(this.getDomainCredentialsMap());
        }

        @NonNull
        public synchronized Map<Domain, List<Credentials>> getDomainCredentialsMap() {
            this.domainCredentialsMap = DomainCredentials.migrateListToMap(this.domainCredentialsMap, this.credentials);
            return this.domainCredentialsMap;
        }

        public synchronized void setDomainCredentialsMap(Map<Domain, List<Credentials>> domainCredentialsMap) {
            this.domainCredentialsMap = DomainCredentials.toCopyOnWriteMap(domainCredentialsMap);
        }

        public synchronized CredentialsStore getStore() {
            if (this.store == null) {
                this.store = new StoreImpl();
            }
            return this.store;
        }

        private void checkPermission(Permission p) {
            if (!this.store.hasPermission(p)) {
                throw new AccessDeniedException2(Jenkins.getAuthentication(), p);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void checkedSave(Permission p) throws IOException {
            this.checkPermission(p);
            Authentication old = SecurityContextHolder.getContext().getAuthentication();
            SecurityContextHolder.getContext().setAuthentication(ACL.SYSTEM);
            try {
                this.owner.save();
            }
            finally {
                SecurityContextHolder.getContext().setAuthentication(old);
            }
        }

        private synchronized boolean addDomain(@NonNull Domain domain, List<Credentials> credentials) throws IOException {
            this.checkPermission(CredentialsProvider.MANAGE_DOMAINS);
            Map<Domain, List<Credentials>> domainCredentialsMap = this.getDomainCredentialsMap();
            if (domainCredentialsMap.containsKey(domain)) {
                List<Credentials> list = domainCredentialsMap.get(domain);
                boolean modified = false;
                for (Credentials c : credentials) {
                    if (list.contains(c)) continue;
                    list.add(c);
                    modified = true;
                }
                if (modified) {
                    this.checkedSave(CredentialsProvider.MANAGE_DOMAINS);
                }
                return modified;
            }
            domainCredentialsMap.put(domain, new ArrayList<Credentials>(credentials));
            this.checkedSave(CredentialsProvider.MANAGE_DOMAINS);
            return true;
        }

        private synchronized boolean removeDomain(@NonNull Domain domain) throws IOException {
            this.checkPermission(CredentialsProvider.MANAGE_DOMAINS);
            Map<Domain, List<Credentials>> domainCredentialsMap = this.getDomainCredentialsMap();
            if (domainCredentialsMap.containsKey(domain)) {
                domainCredentialsMap.remove(domain);
                this.checkedSave(CredentialsProvider.MANAGE_DOMAINS);
                return true;
            }
            return false;
        }

        private synchronized boolean updateDomain(@NonNull Domain current, @NonNull Domain replacement) throws IOException {
            this.checkPermission(CredentialsProvider.MANAGE_DOMAINS);
            Map<Domain, List<Credentials>> domainCredentialsMap = this.getDomainCredentialsMap();
            if (domainCredentialsMap.containsKey(current)) {
                domainCredentialsMap.put(replacement, domainCredentialsMap.remove(current));
                this.checkedSave(CredentialsProvider.MANAGE_DOMAINS);
                return true;
            }
            return false;
        }

        private synchronized boolean addCredentials(@NonNull Domain domain, @NonNull Credentials credentials) throws IOException {
            this.checkPermission(CredentialsProvider.CREATE);
            Map<Domain, List<Credentials>> domainCredentialsMap = this.getDomainCredentialsMap();
            if (domainCredentialsMap.containsKey(domain)) {
                List<Credentials> list = domainCredentialsMap.get(domain);
                if (list.contains(credentials)) {
                    return false;
                }
                list.add(credentials);
                this.checkedSave(CredentialsProvider.CREATE);
                return true;
            }
            return false;
        }

        @NonNull
        private synchronized List<Credentials> getCredentials(@NonNull Domain domain) {
            if (Jenkins.getInstance().hasPermission(CredentialsProvider.VIEW)) {
                List<Credentials> list = this.getDomainCredentialsMap().get(domain);
                if (list == null || list.isEmpty()) {
                    return Collections.emptyList();
                }
                return Collections.unmodifiableList(new ArrayList<Credentials>(list));
            }
            return Collections.emptyList();
        }

        private synchronized boolean removeCredentials(@NonNull Domain domain, @NonNull Credentials credentials) throws IOException {
            this.checkPermission(CredentialsProvider.DELETE);
            Map<Domain, List<Credentials>> domainCredentialsMap = this.getDomainCredentialsMap();
            if (domainCredentialsMap.containsKey(domain)) {
                List<Credentials> list = domainCredentialsMap.get(domain);
                if (!list.contains(credentials)) {
                    return false;
                }
                list.remove(credentials);
                this.checkedSave(CredentialsProvider.DELETE);
                return true;
            }
            return false;
        }

        private synchronized boolean updateCredentials(@NonNull Domain domain, @NonNull Credentials current, @NonNull Credentials replacement) throws IOException {
            this.checkPermission(CredentialsProvider.UPDATE);
            Map<Domain, List<Credentials>> domainCredentialsMap = this.getDomainCredentialsMap();
            if (domainCredentialsMap.containsKey(domain)) {
                List<Credentials> list = domainCredentialsMap.get(domain);
                int index = list.indexOf(current);
                if (index == -1) {
                    return false;
                }
                list.set(index, replacement);
                this.checkedSave(CredentialsProvider.UPDATE);
                return true;
            }
            return false;
        }

        @Override
        @NonNull
        public Collection<? extends Action> getFolderActions() {
            return Collections.singleton(new CredentialsStoreAction(){

                @NonNull
                public CredentialsStore getStore() {
                    return FolderCredentialsProperty.this.getStore();
                }
            });
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class StoreImpl
        extends CredentialsStore {
            private StoreImpl() {
            }

            public ModelObject getContext() {
                return FolderCredentialsProperty.this.owner;
            }

            public boolean hasPermission(@NonNull Authentication a, @NonNull Permission permission) {
                return FolderCredentialsProperty.this.owner.getACL().hasPermission(a, permission);
            }

            @NonNull
            public List<Domain> getDomains() {
                return Collections.unmodifiableList(new ArrayList<Domain>(FolderCredentialsProperty.this.getDomainCredentialsMap().keySet()));
            }

            public boolean addDomain(@NonNull Domain domain, List<Credentials> credentials) throws IOException {
                return FolderCredentialsProperty.this.addDomain(domain, credentials);
            }

            public boolean removeDomain(@NonNull Domain domain) throws IOException {
                return FolderCredentialsProperty.this.removeDomain(domain);
            }

            public boolean updateDomain(@NonNull Domain current, @NonNull Domain replacement) throws IOException {
                return FolderCredentialsProperty.this.updateDomain(current, replacement);
            }

            public boolean addCredentials(@NonNull Domain domain, @NonNull Credentials credentials) throws IOException {
                return FolderCredentialsProperty.this.addCredentials(domain, credentials);
            }

            @NonNull
            public List<Credentials> getCredentials(@NonNull Domain domain) {
                return FolderCredentialsProperty.this.getCredentials(domain);
            }

            public boolean removeCredentials(@NonNull Domain domain, @NonNull Credentials credentials) throws IOException {
                return FolderCredentialsProperty.this.removeCredentials(domain, credentials);
            }

            public boolean updateCredentials(@NonNull Domain domain, @NonNull Credentials current, @NonNull Credentials replacement) throws IOException {
                return FolderCredentialsProperty.this.updateCredentials(domain, current, replacement);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        @Extension
        public static class DescriptorImpl
        extends FolderPropertyDescriptor {
            public String getDisplayName() {
                return Messages.FolderCredentialsProvider_DisplayName();
            }

            public List<DomainCredentials> defaultIfNull(List<DomainCredentials> map) {
                if (map == null) {
                    return Collections.singletonList(new DomainCredentials(Domain.global(), Collections.emptyList()));
                }
                return map;
            }

            public DescriptorExtensionList<Credentials, Descriptor<Credentials>> getCredentialDescriptors() {
                return CredentialsProvider.allCredentialsDescriptors();
            }

            public DescriptorExtensionList<DomainSpecification, Descriptor<DomainSpecification>> getSpecificationDescriptors() {
                return Jenkins.getInstance().getDescriptorList(DomainSpecification.class);
            }
        }
    }
}

