/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.hudson.plugins.folder;

import com.cloudbees.hudson.plugins.folder.FolderIcon;
import com.cloudbees.hudson.plugins.folder.FolderProperty;
import com.cloudbees.hudson.plugins.folder.FolderPropertyDescriptor;
import com.cloudbees.hudson.plugins.folder.Messages;
import com.cloudbees.hudson.plugins.folder.TransientFolderActionFactory;
import com.cloudbees.hudson.plugins.folder.health.FolderHealthMetric;
import com.cloudbees.hudson.plugins.folder.health.FolderHealthMetricDescriptor;
import com.cloudbees.hudson.plugins.folder.icons.StockFolderIcon;
import com.cloudbees.hudson.plugins.folder.properties.AuthorizationMatrixProperty;
import hudson.AbortException;
import hudson.Extension;
import hudson.Util;
import hudson.init.InitMilestone;
import hudson.init.Initializer;
import hudson.model.AbstractItem;
import hudson.model.Action;
import hudson.model.AutoCompletionCandidates;
import hudson.model.Descriptor;
import hudson.model.Failure;
import hudson.model.HealthReport;
import hudson.model.Hudson;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.ItemGroupMixIn;
import hudson.model.ItemVisitor;
import hudson.model.Items;
import hudson.model.Job;
import hudson.model.ListView;
import hudson.model.Saveable;
import hudson.model.TopLevelItem;
import hudson.model.TopLevelItemDescriptor;
import hudson.model.View;
import hudson.model.ViewGroup;
import hudson.model.ViewGroupMixIn;
import hudson.model.listeners.ItemListener;
import hudson.search.CollectionSearchIndex;
import hudson.search.SearchIndex;
import hudson.search.SearchIndexBuilder;
import hudson.search.SearchItem;
import hudson.security.ACL;
import hudson.security.AccessControlled;
import hudson.security.AuthorizationStrategy;
import hudson.security.ProjectMatrixAuthorizationStrategy;
import hudson.util.AlternativeUiTextProvider;
import hudson.util.CaseInsensitiveComparator;
import hudson.util.CopyOnWriteMap;
import hudson.util.DescribableList;
import hudson.util.FormApply;
import hudson.util.FormValidation;
import hudson.util.Function1;
import hudson.util.HttpResponses;
import hudson.util.IOException2;
import hudson.views.DefaultViewsTabBar;
import hudson.views.ListViewColumn;
import hudson.views.ViewJobFilter;
import hudson.views.ViewsTabBar;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLEncoder;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.Vector;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import jenkins.model.DirectlyModifiableTopLevelItemGroup;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerFallback;
import org.kohsuke.stapler.StaplerOverridable;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.interceptor.RequirePOST;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Folder
extends AbstractItem
implements DirectlyModifiableTopLevelItemGroup,
ViewGroup,
TopLevelItem,
StaplerOverridable,
StaplerFallback {
    public static final AlternativeUiTextProvider.Message<Folder> NEW_PRONOUN = new AlternativeUiTextProvider.Message();
    private DescribableList<FolderProperty<?>, FolderPropertyDescriptor> properties;
    transient Map<String, TopLevelItem> items = new CopyOnWriteMap.Tree(CaseInsensitiveComparator.INSTANCE);
    private transient DescribableList<ListViewColumn, Descriptor<ListViewColumn>> columns;
    private transient DescribableList<ViewJobFilter, Descriptor<ViewJobFilter>> filters;
    private FolderIcon icon;
    private transient ItemGroupMixIn mixin;
    protected volatile transient List<Action> transientActions = new Vector<Action>();
    private CopyOnWriteArrayList<View> views;
    private volatile ViewsTabBar viewsTabBar;
    private volatile String primaryView;
    private transient ViewGroupMixIn viewGroupMixIn;
    private DescribableList<FolderHealthMetric, FolderHealthMetricDescriptor> healthMetrics;
    private static long loadingTick;
    private static final AtomicInteger jobTotal;
    private static final AtomicInteger jobEncountered;
    private static final AtomicBoolean loadJobTotalRan;
    private static final int TICK_INTERVAL = 15000;
    private static final Logger LOGGER;

    public Folder(ItemGroup parent, String name) {
        super(parent, name);
        this.init();
    }

    @Initializer(before=InitMilestone.JOB_LOADED, fatal=false)
    public static void loadJobTotal() {
        if (!loadJobTotalRan.compareAndSet(false, true)) {
            return;
        }
        Folder.scan(new File(Jenkins.getInstance().getRootDir(), "jobs"), 0);
    }

    private static void scan(File d, int depth) {
        File[] projects = d.listFiles();
        if (projects == null) {
            return;
        }
        for (File project : projects) {
            File jobs;
            if (!new File(project, "config.xml").isFile()) continue;
            if (depth > 0) {
                jobTotal.incrementAndGet();
            }
            if (!(jobs = new File(project, "jobs")).isDirectory()) continue;
            Folder.scan(jobs, depth + 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onLoad(ItemGroup<? extends Item> parent, String name) throws IOException {
        super.onLoad(parent, name);
        this.init();
        final Thread t = Thread.currentThread();
        String n = t.getName();
        try {
            Item current;
            if (this.items == null && (current = parent.getItem(name)) != null && current.getClass() == ((Object)((Object)this)).getClass()) {
                this.items = ((Folder)current).items;
            }
            this.items = ItemGroupMixIn.loadChildren((ItemGroup)this, (File)this.getJobsDir(), (Function1)new Function1<String, Item>(){

                public String call(Item item) {
                    String fullName = item.getFullName();
                    t.setName("Loading job " + fullName);
                    float percentage = 100.0f * (float)jobEncountered.incrementAndGet() / (float)Math.max(1, jobTotal.get());
                    long now = System.currentTimeMillis();
                    if (loadingTick == 0L) {
                        loadingTick = now;
                    } else if (now - loadingTick > 15000L) {
                        LOGGER.log(Level.INFO, String.format("Loading job %s (%.1f%%)", fullName, Float.valueOf(percentage)));
                        loadingTick = now;
                    }
                    return item.getName();
                }
            });
        }
        finally {
            t.setName(n);
        }
        this.updateTransientActions();
    }

    private void init() {
        if (this.icon == null) {
            this.icon = new StockFolderIcon();
        }
        if (this.properties == null) {
            this.properties = new DescribableList((Saveable)this);
        }
        for (FolderProperty p : this.properties) {
            p.setOwner(this);
        }
        if (this.columns == null) {
            this.columns = new DescribableList((Saveable)this, (Collection)ListViewColumn.createDefaultInitialColumnList());
        }
        if (this.filters == null) {
            this.filters = new DescribableList((Saveable)this);
        }
        if (this.views == null) {
            this.views = new CopyOnWriteArrayList();
        }
        if (this.views.size() == 0) {
            ListView lv = new ListView("All", (ViewGroup)this);
            this.views.add((View)lv);
            try {
                lv.getColumns().replaceBy((Collection)this.columns.toList());
                lv.getJobFilters().replaceBy((Collection)this.filters.toList());
                lv.setIncludeRegex(".*");
                lv.save();
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, "Failed to set up the initial view", e);
            }
        }
        if (this.viewsTabBar == null) {
            this.viewsTabBar = new DefaultViewsTabBar();
        }
        if (this.primaryView == null) {
            this.primaryView = this.views.get(0).getViewName();
        }
        this.mixin = new MixInImpl(this);
        this.viewGroupMixIn = new ViewGroupMixIn(this){

            protected List<View> views() {
                return Folder.this.views;
            }

            protected String primaryView() {
                return Folder.this.primaryView;
            }

            protected void primaryView(String name) {
                Folder.this.primaryView = name;
            }
        };
        if (this.healthMetrics == null) {
            ArrayList<FolderHealthMetric> metrics = new ArrayList<FolderHealthMetric>();
            for (FolderHealthMetricDescriptor d : FolderHealthMetricDescriptor.all()) {
                FolderHealthMetric metric = d.createDefault();
                if (metric == null) continue;
                metrics.add(metric);
            }
            this.healthMetrics = new DescribableList((Saveable)this, metrics);
        }
    }

    public void addView(View v) throws IOException {
        this.viewGroupMixIn.addView(v);
    }

    public boolean canDelete(View view) {
        return this.viewGroupMixIn.canDelete(view);
    }

    public void deleteView(View view) throws IOException {
        this.viewGroupMixIn.deleteView(view);
    }

    public View getView(String name) {
        return this.viewGroupMixIn.getView(name);
    }

    @Exported
    public Collection<View> getViews() {
        return this.viewGroupMixIn.getViews();
    }

    @Exported
    public View getPrimaryView() {
        return this.viewGroupMixIn.getPrimaryView();
    }

    public void setPrimaryView(View v) {
        this.primaryView = v.getViewName();
    }

    public void onViewRenamed(View view, String oldName, String newName) {
        this.viewGroupMixIn.onViewRenamed(view, oldName, newName);
    }

    public ViewsTabBar getViewsTabBar() {
        return this.viewsTabBar;
    }

    public ItemGroup<? extends TopLevelItem> getItemGroup() {
        return this;
    }

    public List<Action> getViewActions() {
        return Collections.emptyList();
    }

    public void onCreatedFromScratch() {
        this.updateTransientActions();
    }

    public String getPronoun() {
        return AlternativeUiTextProvider.get((AlternativeUiTextProvider.Message)PRONOUN, (Object)((Object)this), (String)this.getDescriptor().getDisplayName());
    }

    public synchronized List<Action> getActions() {
        Vector<Action> actions = new Vector<Action>(super.getActions());
        actions.addAll(this.transientActions);
        return Collections.unmodifiableList(actions);
    }

    protected void updateTransientActions() {
        this.transientActions = this.createTransientActions();
    }

    protected List<Action> createTransientActions() {
        Vector<Action> ta = new Vector<Action>();
        for (TransientFolderActionFactory tpaf : TransientFolderActionFactory.all()) {
            ta.addAll(Util.fixNull(tpaf.createFor(this)));
        }
        for (FolderProperty p : this.properties) {
            ta.addAll(Util.fixNull(p.getFolderActions()));
        }
        return ta;
    }

    public ACL getACL() {
        AuthorizationMatrixProperty p;
        AuthorizationStrategy as = Hudson.getInstance().getAuthorizationStrategy();
        if (as.getClass().getName().equals("hudson.security.ProjectMatrixAuthorizationStrategy") && (p = (AuthorizationMatrixProperty)this.getProperties().get(AuthorizationMatrixProperty.class)) != null) {
            return p.getACL().newInheritingACL(((ProjectMatrixAuthorizationStrategy)as).getACL(this.getParent()));
        }
        return super.getACL();
    }

    public String getNewPronoun() {
        return AlternativeUiTextProvider.get(NEW_PRONOUN, (Object)((Object)this), (String)Messages.Folder_DefaultPronoun());
    }

    public FolderIcon getIcon() {
        return this.icon;
    }

    public void setIcon(FolderIcon icon) {
        this.icon = icon;
        icon.setFolder(this);
    }

    public FolderIcon getIconColor() {
        return this.icon;
    }

    public Collection<? extends Job> getAllJobs() {
        HashSet jobs = new HashSet();
        for (Item item : this.getItems()) {
            jobs.addAll(item.getAllJobs());
        }
        return jobs;
    }

    public DescribableList<ListViewColumn, Descriptor<ListViewColumn>> getColumns() {
        return this.columns;
    }

    public void renameTo(String newName) throws IOException {
        super.renameTo(newName);
    }

    public DescribableList<FolderProperty<?>, FolderPropertyDescriptor> getProperties() {
        return this.properties;
    }

    public void addProperty(FolderProperty p) throws IOException {
        p.setOwner(this);
        this.properties.add((Object)p);
    }

    @Exported(name="jobs")
    public Collection<TopLevelItem> getItems() {
        ArrayList<TopLevelItem> viewableItems = new ArrayList<TopLevelItem>();
        for (TopLevelItem item : this.items.values()) {
            if (!item.hasPermission(Item.READ)) continue;
            viewableItems.add(item);
        }
        return viewableItems;
    }

    public String getUrlChildPrefix() {
        return "job";
    }

    public TopLevelItem getJob(String name) {
        return this.getItem(name);
    }

    public TopLevelItem getItem(String name) {
        if (this.items == null) {
            return null;
        }
        TopLevelItem item = this.items.get(name);
        if (item == null || !item.hasPermission(Item.READ)) {
            return null;
        }
        return item;
    }

    public File getRootDirFor(TopLevelItem child) {
        return this.getRootDirFor(child.getName());
    }

    private File getRootDirFor(String name) {
        return new File(this.getJobsDir(), name);
    }

    private File getJobsDir() {
        return new File(this.getRootDir(), "jobs");
    }

    public void onRenamed(TopLevelItem item, String oldName, String newName) throws IOException {
        this.items.remove(oldName);
        this.items.put(newName, item);
        for (View v : this.views) {
            v.onJobRenamed((Item)item, oldName, newName);
        }
        this.save();
    }

    protected void performDelete() throws IOException, InterruptedException {
        for (Item item : new ArrayList<TopLevelItem>(this.items.values())) {
            try {
                item.delete();
            }
            catch (AbortException e) {
                throw (AbortException)new AbortException("Failed to delete " + item.getFullDisplayName() + " : " + e.getMessage()).initCause((Throwable)e);
            }
            catch (IOException e) {
                throw new IOException2("Failed to delete " + item.getFullDisplayName(), (Throwable)e);
            }
        }
        super.performDelete();
    }

    public void onCopiedFrom(Item _src) {
        Folder src = (Folder)_src;
        for (TopLevelItem item : src.getItems()) {
            try {
                this.copy(item, item.getName());
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, "Failed to copy " + (Object)((Object)src) + " into " + (Object)((Object)this), e);
            }
        }
    }

    public void onDeleted(TopLevelItem item) throws IOException {
        ItemListener.fireOnDeleted((Item)item);
        this.items.remove(item.getName());
        for (View v : this.views) {
            v.onJobRenamed((Item)item, item.getName(), null);
        }
        this.save();
    }

    public TopLevelItem doCreateItem(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
        TopLevelItem nue = this.mixin.createTopLevelItem(req, rsp);
        if (!this.isAllowedChild(nue)) {
            try {
                nue.delete();
            }
            catch (InterruptedException x) {
                throw (IOException)new IOException(x.toString()).initCause(x);
            }
            throw new IOException("forbidden child type");
        }
        return nue;
    }

    public synchronized void doCreateView(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException, ParseException, Descriptor.FormException {
        this.checkPermission(View.CREATE);
        this.addView(View.create((StaplerRequest)req, (StaplerResponse)rsp, (ViewGroup)this));
    }

    public FormValidation doViewExistsCheck(@QueryParameter String value) {
        this.checkPermission(View.CREATE);
        String view = Util.fixEmpty((String)value);
        if (view == null) {
            return FormValidation.ok();
        }
        if (this.getView(view) == null) {
            return FormValidation.ok();
        }
        return FormValidation.error((String)jenkins.model.Messages.Hudson_ViewAlreadyExists((Object)view));
    }

    public FormValidation doCheckJobName(@QueryParameter String value) {
        this.checkPermission(Item.CREATE);
        if (Util.fixEmpty((String)value) == null) {
            return FormValidation.ok();
        }
        try {
            Hudson.checkGoodName((String)value);
            value = value.trim();
            if (this.getItem(value) != null) {
                throw new Failure(hudson.model.Messages.Hudson_JobAlreadyExists((Object)value));
            }
            return FormValidation.ok();
        }
        catch (Failure e) {
            return FormValidation.error((String)e.getMessage());
        }
    }

    public <T extends TopLevelItem> T copy(T src, String name) throws IOException {
        if (!this.isAllowedChild(src)) {
            throw new IOException("forbidden child type");
        }
        return (T)this.mixin.copy(src, name);
    }

    public TopLevelItem createProjectFromXML(String name, InputStream xml) throws IOException {
        TopLevelItem nue = this.mixin.createProjectFromXML(name, xml);
        if (!this.isAllowedChild(nue)) {
            try {
                nue.delete();
            }
            catch (InterruptedException x) {
                throw (IOException)new IOException(x.toString()).initCause(x);
            }
            throw new IOException("forbidden child type");
        }
        return nue;
    }

    public <T extends TopLevelItem> T createProject(Class<T> type, String name) throws IOException {
        return (T)((TopLevelItem)type.cast(this.createProject((TopLevelItemDescriptor)Hudson.getInstance().getDescriptor(type), name)));
    }

    public TopLevelItem createProject(TopLevelItemDescriptor type, String name) throws IOException {
        return this.createProject(type, name, true);
    }

    public TopLevelItem createProject(TopLevelItemDescriptor type, String name, boolean notify) throws IOException {
        if (!this.isAllowedChildDescriptor(type)) {
            throw new IOException("forbidden child type");
        }
        return this.mixin.createProject(type, name, notify);
    }

    public void doConfigSubmit(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException, Descriptor.FormException {
        this.checkPermission(CONFIGURE);
        req.setCharacterEncoding("UTF-8");
        JSONObject json = req.getSubmittedForm();
        this.description = json.getString("description");
        this.displayName = Util.fixEmpty((String)json.optString("displayNameOrNull"));
        this.properties.rebuild(req, json, this.getDescriptor().getPropertyDescriptors());
        for (FolderProperty p : this.properties) {
            p.setOwner(this);
        }
        this.healthMetrics.replaceBy((Collection)req.bindJSONToList(FolderHealthMetric.class, json.get("healthMetrics")));
        this.icon = (FolderIcon)((Object)req.bindJSON(FolderIcon.class, json.getJSONObject("icon")));
        this.icon.setFolder(this);
        this.updateTransientActions();
        this.save();
        String newName = json.getString("name");
        if (newName != null && !newName.equals(this.name)) {
            Hudson.checkGoodName((String)newName);
            rsp.sendRedirect("rename?newName=" + URLEncoder.encode(newName, "UTF-8"));
        } else {
            FormApply.success((String)".").generateResponse(req, rsp, (Object)this);
        }
    }

    public synchronized void doSubmitDescription(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
        this.getPrimaryView().doSubmitDescription(req, rsp);
    }

    @RequirePOST
    public void doDoRename(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
        if (!this.hasPermission(CONFIGURE)) {
            this.checkPermission(CREATE);
            this.checkPermission(DELETE);
        }
        String newName = req.getParameter("newName");
        Jenkins.checkGoodName((String)newName);
        this.renameTo(newName);
        rsp.sendRedirect2("../" + newName);
    }

    public Collection<?> getOverrides() {
        ArrayList r = new ArrayList();
        for (FolderProperty p : this.properties) {
            r.addAll(p.getItemContainerOverrides());
        }
        return r;
    }

    public List<TopLevelItemDescriptor> getItemDescriptors() {
        ArrayList<TopLevelItemDescriptor> r = new ArrayList<TopLevelItemDescriptor>();
        for (TopLevelItemDescriptor tid : Items.all()) {
            if (!this.isAllowedChildDescriptor(tid)) continue;
            r.add(tid);
        }
        return r;
    }

    public boolean isAllowedChildDescriptor(TopLevelItemDescriptor tid) {
        for (FolderProperty p : this.properties) {
            if (p.allowsParentToCreate(tid)) continue;
            return false;
        }
        return true;
    }

    public boolean isAllowedChild(TopLevelItem tid) {
        for (FolderProperty p : this.properties) {
            if (p.allowsParentToHave(tid)) continue;
            return false;
        }
        return true;
    }

    public View getStaplerFallback() {
        return this.getPrimaryView();
    }

    protected SearchIndexBuilder makeSearchIndex() {
        return super.makeSearchIndex().add((SearchIndex)new CollectionSearchIndex<TopLevelItem>(){

            protected SearchItem get(String key) {
                return Jenkins.getInstance().getItem(key, this.grp());
            }

            protected Collection<TopLevelItem> all() {
                return Items.getAllItems(this.grp(), TopLevelItem.class);
            }

            protected String getName(TopLevelItem j) {
                return j.getRelativeNameFrom(this.grp());
            }

            private ItemGroup<?> grp() {
                return Folder.this;
            }
        });
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)Hudson.getInstance().getDescriptorOrDie(((Object)((Object)this)).getClass());
    }

    public DescribableList<FolderHealthMetric, FolderHealthMetricDescriptor> getHealthMetrics() {
        return this.healthMetrics;
    }

    public HealthReport getBuildHealth() {
        List<HealthReport> reports = this.getBuildHealthReports();
        return reports.isEmpty() ? new HealthReport() : reports.get(0);
    }

    @Exported(name="healthReport")
    public List<HealthReport> getBuildHealthReports() {
        if (this.healthMetrics == null || this.healthMetrics.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<HealthReport> reports = new ArrayList<HealthReport>();
        ArrayList<FolderHealthMetric.Reporter> reporters = new ArrayList<FolderHealthMetric.Reporter>(this.healthMetrics.size());
        for (FolderHealthMetric metric : this.healthMetrics) {
            reporters.add(metric.reporter());
        }
        for (FolderProperty p : this.getProperties()) {
            for (FolderHealthMetric metric : p.getHealthMetrics()) {
                reporters.add(metric.reporter());
            }
        }
        Stack<Collection<TopLevelItem>> stack = new Stack<Collection<TopLevelItem>>();
        stack.push(this.getItems());
        while (!stack.isEmpty()) {
            for (Item item : (Iterable)stack.pop()) {
                for (FolderHealthMetric.Reporter reporter : reporters) {
                    reporter.observe(item);
                }
                if (!(item instanceof Folder)) continue;
                stack.push(((Folder)item).getItems());
            }
        }
        for (FolderHealthMetric.Reporter reporter : reporters) {
            reports.addAll(reporter.report());
        }
        for (FolderProperty p : this.getProperties()) {
            reports.addAll(p.getHealthReports());
        }
        Collections.sort(reports);
        return reports;
    }

    public HttpResponse doLastBuild(StaplerRequest req) {
        return HttpResponses.redirectToDot();
    }

    public boolean canAdd(TopLevelItem item) {
        return this.isAllowedChild(item);
    }

    public <I extends TopLevelItem> I add(I item, String name) throws IOException, IllegalArgumentException {
        if (!this.canAdd(item)) {
            throw new IllegalArgumentException();
        }
        if (this.items.containsKey(name)) {
            throw new IllegalArgumentException("already an item '" + name + "'");
        }
        this.items.put(item.getName(), item);
        return item;
    }

    public void remove(TopLevelItem item) throws IOException, IllegalArgumentException {
        this.items.remove(item.getName());
    }

    static {
        jobTotal = new AtomicInteger();
        jobEncountered = new AtomicInteger();
        loadJobTotalRan = new AtomicBoolean();
        LOGGER = Logger.getLogger(Folder.class.getName());
    }

    private class MixInImpl
    extends ItemGroupMixIn {
        private MixInImpl(Folder parent) {
            super((ItemGroup)parent, (AccessControlled)parent);
        }

        protected void add(TopLevelItem item) {
            Folder.this.items.put(item.getName(), item);
        }

        protected File getRootDirFor(String name) {
            return Folder.this.getRootDirFor(name);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension
    public static class DescriptorImpl
    extends TopLevelItemDescriptor {
        public String getDisplayName() {
            return Messages.Folder_DisplayName();
        }

        public TopLevelItem newInstance(ItemGroup parent, String name) {
            return new Folder(parent, name);
        }

        public List<FolderPropertyDescriptor> getPropertyDescriptors() {
            ArrayList<FolderPropertyDescriptor> r = new ArrayList<FolderPropertyDescriptor>();
            for (FolderPropertyDescriptor d : FolderPropertyDescriptor.all()) {
                if (!d.isApplicable(this.clazz)) continue;
                r.add(d);
            }
            return r;
        }

        public List<FolderHealthMetricDescriptor> getHealthMetricDescriptors() {
            ArrayList<FolderHealthMetricDescriptor> r = new ArrayList<FolderHealthMetricDescriptor>();
            for (FolderHealthMetricDescriptor d : FolderHealthMetricDescriptor.all()) {
                if (!d.isApplicable(this.clazz)) continue;
                r.add(d);
            }
            return r;
        }

        public AutoCompletionCandidates doAutoCompleteCopyNewItemFrom(final @AncestorInPath Folder f, final @QueryParameter String value) {
            final AutoCompletionCandidates r = new AutoCompletionCandidates();
            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            abstract class VisitorImpl
            extends ItemVisitor {
                final /* synthetic */ String val$value;
                final /* synthetic */ Folder val$f;
                final /* synthetic */ AutoCompletionCandidates val$r;

                VisitorImpl() {
                    this.val$value = string;
                    this.val$f = folder;
                    this.val$r = autoCompletionCandidates;
                }

                abstract String getPathNameOf(Item var1);

                public void onItemGroup(ItemGroup<?> group) {
                    super.onItemGroup(group);
                }

                public void onItem(Item i) {
                    TopLevelItem tli;
                    String name = this.getPathNameOf(i);
                    if (name.startsWith(this.val$value) && i instanceof TopLevelItem && this.val$f.isAllowedChild(tli = (TopLevelItem)i)) {
                        this.val$r.add(name);
                    }
                    if (this.val$value.startsWith(name)) {
                        super.onItem(i);
                    }
                }
            }
            new VisitorImpl(){
                {
                    super(DescriptorImpl.this, string, folder, autoCompletionCandidates);
                }

                String getPathNameOf(Item i) {
                    return '/' + i.getFullName();
                }
            }.walk();
            new VisitorImpl(){
                String baseName;
                {
                    super(DescriptorImpl.this, string, folder, autoCompletionCandidates);
                    this.baseName = f.getFullName();
                }

                String getPathNameOf(Item i) {
                    return i.getFullName().substring(this.baseName.length() + 1);
                }
            }.onItemGroup((ItemGroup<?>)f);
            return r;
        }
    }
}

