/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.hudson.plugins.folder.relocate;

import com.cloudbees.hudson.plugins.folder.relocate.RelocationAction;
import com.cloudbees.hudson.plugins.folder.relocate.RelocationHandler;
import com.cloudbees.hudson.plugins.folder.relocate.RelocationUI;
import hudson.Extension;
import hudson.model.Failure;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.util.HttpResponses;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.concurrent.atomic.AtomicReference;
import jenkins.model.Jenkins;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.interceptor.RequirePOST;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Extension(ordinal=-1000.0)
public class DefaultRelocationUI
extends RelocationUI {
    @Override
    public boolean isApplicableTo(Class<? extends Item> itemClass) {
        return true;
    }

    @Override
    public boolean isAvailable(Item item) {
        for (RelocationHandler handler : Jenkins.getInstance().getExtensionList(RelocationHandler.class)) {
            if (handler.applicability(item) != RelocationHandler.HandlingMode.HANDLE) continue;
            return true;
        }
        return false;
    }

    public Collection<ItemGroup<?>> listDestinations(Item item) {
        LinkedHashSet result = new LinkedHashSet();
        for (RelocationHandler handler : Jenkins.getInstance().getExtensionList(RelocationHandler.class)) {
            if (handler.applicability(item) != RelocationHandler.HandlingMode.HANDLE) continue;
            result.addAll(handler.validDestinations(item));
        }
        return result;
    }

    @RequirePOST
    public HttpResponse doMove(StaplerRequest req, @AncestorInPath Item item, @QueryParameter String destination) throws IOException, InterruptedException {
        item.checkPermission(RelocationAction.RELOCATE);
        ItemGroup<?> dest = null;
        for (ItemGroup<?> itemGroup : this.listDestinations(item)) {
            if (!("/" + itemGroup.getFullName()).equals(destination)) continue;
            dest = itemGroup;
            break;
        }
        if (dest == null || dest == item.getParent()) {
            return HttpResponses.forwardToPreviousPage();
        }
        ArrayList<RelocationHandler> chain = new ArrayList<RelocationHandler>();
        for (RelocationHandler handler : Jenkins.getInstance().getExtensionList(RelocationHandler.class)) {
            if (handler.applicability(item) == RelocationHandler.HandlingMode.SKIP) continue;
            chain.add(handler);
        }
        if (chain.isEmpty()) {
            return new Failure("no known way to handle " + item);
        }
        HttpResponse response = ((RelocationHandler)chain.get(0)).handle(item, dest, new AtomicReference<Item>(), chain.subList(1, chain.size()));
        if (response != null) {
            return response;
        }
        return HttpResponses.forwardToPreviousPage();
    }
}

