/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.plugins.bitbucket.server.client.branch;

import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketCommit;
import com.cloudbees.jenkins.plugins.bitbucket.server.client.branch.BitbucketServerAuthor;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.util.StdDateFormat;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.text.MessageFormat;
import java.util.Date;

public class BitbucketServerCommit
implements BitbucketCommit {
    private static final String GIT_COMMIT_AUTHOR = "{0} <{1}>";
    private String message;
    private String date;
    private String hash;
    private long dateMillis;
    private String author;

    @JsonCreator
    public BitbucketServerCommit(@JsonProperty(value="message") @NonNull String message, @JsonProperty(value="id") @NonNull String hash, @JsonProperty(value="authorTimestamp") @NonNull long dateMillis, @JsonProperty(value="author") @Nullable BitbucketServerAuthor author) {
        this(message, hash, dateMillis, author != null ? MessageFormat.format(GIT_COMMIT_AUTHOR, author.getName(), author.getEmail()) : null);
    }

    public BitbucketServerCommit(String message, String hash, long dateMillis, String author) {
        this.message = message;
        this.hash = hash;
        this.dateMillis = dateMillis;
        this.date = new StdDateFormat().format(new Date(dateMillis));
        this.author = author;
    }

    public BitbucketServerCommit(String hash) {
        this.hash = hash;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public String getDate() {
        return this.date;
    }

    @Override
    public String getHash() {
        return this.hash;
    }

    @Override
    public long getDateMillis() {
        return this.dateMillis;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void setDate(String date) {
        this.date = date;
    }

    public void setHash(String hash) {
        this.hash = hash;
    }

    public void setDateMillis(long dateMillis) {
        this.dateMillis = dateMillis;
    }

    @Override
    public String getAuthor() {
        return this.author;
    }

    public void setAuthor(String author) {
        this.author = author;
    }
}

