/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.plugins.bitbucket.hooks;

import com.cloudbees.jenkins.plugins.bitbucket.BitbucketSCMSource;
import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketWebHook;
import com.cloudbees.jenkins.plugins.bitbucket.client.repository.BitbucketRepositoryHook;
import com.cloudbees.jenkins.plugins.bitbucket.endpoints.AbstractBitbucketEndpoint;
import com.cloudbees.jenkins.plugins.bitbucket.endpoints.BitbucketEndpointConfiguration;
import com.cloudbees.jenkins.plugins.bitbucket.endpoints.BitbucketServerEndpoint;
import com.cloudbees.jenkins.plugins.bitbucket.hooks.HookEventType;
import com.cloudbees.jenkins.plugins.bitbucket.server.client.repository.BitbucketServerWebhook;
import com.cloudbees.jenkins.plugins.bitbucket.server.client.repository.NativeBitbucketServerWebhook;
import com.damnhandy.uri.template.UriTemplate;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.TreeSet;

public class WebhookConfiguration {
    private static final List<String> CLOUD_EVENTS = Collections.unmodifiableList(Arrays.asList(HookEventType.PUSH.getKey(), HookEventType.PULL_REQUEST_CREATED.getKey(), HookEventType.PULL_REQUEST_UPDATED.getKey(), HookEventType.PULL_REQUEST_MERGED.getKey(), HookEventType.PULL_REQUEST_DECLINED.getKey()));
    private static final List<String> NATIVE_SERVER_EVENTS_v7 = Collections.unmodifiableList(Arrays.asList(HookEventType.SERVER_REFS_CHANGED.getKey(), HookEventType.SERVER_PULL_REQUEST_OPENED.getKey(), HookEventType.SERVER_PULL_REQUEST_MERGED.getKey(), HookEventType.SERVER_PULL_REQUEST_DECLINED.getKey(), HookEventType.SERVER_PULL_REQUEST_DELETED.getKey(), HookEventType.SERVER_PULL_REQUEST_MODIFIED.getKey(), HookEventType.SERVER_PULL_REQUEST_REVIEWER_UPDATED.getKey(), HookEventType.SERVER_PULL_REQUEST_FROM_REF_UPDATED.getKey()));
    private static final List<String> NATIVE_SERVER_EVENTS_v6 = Collections.unmodifiableList(NATIVE_SERVER_EVENTS_v7.subList(0, 7));
    private static final List<String> NATIVE_SERVER_EVENTS_v5 = Collections.unmodifiableList(NATIVE_SERVER_EVENTS_v7.subList(0, 5));
    private static final String description = "Jenkins hook";
    private final String committersToIgnore;

    public WebhookConfiguration() {
        this.committersToIgnore = null;
    }

    public WebhookConfiguration(@CheckForNull String committersToIgnore) {
        this.committersToIgnore = committersToIgnore;
    }

    public String getCommittersToIgnore() {
        return this.committersToIgnore;
    }

    boolean updateHook(BitbucketWebHook hook, BitbucketSCMSource owner) {
        if (hook instanceof BitbucketRepositoryHook) {
            if (!hook.getEvents().containsAll(CLOUD_EVENTS)) {
                TreeSet<String> events = new TreeSet<String>(hook.getEvents());
                events.addAll(CLOUD_EVENTS);
                BitbucketRepositoryHook repoHook = (BitbucketRepositoryHook)hook;
                repoHook.setEvents(new ArrayList<String>(events));
                return true;
            }
            return false;
        }
        if (hook instanceof BitbucketServerWebhook) {
            String thisCommittersToIgnore;
            BitbucketServerWebhook serverHook = (BitbucketServerWebhook)hook;
            String hookCommittersToIgnore = ((BitbucketServerWebhook)hook).getCommittersToIgnore();
            if (hookCommittersToIgnore == null) {
                hookCommittersToIgnore = "";
            }
            if ((thisCommittersToIgnore = this.committersToIgnore) == null) {
                thisCommittersToIgnore = "";
            }
            if (!hookCommittersToIgnore.trim().equals(thisCommittersToIgnore.trim())) {
                serverHook.setCommittersToIgnore(this.committersToIgnore);
                return true;
            }
            return false;
        }
        if (hook instanceof NativeBitbucketServerWebhook) {
            List<String> events;
            boolean updated = false;
            NativeBitbucketServerWebhook serverHook = (NativeBitbucketServerWebhook)hook;
            String serverUrl = owner.getServerUrl();
            String url = WebhookConfiguration.getNativeServerWebhookUrl(serverUrl, owner.getEndpointJenkinsRootUrl());
            if (!url.equals(serverHook.getUrl())) {
                serverHook.setUrl(url);
                updated = true;
            }
            if ((events = serverHook.getEvents()) == null) {
                serverHook.setEvents(WebhookConfiguration.getNativeServerEvents(serverUrl));
                updated = true;
            } else if (!events.containsAll(WebhookConfiguration.getNativeServerEvents(serverUrl))) {
                TreeSet<String> newEvents = new TreeSet<String>(events);
                newEvents.addAll(WebhookConfiguration.getNativeServerEvents(serverUrl));
                serverHook.setEvents(new ArrayList<String>(newEvents));
                updated = true;
            }
            return updated;
        }
        return false;
    }

    public BitbucketWebHook getHook(BitbucketSCMSource owner) {
        String serverUrl = owner.getServerUrl();
        String rootUrl = owner.getEndpointJenkinsRootUrl();
        if ("https://bitbucket.org".equals(serverUrl)) {
            BitbucketRepositoryHook hook = new BitbucketRepositoryHook();
            hook.setEvents(CLOUD_EVENTS);
            hook.setActive(true);
            hook.setDescription(description);
            hook.setUrl(rootUrl + "bitbucket-scmsource-hook/notify");
            return hook;
        }
        switch (BitbucketServerEndpoint.findWebhookImplementation(serverUrl)) {
            case NATIVE: {
                NativeBitbucketServerWebhook hook = new NativeBitbucketServerWebhook();
                hook.setActive(true);
                hook.setEvents(WebhookConfiguration.getNativeServerEvents(serverUrl));
                hook.setDescription(description);
                hook.setUrl(WebhookConfiguration.getNativeServerWebhookUrl(serverUrl, rootUrl));
                return hook;
            }
        }
        BitbucketServerWebhook hook = new BitbucketServerWebhook();
        hook.setActive(true);
        hook.setDescription(description);
        hook.setUrl(rootUrl + "bitbucket-scmsource-hook/notify");
        hook.setCommittersToIgnore(this.committersToIgnore);
        return hook;
    }

    private static List<String> getNativeServerEvents(String serverUrl) {
        AbstractBitbucketEndpoint endpoint = BitbucketEndpointConfiguration.get().findEndpoint(serverUrl);
        if (endpoint instanceof BitbucketServerEndpoint) {
            switch (((BitbucketServerEndpoint)endpoint).getServerVersion()) {
                case VERSION_5: {
                    return NATIVE_SERVER_EVENTS_v5;
                }
                case VERSION_5_10: {
                    return NATIVE_SERVER_EVENTS_v6;
                }
                case VERSION_6: {
                    return NATIVE_SERVER_EVENTS_v6;
                }
            }
            return NATIVE_SERVER_EVENTS_v7;
        }
        return NATIVE_SERVER_EVENTS_v7;
    }

    private static String getNativeServerWebhookUrl(String serverUrl, String rootUrl) {
        return UriTemplate.buildFromTemplate((String)rootUrl).template(new String[]{"bitbucket-scmsource-hook/notify"}).query(new String[]{"server_url"}).build().set("server_url", (Object)serverUrl).expand();
    }
}

