/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.plugins.bitbucket.hooks;

import com.cloudbees.jenkins.plugins.bitbucket.BitbucketSCMNavigator;
import com.cloudbees.jenkins.plugins.bitbucket.BitbucketSCMSource;
import com.cloudbees.jenkins.plugins.bitbucket.BitbucketSCMSourceContext;
import com.cloudbees.jenkins.plugins.bitbucket.PullRequestSCMHead;
import com.cloudbees.jenkins.plugins.bitbucket.PullRequestSCMRevision;
import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketHref;
import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketPullRequest;
import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketPullRequestEvent;
import com.cloudbees.jenkins.plugins.bitbucket.client.BitbucketCloudWebhookPayload;
import com.cloudbees.jenkins.plugins.bitbucket.client.events.BitbucketCloudPullRequestEvent;
import com.cloudbees.jenkins.plugins.bitbucket.hooks.BitbucketType;
import com.cloudbees.jenkins.plugins.bitbucket.hooks.HasPullRequests;
import com.cloudbees.jenkins.plugins.bitbucket.hooks.HookEventType;
import com.cloudbees.jenkins.plugins.bitbucket.hooks.HookProcessor;
import com.cloudbees.jenkins.plugins.bitbucket.server.client.BitbucketServerWebhookPayload;
import com.cloudbees.jenkins.plugins.bitbucket.server.events.BitbucketServerPullRequestEvent;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.scm.SCM;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import jenkins.plugins.git.AbstractGitSCMSource;
import jenkins.scm.api.SCMEvent;
import jenkins.scm.api.SCMHead;
import jenkins.scm.api.SCMHeadEvent;
import jenkins.scm.api.SCMHeadObserver;
import jenkins.scm.api.SCMHeadOrigin;
import jenkins.scm.api.SCMNavigator;
import jenkins.scm.api.SCMRevision;
import jenkins.scm.api.SCMSource;
import jenkins.scm.api.mixin.ChangeRequestCheckoutStrategy;
import org.apache.commons.lang.StringUtils;

public class PullRequestHookProcessor
extends HookProcessor {
    private static final Logger LOGGER = Logger.getLogger(PullRequestHookProcessor.class.getName());

    @Override
    public void process(HookEventType hookEvent, String payload, BitbucketType instanceType, String origin) {
        BitbucketPullRequestEvent pull;
        if (payload != null && (pull = instanceType == BitbucketType.SERVER ? BitbucketServerWebhookPayload.pullRequestEventFromPayload(payload) : BitbucketCloudWebhookPayload.pullRequestEventFromPayload(payload)) != null) {
            SCMEvent.Type eventType;
            switch (hookEvent) {
                case PULL_REQUEST_CREATED: {
                    eventType = SCMEvent.Type.CREATED;
                    break;
                }
                case PULL_REQUEST_DECLINED: 
                case PULL_REQUEST_MERGED: {
                    eventType = SCMEvent.Type.REMOVED;
                    break;
                }
                default: {
                    eventType = SCMEvent.Type.UPDATED;
                }
            }
            SCMHeadEvent.fireLater((SCMHeadEvent)new HeadEvent(eventType, pull, origin, hookEvent, instanceType), (long)BitbucketSCMSource.getEventDelaySeconds(), (TimeUnit)TimeUnit.SECONDS);
        }
    }

    private static final class HeadEvent
    extends SCMHeadEvent<BitbucketPullRequestEvent>
    implements HasPullRequests {
        private final HookEventType hookEvent;
        private final BitbucketType instanceType;

        private HeadEvent(SCMEvent.Type type, BitbucketPullRequestEvent payload, String origin, HookEventType hookEvent, BitbucketType instanceType) {
            super(type, (Object)payload, origin);
            this.hookEvent = hookEvent;
            this.instanceType = instanceType;
        }

        public boolean isMatch(@NonNull SCMNavigator navigator) {
            if (!(navigator instanceof BitbucketSCMNavigator)) {
                return false;
            }
            BitbucketSCMNavigator bbNav = (BitbucketSCMNavigator)navigator;
            if (!this.isProjectKeyMatch(bbNav.getProjectKey())) {
                return false;
            }
            if (!this.isServerUrlMatch(bbNav.getServerUrl())) {
                return false;
            }
            return bbNav.getRepoOwner().equalsIgnoreCase(((BitbucketPullRequestEvent)this.getPayload()).getRepository().getOwnerName());
        }

        private boolean isProjectKeyMatch(String projectKey) {
            if (StringUtils.isBlank((String)projectKey)) {
                return true;
            }
            if (((BitbucketPullRequestEvent)this.getPayload()).getRepository().getProject() != null) {
                return projectKey.equals(((BitbucketPullRequestEvent)this.getPayload()).getRepository().getProject().getKey());
            }
            return true;
        }

        private boolean isServerUrlMatch(String serverUrl) {
            if (serverUrl == null || "https://bitbucket.org".equals(serverUrl)) {
                if (this.getPayload() instanceof BitbucketServerPullRequestEvent) {
                    return false;
                }
            } else {
                if (this.getPayload() instanceof BitbucketCloudPullRequestEvent) {
                    return false;
                }
                Map<String, List<BitbucketHref>> links = ((BitbucketPullRequestEvent)this.getPayload()).getRepository().getLinks();
                if (links != null && links.containsKey("self")) {
                    boolean matches = false;
                    for (BitbucketHref link : links.get("self")) {
                        try {
                            URI navUri = new URI(serverUrl);
                            URI evtUri = new URI(link.getHref());
                            if (!navUri.getHost().equalsIgnoreCase(evtUri.getHost())) continue;
                            matches = true;
                            break;
                        }
                        catch (URISyntaxException uRISyntaxException) {
                        }
                    }
                    return matches;
                }
            }
            return true;
        }

        @NonNull
        public String getSourceName() {
            return ((BitbucketPullRequestEvent)this.getPayload()).getRepository().getRepositoryName();
        }

        @NonNull
        @SuppressFBWarnings(value={"SBSC_USE_STRINGBUFFER_CONCATENATION"}, justification="TODO needs triage")
        public Map<SCMHead, SCMRevision> heads(@NonNull SCMSource source) {
            String pullRepository;
            if (!(source instanceof BitbucketSCMSource)) {
                return Collections.emptyMap();
            }
            BitbucketSCMSource src = (BitbucketSCMSource)source;
            if (!this.isServerUrlMatch(src.getServerUrl())) {
                return Collections.emptyMap();
            }
            if (!src.getRepoOwner().equalsIgnoreCase(((BitbucketPullRequestEvent)this.getPayload()).getRepository().getOwnerName())) {
                return Collections.emptyMap();
            }
            if (!src.getRepository().equalsIgnoreCase(((BitbucketPullRequestEvent)this.getPayload()).getRepository().getRepositoryName())) {
                return Collections.emptyMap();
            }
            BitbucketSCMSourceContext ctx = (BitbucketSCMSourceContext)new BitbucketSCMSourceContext(null, (SCMHeadObserver)SCMHeadObserver.none()).withTraits(src.getTraits());
            if (!ctx.wantPRs()) {
                return Collections.emptyMap();
            }
            BitbucketPullRequest pull = ((BitbucketPullRequestEvent)this.getPayload()).getPullRequest();
            String pullRepoOwner = pull.getSource().getRepository().getOwnerName();
            SCMHeadOrigin headOrigin = src.originOf(pullRepoOwner, pullRepository = pull.getSource().getRepository().getRepositoryName());
            Set<ChangeRequestCheckoutStrategy> strategies = headOrigin == SCMHeadOrigin.DEFAULT ? ctx.originPRStrategies() : ctx.forkPRStrategies();
            HashMap<SCMHead, SCMRevision> result = new HashMap<SCMHead, SCMRevision>(strategies.size());
            for (ChangeRequestCheckoutStrategy strategy : strategies) {
                String branchName = "PR-" + pull.getId();
                if (strategies.size() > 1) {
                    branchName = branchName + "-" + strategy.name().toLowerCase(Locale.ENGLISH);
                }
                String originalBranchName = pull.getSource().getBranch().getName();
                PullRequestSCMHead head = this.instanceType == BitbucketType.CLOUD ? new PullRequestSCMHead(branchName, pullRepoOwner, pullRepository, originalBranchName, pull, headOrigin, strategy) : new PullRequestSCMHead(branchName, src.getRepoOwner(), src.getRepository(), originalBranchName, pull, headOrigin, strategy);
                if (this.hookEvent == HookEventType.PULL_REQUEST_DECLINED || this.hookEvent == HookEventType.PULL_REQUEST_MERGED) {
                    result.put(head, null);
                    continue;
                }
                String targetHash = pull.getDestination().getCommit().getHash();
                String pullHash = pull.getSource().getCommit().getHash();
                PullRequestSCMRevision<AbstractGitSCMSource.SCMRevisionImpl> revision = new PullRequestSCMRevision<AbstractGitSCMSource.SCMRevisionImpl>(head, new AbstractGitSCMSource.SCMRevisionImpl(head.getTarget(), targetHash), new AbstractGitSCMSource.SCMRevisionImpl((SCMHead)head, pullHash));
                result.put(head, (SCMRevision)revision);
            }
            return result;
        }

        public boolean isMatch(@NonNull SCM scm) {
            return false;
        }

        @Override
        public Iterable<BitbucketPullRequest> getPullRequests(BitbucketSCMSource src) throws InterruptedException {
            if (this.hookEvent == HookEventType.PULL_REQUEST_DECLINED || this.hookEvent == HookEventType.PULL_REQUEST_MERGED) {
                return Collections.emptyList();
            }
            return Collections.singleton(((BitbucketPullRequestEvent)this.getPayload()).getPullRequest());
        }
    }
}

