/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.plugins.bitbucket.client.branch;

import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketCommit;
import com.cloudbees.jenkins.plugins.bitbucket.client.branch.BitbucketCloudAuthor;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.util.StdDateFormat;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.text.ParseException;

public class BitbucketCloudCommit
implements BitbucketCommit {
    private String message;
    private String date;
    private transient long dateInMillis;
    private String hash;
    private String author;

    @JsonCreator
    public BitbucketCloudCommit(@JsonProperty(value="message") @Nullable String message, @JsonProperty(value="date") @Nullable String date, @JsonProperty(value="hash") @NonNull String hash, @JsonProperty(value="author") @Nullable BitbucketCloudAuthor author) {
        this.message = message;
        this.date = date;
        this.hash = hash;
        if (author != null) {
            this.author = author.getRaw();
        }
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public String getDate() {
        return this.date;
    }

    @Override
    public String getHash() {
        return this.hash;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void setDate(String date) {
        this.date = date;
        this.dateInMillis = 0L;
    }

    public void setHash(String hash) {
        this.hash = hash;
    }

    @Override
    public long getDateMillis() {
        try {
            if (this.dateInMillis == 0L && this.date != null) {
                this.dateInMillis = new StdDateFormat().parse(this.date).getTime();
            }
        }
        catch (ParseException e) {
            this.dateInMillis = 0L;
        }
        return this.dateInMillis;
    }

    @Override
    public String getAuthor() {
        return this.author;
    }

    public void setAuthor(String author) {
        this.author = author;
    }
}

