/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.plugins.bitbucket.api;

import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketHref;
import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketWorkspace;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.List;
import java.util.Map;

public class BitbucketCloudWorkspace
implements BitbucketWorkspace {
    @JsonProperty(value="uuid")
    private String uuid;
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="slug")
    private String slug;
    @JsonProperty(value="is_private")
    private boolean isPrivate;
    @JsonProperty(value="links")
    @JsonDeserialize(keyAs=String.class, contentUsing=BitbucketHref.Deserializer.class)
    private Map<String, List<BitbucketHref>> links;

    @Override
    public String getUuid() {
        return this.uuid;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDisplayName() {
        return this.name;
    }

    @Override
    public String getSlug() {
        return this.slug;
    }

    @Override
    public boolean isPrivate() {
        return this.isPrivate;
    }

    @Override
    public Map<String, List<BitbucketHref>> getLinks() {
        return this.links;
    }

    @Override
    public String getLink(String name) {
        if (this.links == null) {
            return null;
        }
        List<BitbucketHref> hrefs = this.links.get(name);
        if (hrefs == null || hrefs.isEmpty()) {
            return null;
        }
        BitbucketHref href = hrefs.get(0);
        return href == null ? null : href.getHref();
    }
}

