/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.plugins.bitbucket.server.client.repository;

import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketHref;
import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketProject;
import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketRepository;
import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketRepositoryOwner;
import com.cloudbees.jenkins.plugins.bitbucket.server.client.repository.BitbucketServerRepositoryOwner;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BitbucketServerRepository
implements BitbucketRepository {
    private Long id;
    @Deprecated
    @JsonProperty(value="scmId")
    private String scm;
    private BitbucketProject project;
    @JsonProperty(value="slug")
    private String repositoryName;
    private Boolean public_;
    @JsonProperty
    @JsonDeserialize(keyAs=String.class, contentUsing=BitbucketHref.Deserializer.class)
    private Map<String, List<BitbucketHref>> links;

    public Long getId() {
        return this.id;
    }

    @Override
    public String getScm() {
        return this.scm;
    }

    @Override
    public String getFullName() {
        return this.project.getKey() + "/" + this.repositoryName;
    }

    @Override
    public BitbucketRepositoryOwner getOwner() {
        return new BitbucketServerRepositoryOwner(this.project.getKey(), this.project.getName());
    }

    @Override
    public String getOwnerName() {
        return this.project.getKey();
    }

    @Override
    public String getRepositoryName() {
        return this.repositoryName;
    }

    @Override
    public BitbucketProject getProject() {
        return this.project;
    }

    public void setProject(BitbucketProject project) {
        this.project = project;
    }

    @Override
    public boolean isPrivate() {
        return this.public_ == false;
    }

    @JsonProperty(value="public")
    public void setPublic(Boolean public_) {
        this.public_ = public_;
    }

    @Override
    @JsonIgnore
    public Map<String, List<BitbucketHref>> getLinks() {
        if (this.links == null) {
            return null;
        }
        HashMap<String, List<BitbucketHref>> result = new HashMap<String, List<BitbucketHref>>();
        for (Map.Entry<String, List<BitbucketHref>> entry : this.links.entrySet()) {
            if (entry.getValue().isEmpty()) continue;
            result.put(entry.getKey(), new ArrayList(entry.getValue()));
        }
        return result;
    }

    @JsonIgnore
    public void setLinks(Map<String, List<BitbucketHref>> links) {
        if (links == null) {
            this.links = null;
        } else {
            this.links = new HashMap<String, List<BitbucketHref>>();
            for (Map.Entry<String, List<BitbucketHref>> entry : links.entrySet()) {
                this.links.put(entry.getKey(), new ArrayList(entry.getValue()));
            }
        }
    }
}

