/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.plugins.bitbucket.server.client;

import com.cloudbees.jenkins.plugins.bitbucket.JsonParser;
import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketApi;
import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketAuthenticator;
import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketBuildStatus;
import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketCommit;
import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketPullRequest;
import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketRepository;
import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketRepositoryProtocol;
import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketRequestException;
import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketTeam;
import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketWebHook;
import com.cloudbees.jenkins.plugins.bitbucket.api.credentials.BitbucketUsernamePasswordAuthenticator;
import com.cloudbees.jenkins.plugins.bitbucket.avatars.AvatarCacheSource;
import com.cloudbees.jenkins.plugins.bitbucket.client.repository.UserRoleInRepository;
import com.cloudbees.jenkins.plugins.bitbucket.endpoints.BitbucketEndpointConfiguration;
import com.cloudbees.jenkins.plugins.bitbucket.endpoints.BitbucketServerEndpoint;
import com.cloudbees.jenkins.plugins.bitbucket.filesystem.BitbucketSCMFile;
import com.cloudbees.jenkins.plugins.bitbucket.server.BitbucketServerVersion;
import com.cloudbees.jenkins.plugins.bitbucket.server.BitbucketServerWebhookImplementation;
import com.cloudbees.jenkins.plugins.bitbucket.server.client.PagedApiResponse;
import com.cloudbees.jenkins.plugins.bitbucket.server.client.branch.BitbucketServerBranch;
import com.cloudbees.jenkins.plugins.bitbucket.server.client.branch.BitbucketServerBranches;
import com.cloudbees.jenkins.plugins.bitbucket.server.client.branch.BitbucketServerCommit;
import com.cloudbees.jenkins.plugins.bitbucket.server.client.pullrequest.BitbucketServerPullRequest;
import com.cloudbees.jenkins.plugins.bitbucket.server.client.pullrequest.BitbucketServerPullRequestCanMerge;
import com.cloudbees.jenkins.plugins.bitbucket.server.client.pullrequest.BitbucketServerPullRequests;
import com.cloudbees.jenkins.plugins.bitbucket.server.client.repository.BitbucketServerProject;
import com.cloudbees.jenkins.plugins.bitbucket.server.client.repository.BitbucketServerRepositories;
import com.cloudbees.jenkins.plugins.bitbucket.server.client.repository.BitbucketServerRepository;
import com.cloudbees.jenkins.plugins.bitbucket.server.client.repository.BitbucketServerWebhooks;
import com.cloudbees.jenkins.plugins.bitbucket.server.client.repository.NativeBitbucketServerWebhooks;
import com.cloudbees.plugins.credentials.common.StandardUsernamePasswordCredentials;
import com.damnhandy.uri.template.UriTemplate;
import com.damnhandy.uri.template.impl.Operator;
import com.fasterxml.jackson.core.type.TypeReference;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.ProxyConfiguration;
import hudson.Util;
import java.awt.image.BufferedImage;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import jenkins.scm.api.SCMFile;
import net.sf.json.JSONObject;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.NameValuePair;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.AuthCache;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.BasicAuthCache;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.StandardHttpRequestRetryHandler;
import org.apache.http.message.BasicNameValuePair;

public class BitbucketServerAPIClient
implements BitbucketApi {
    private static final int MAX_AVATAR_SIZE = 16384;
    private static final Logger LOGGER = Logger.getLogger(BitbucketServerAPIClient.class.getName());
    private static final String API_BASE_PATH = "/rest/api/1.0";
    private static final String API_REPOSITORIES_PATH = "/rest/api/1.0/projects/{owner}/repos{?start,limit}";
    private static final String API_REPOSITORY_PATH = "/rest/api/1.0/projects/{owner}/repos/{repo}";
    private static final String API_DEFAULT_BRANCH_PATH = "/rest/api/1.0/projects/{owner}/repos/{repo}/branches/default";
    private static final String API_BRANCHES_PATH = "/rest/api/1.0/projects/{owner}/repos/{repo}/branches{?start,limit,filterText}";
    private static final String API_TAGS_PATH = "/rest/api/1.0/projects/{owner}/repos/{repo}/tags{?start,limit,filterText}";
    private static final String API_PULL_REQUESTS_PATH = "/rest/api/1.0/projects/{owner}/repos/{repo}/pull-requests{?start,limit,at,direction,state}";
    private static final String API_PULL_REQUEST_PATH = "/rest/api/1.0/projects/{owner}/repos/{repo}/pull-requests/{id}";
    private static final String API_PULL_REQUEST_MERGE_PATH = "/rest/api/1.0/projects/{owner}/repos/{repo}/pull-requests/{id}/merge";
    private static final String API_PULL_REQUEST_CHANGES_PATH = "/rest/api/1.0/projects/{owner}/repos/{repo}/pull-requests/{id}/changes{?start,limit}";
    static final String API_BROWSE_PATH = "/rest/api/1.0/projects/{owner}/repos/{repo}/browse{/path*}{?at}";
    private static final String API_COMMITS_PATH = "/rest/api/1.0/projects/{owner}/repos/{repo}/commits{/hash}";
    private static final String API_PROJECT_PATH = "/rest/api/1.0/projects/{owner}";
    private static final String AVATAR_PATH = "/rest/api/1.0/projects/{owner}/avatar.png";
    private static final String API_COMMIT_COMMENT_PATH = "/rest/api/1.0/projects/{owner}/repos/{repo}/commits{/hash}/comments";
    private static final String API_WEBHOOKS_PATH = "/rest/api/1.0/projects/{owner}/repos/{repo}/webhooks{/id}{?start,limit}";
    private static final String WEBHOOK_BASE_PATH = "/rest/webhook/1.0";
    private static final String WEBHOOK_REPOSITORY_PATH = "/rest/webhook/1.0/projects/{owner}/repos/{repo}/configurations";
    private static final String WEBHOOK_REPOSITORY_CONFIG_PATH = "/rest/webhook/1.0/projects/{owner}/repos/{repo}/configurations/{id}";
    private static final String API_COMMIT_STATUS_PATH = "/rest/build-status/1.0/commits{/hash}";
    private static final Integer DEFAULT_PAGE_LIMIT = 200;
    private final String owner;
    private final String repositoryName;
    private final boolean userCentric;
    private final BitbucketAuthenticator authenticator;
    private HttpClientContext context;
    private final String baseURL;
    private final BitbucketServerWebhookImplementation webhookImplementation;

    @Deprecated
    public BitbucketServerAPIClient(@NonNull String baseURL, @NonNull String owner, @CheckForNull String repositoryName, @CheckForNull StandardUsernamePasswordCredentials credentials, boolean userCentric) {
        this(baseURL, owner, repositoryName, credentials != null ? new BitbucketUsernamePasswordAuthenticator(credentials) : null, userCentric, BitbucketServerEndpoint.findWebhookImplementation(baseURL));
    }

    public BitbucketServerAPIClient(@NonNull String baseURL, @NonNull String owner, @CheckForNull String repositoryName, @CheckForNull BitbucketAuthenticator authenticator, boolean userCentric) {
        this(baseURL, owner, repositoryName, authenticator, userCentric, BitbucketServerEndpoint.findWebhookImplementation(baseURL));
    }

    public BitbucketServerAPIClient(@NonNull String baseURL, @NonNull String owner, @CheckForNull String repositoryName, @CheckForNull BitbucketAuthenticator authenticator, boolean userCentric, @NonNull BitbucketServerWebhookImplementation webhookImplementation) {
        this.authenticator = authenticator;
        this.userCentric = userCentric;
        this.owner = owner;
        this.repositoryName = repositoryName;
        this.baseURL = Util.removeTrailingSlash((String)baseURL);
        this.webhookImplementation = Objects.requireNonNull(webhookImplementation);
    }

    @Override
    @NonNull
    public String getOwner() {
        return this.owner;
    }

    public String getUserCentricOwner() {
        return this.userCentric ? "~" + this.owner : this.owner;
    }

    @Override
    @CheckForNull
    public String getRepositoryName() {
        return this.repositoryName;
    }

    @Override
    @NonNull
    public String getRepositoryUri(@NonNull BitbucketRepositoryProtocol protocol, @CheckForNull String cloneLink, @NonNull String owner, @NonNull String repository) {
        URI baseUri;
        try {
            baseUri = new URI(this.baseURL);
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException("Server URL is not a valid URI", e);
        }
        UriTemplate template = UriTemplate.fromTemplate((String)"{scheme}://{+authority}{+path}{/owner,repository}.git");
        template.set("owner", (Object)owner);
        template.set("repository", (Object)repository);
        switch (protocol) {
            case HTTP: {
                template.set("scheme", (Object)baseUri.getScheme());
                template.set("authority", (Object)baseUri.getRawAuthority());
                template.set("path", (Object)(Objects.toString(baseUri.getRawPath(), "") + "/scm"));
                break;
            }
            case SSH: {
                template.set("scheme", (Object)BitbucketRepositoryProtocol.SSH.getType());
                template.set("authority", (Object)("git@" + baseUri.getHost()));
                if (cloneLink == null) break;
                try {
                    URI cloneLinkUri = new URI(cloneLink);
                    if (cloneLinkUri.getScheme() != null) {
                        template.set("scheme", (Object)cloneLinkUri.getScheme());
                    }
                    if (cloneLinkUri.getRawAuthority() == null) break;
                    template.set("authority", (Object)cloneLinkUri.getRawAuthority());
                }
                catch (URISyntaxException uRISyntaxException) {}
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported repository protocol: " + (Object)((Object)protocol));
            }
        }
        return template.expand();
    }

    @NonNull
    public List<BitbucketServerPullRequest> getPullRequests() throws IOException, InterruptedException {
        UriTemplate template = UriTemplate.fromTemplate((String)API_PULL_REQUESTS_PATH).set("owner", (Object)this.getUserCentricOwner()).set("repo", (Object)this.repositoryName);
        return this.getPullRequests(template);
    }

    @NonNull
    public List<BitbucketServerPullRequest> getOutgoingOpenPullRequests(String fromRef) throws IOException, InterruptedException {
        UriTemplate template = UriTemplate.fromTemplate((String)API_PULL_REQUESTS_PATH).set("owner", (Object)this.getUserCentricOwner()).set("repo", (Object)this.repositoryName).set("at", (Object)fromRef).set("direction", (Object)"outgoing").set("state", (Object)"OPEN");
        return this.getPullRequests(template);
    }

    @NonNull
    public List<BitbucketServerPullRequest> getIncomingOpenPullRequests(String toRef) throws IOException, InterruptedException {
        UriTemplate template = UriTemplate.fromTemplate((String)API_PULL_REQUESTS_PATH).set("owner", (Object)this.getUserCentricOwner()).set("repo", (Object)this.repositoryName).set("at", (Object)toRef).set("direction", (Object)"incoming").set("state", (Object)"OPEN");
        return this.getPullRequests(template);
    }

    private List<BitbucketServerPullRequest> getPullRequests(UriTemplate template) throws IOException, InterruptedException {
        List<BitbucketServerPullRequest> pullRequests = this.getResources(template, BitbucketServerPullRequests.class);
        pullRequests.removeIf(this::shouldIgnore);
        BitbucketServerEndpoint endpoint = BitbucketEndpointConfiguration.get().findEndpoint(this.baseURL, BitbucketServerEndpoint.class).orElse(null);
        for (BitbucketServerPullRequest pullRequest : pullRequests) {
            this.setupPullRequest(pullRequest, endpoint);
        }
        return pullRequests;
    }

    private void setupPullRequest(BitbucketServerPullRequest pullRequest, BitbucketServerEndpoint endpoint) throws IOException {
        this.setupClosureForPRBranch(pullRequest);
        if (endpoint != null) {
            if (endpoint.isCallCanMerge()) {
                try {
                    pullRequest.setCanMerge(this.getPullRequestCanMergeById(pullRequest.getId()));
                }
                catch (BitbucketRequestException e) {
                    if (e.getHttpCode() == 409) {
                        pullRequest.setCanMerge(false);
                    }
                    throw e;
                }
            }
            if (endpoint.isCallChanges() && BitbucketServerVersion.VERSION_7.equals((Object)endpoint.getServerVersion())) {
                this.callPullRequestChangesById(pullRequest.getId());
            }
        }
    }

    private boolean shouldIgnore(BitbucketPullRequest pullRequest) {
        return pullRequest.getSource().getRepository() == null || pullRequest.getSource().getBranch() == null || pullRequest.getDestination().getBranch() == null;
    }

    private void setupClosureForPRBranch(BitbucketServerPullRequest pr) {
        try {
            BitbucketServerBranch branch = (BitbucketServerBranch)pr.getSource().getBranch();
            if (branch != null) {
                branch.setCommitClosure(new CommitClosure(branch.getRawNode()));
            }
            if ((branch = (BitbucketServerBranch)pr.getDestination().getBranch()) != null) {
                branch.setCommitClosure(new CommitClosure(branch.getRawNode()));
            }
        }
        catch (NullPointerException e) {
            LOGGER.log(Level.SEVERE, "setupClosureForPRBranch", e);
        }
    }

    private void callPullRequestChangesById(@NonNull String id) throws IOException {
        String url = UriTemplate.fromTemplate((String)API_PULL_REQUEST_CHANGES_PATH).set("owner", (Object)this.getUserCentricOwner()).set("repo", (Object)this.repositoryName).set("id", (Object)id).set("limit", (Object)1).expand();
        this.getRequest(url);
    }

    private boolean getPullRequestCanMergeById(@NonNull String id) throws IOException {
        String url = UriTemplate.fromTemplate((String)API_PULL_REQUEST_MERGE_PATH).set("owner", (Object)this.getUserCentricOwner()).set("repo", (Object)this.repositoryName).set("id", (Object)id).expand();
        String response = this.getRequest(url);
        try {
            return JsonParser.toJava(response, BitbucketServerPullRequestCanMerge.class).isCanMerge();
        }
        catch (IOException e) {
            throw new IOException("I/O error when accessing URL: " + url, e);
        }
    }

    @Override
    @NonNull
    public BitbucketPullRequest getPullRequestById(@NonNull Integer id) throws IOException {
        String url = UriTemplate.fromTemplate((String)API_PULL_REQUEST_PATH).set("owner", (Object)this.getUserCentricOwner()).set("repo", (Object)this.repositoryName).set("id", (Object)id).expand();
        String response = this.getRequest(url);
        try {
            BitbucketServerPullRequest pr = JsonParser.toJava(response, BitbucketServerPullRequest.class);
            this.setupClosureForPRBranch(pr);
            this.setupPullRequest(pr, BitbucketEndpointConfiguration.get().findEndpoint(this.baseURL, BitbucketServerEndpoint.class).orElse(null));
            return pr;
        }
        catch (IOException e) {
            throw new IOException("I/O error when accessing URL: " + url, e);
        }
    }

    @Override
    @NonNull
    public BitbucketRepository getRepository() throws IOException {
        if (this.repositoryName == null) {
            throw new UnsupportedOperationException("Cannot get a repository from an API instance that is not associated with a repository");
        }
        String url = UriTemplate.fromTemplate((String)API_REPOSITORY_PATH).set("owner", (Object)this.getUserCentricOwner()).set("repo", (Object)this.repositoryName).expand();
        String response = this.getRequest(url);
        try {
            return JsonParser.toJava(response, BitbucketServerRepository.class);
        }
        catch (IOException e) {
            throw new IOException("I/O error when accessing URL: " + url, e);
        }
    }

    @Override
    public void postCommitComment(@NonNull String hash, @NonNull String comment) throws IOException {
        this.postRequest(UriTemplate.fromTemplate((String)API_COMMIT_COMMENT_PATH).set("owner", (Object)this.getUserCentricOwner()).set("repo", (Object)this.repositoryName).set("hash", (Object)hash).expand(), Collections.singletonList(new BasicNameValuePair("text", comment)));
    }

    @Override
    public void postBuildStatus(@NonNull BitbucketBuildStatus status) throws IOException {
        this.postRequest(UriTemplate.fromTemplate((String)API_COMMIT_STATUS_PATH).set("hash", (Object)status.getHash()).expand(), JsonParser.toJson(status));
    }

    @Override
    public boolean checkPathExists(@NonNull String branchOrHash, @NonNull String path) throws IOException {
        String url = UriTemplate.fromTemplate((String)API_BROWSE_PATH).set("owner", (Object)this.getUserCentricOwner()).set("repo", (Object)this.repositoryName).set("path", (Object)path.split(Operator.PATH.getSeparator())).set("at", (Object)branchOrHash).expand();
        int status = this.getRequestStatus(url);
        if (200 == status) {
            return true;
        }
        if (404 == status || 401 == status) {
            return false;
        }
        throw new IOException("Communication error for url: " + path + " status code: " + status);
    }

    @Override
    @CheckForNull
    public String getDefaultBranch() throws IOException {
        String url = UriTemplate.fromTemplate((String)API_DEFAULT_BRANCH_PATH).set("owner", (Object)this.getUserCentricOwner()).set("repo", (Object)this.repositoryName).expand();
        try {
            String response = this.getRequest(url);
            return JsonParser.toJava(response, BitbucketServerBranch.class).getName();
        }
        catch (FileNotFoundException e) {
            LOGGER.log(Level.FINE, "Could not find default branch for {0}/{1}", new Object[]{this.owner, this.repositoryName});
            return null;
        }
        catch (IOException e) {
            throw new IOException("I/O error when accessing URL: " + url, e);
        }
    }

    @NonNull
    public List<BitbucketServerBranch> getTags() throws IOException, InterruptedException {
        return this.getServerBranches(API_TAGS_PATH, null);
    }

    @NonNull
    public List<BitbucketServerBranch> getTagsByFilterText(String filterText) throws IOException, InterruptedException {
        return this.getServerBranches(API_TAGS_PATH, filterText);
    }

    @NonNull
    public List<BitbucketServerBranch> getBranches() throws IOException, InterruptedException {
        return this.getServerBranches(API_BRANCHES_PATH, null);
    }

    @NonNull
    public List<BitbucketServerBranch> getBranchesByFilterText(String filterText) throws IOException, InterruptedException {
        return this.getServerBranches(API_BRANCHES_PATH, filterText);
    }

    private List<BitbucketServerBranch> getServerBranches(String apiPath, String filterText) throws IOException, InterruptedException {
        UriTemplate template = UriTemplate.fromTemplate((String)apiPath).set("owner", (Object)this.getUserCentricOwner()).set("repo", (Object)this.repositoryName);
        if (filterText != null) {
            template.set("filterText", (Object)filterText);
        }
        List<BitbucketServerBranch> branches = this.getResources(template, BitbucketServerBranches.class);
        for (BitbucketServerBranch branch : branches) {
            if (branch == null) continue;
            branch.setCommitClosure(new CommitClosure(branch.getRawNode()));
        }
        return branches;
    }

    @Override
    @NonNull
    public BitbucketCommit resolveCommit(@NonNull String hash) throws IOException {
        String url = UriTemplate.fromTemplate((String)API_COMMITS_PATH).set("owner", (Object)this.getUserCentricOwner()).set("repo", (Object)this.repositoryName).set("hash", (Object)hash).expand();
        try {
            String response = this.getRequest(url);
            return JsonParser.toJava(response, BitbucketServerCommit.class);
        }
        catch (IOException e) {
            throw new IOException("I/O error when accessing URL: " + url, e);
        }
    }

    @Override
    @NonNull
    public String resolveSourceFullHash(@NonNull BitbucketPullRequest pull) {
        return pull.getSource().getCommit().getHash();
    }

    @Override
    @NonNull
    public BitbucketCommit resolveCommit(@NonNull BitbucketPullRequest pull) throws IOException, InterruptedException {
        return this.resolveCommit(this.resolveSourceFullHash(pull));
    }

    @Override
    public void registerCommitWebHook(BitbucketWebHook hook) throws IOException, InterruptedException {
        switch (this.webhookImplementation) {
            case PLUGIN: {
                this.putRequest(UriTemplate.fromTemplate((String)WEBHOOK_REPOSITORY_PATH).set("owner", (Object)this.getUserCentricOwner()).set("repo", (Object)this.repositoryName).expand(), JsonParser.toJson(hook));
                break;
            }
            case NATIVE: {
                this.postRequest(UriTemplate.fromTemplate((String)API_WEBHOOKS_PATH).set("owner", (Object)this.getUserCentricOwner()).set("repo", (Object)this.repositoryName).expand(), JsonParser.toJson(hook));
                break;
            }
            default: {
                LOGGER.log(Level.WARNING, "Cannot register {0} webhook.", (Object)this.webhookImplementation);
            }
        }
    }

    @Override
    public void updateCommitWebHook(BitbucketWebHook hook) throws IOException, InterruptedException {
        switch (this.webhookImplementation) {
            case PLUGIN: {
                this.postRequest(UriTemplate.fromTemplate((String)WEBHOOK_REPOSITORY_CONFIG_PATH).set("owner", (Object)this.getUserCentricOwner()).set("repo", (Object)this.repositoryName).set("id", (Object)hook.getUuid()).expand(), JsonParser.toJson(hook));
                break;
            }
            case NATIVE: {
                this.putRequest(UriTemplate.fromTemplate((String)API_WEBHOOKS_PATH).set("owner", (Object)this.getUserCentricOwner()).set("repo", (Object)this.repositoryName).set("id", (Object)hook.getUuid()).expand(), JsonParser.toJson(hook));
                break;
            }
            default: {
                LOGGER.log(Level.WARNING, "Cannot update {0} webhook.", (Object)this.webhookImplementation);
            }
        }
    }

    @Override
    public void removeCommitWebHook(BitbucketWebHook hook) throws IOException, InterruptedException {
        switch (this.webhookImplementation) {
            case PLUGIN: {
                this.deleteRequest(UriTemplate.fromTemplate((String)WEBHOOK_REPOSITORY_CONFIG_PATH).set("owner", (Object)this.getUserCentricOwner()).set("repo", (Object)this.repositoryName).set("id", (Object)hook.getUuid()).expand());
                break;
            }
            case NATIVE: {
                this.deleteRequest(UriTemplate.fromTemplate((String)API_WEBHOOKS_PATH).set("owner", (Object)this.getUserCentricOwner()).set("repo", (Object)this.repositoryName).set("id", (Object)hook.getUuid()).expand());
                break;
            }
            default: {
                LOGGER.log(Level.WARNING, "Cannot remove {0} webhook.", (Object)this.webhookImplementation);
            }
        }
    }

    @Override
    @NonNull
    public List<? extends BitbucketWebHook> getWebHooks() throws IOException, InterruptedException {
        switch (this.webhookImplementation) {
            case PLUGIN: {
                String url = UriTemplate.fromTemplate((String)WEBHOOK_REPOSITORY_PATH).set("owner", (Object)this.getUserCentricOwner()).set("repo", (Object)this.repositoryName).expand();
                String response = this.getRequest(url);
                return JsonParser.toJava(response, BitbucketServerWebhooks.class);
            }
            case NATIVE: {
                UriTemplate urlTemplate = UriTemplate.fromTemplate((String)API_WEBHOOKS_PATH).set("owner", (Object)this.getUserCentricOwner()).set("repo", (Object)this.repositoryName);
                return this.getResources(urlTemplate, NativeBitbucketServerWebhooks.class);
            }
        }
        return Collections.emptyList();
    }

    @Override
    public BitbucketTeam getTeam() throws IOException {
        if (this.userCentric) {
            return null;
        }
        String url = UriTemplate.fromTemplate((String)API_PROJECT_PATH).set("owner", (Object)this.getOwner()).expand();
        try {
            String response = this.getRequest(url);
            return JsonParser.toJava(response, BitbucketServerProject.class);
        }
        catch (FileNotFoundException e) {
            return null;
        }
        catch (IOException e) {
            throw new IOException("I/O error when accessing URL: " + url, e);
        }
    }

    @Override
    public AvatarCacheSource.AvatarImage getTeamAvatar() throws IOException {
        if (this.userCentric) {
            return null;
        }
        String url = UriTemplate.fromTemplate((String)AVATAR_PATH).set("owner", (Object)this.getOwner()).expand();
        try {
            BufferedImage response = this.getImageRequest(url);
            return new AvatarCacheSource.AvatarImage(response, System.currentTimeMillis());
        }
        catch (FileNotFoundException e) {
            return null;
        }
        catch (IOException e) {
            throw new IOException("I/O error when accessing URL: " + url, e);
        }
        catch (InterruptedException e) {
            throw new IOException("InterruptedException when accessing URL: " + url, e);
        }
    }

    @NonNull
    public List<BitbucketServerRepository> getRepositories(@CheckForNull UserRoleInRepository role) throws IOException, InterruptedException {
        List<BitbucketServerRepository> repositories;
        UriTemplate template = UriTemplate.fromTemplate((String)API_REPOSITORIES_PATH).set("owner", (Object)this.getUserCentricOwner());
        try {
            repositories = this.getResources(template, BitbucketServerRepositories.class);
        }
        catch (FileNotFoundException e) {
            return new ArrayList<BitbucketServerRepository>();
        }
        repositories.sort(Comparator.comparing(BitbucketServerRepository::getRepositoryName));
        return repositories;
    }

    @NonNull
    public List<BitbucketServerRepository> getRepositories() throws IOException, InterruptedException {
        return this.getRepositories(null);
    }

    @Override
    public boolean isPrivate() throws IOException {
        return this.getRepository().isPrivate();
    }

    private <V> List<V> getResources(UriTemplate template, Class<? extends PagedApiResponse<V>> clazz) throws IOException, InterruptedException {
        PagedApiResponse<V> page;
        ArrayList<V> resources = new ArrayList<V>();
        Integer pageNumber = 0;
        Integer limit = DEFAULT_PAGE_LIMIT;
        do {
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            String url = template.set("start", (Object)pageNumber).set("limit", (Object)limit).expand();
            String response = this.getRequest(url);
            try {
                page = JsonParser.toJava(response, clazz);
            }
            catch (IOException e) {
                throw new IOException("I/O error when parsing response from URL: " + url, e);
            }
            resources.addAll(page.getValues());
            limit = page.getLimit();
            pageNumber = page.getNextPageStart();
        } while (!page.isLastPage());
        return resources;
    }

    /*
     * Exception decompiling
     */
    protected String getRequest(String path) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    private BufferedImage getImageRequest(String path) throws IOException, InterruptedException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private CloseableHttpClient getHttpClient(HttpRequestBase request) {
        HttpClientBuilder httpClientBuilder = HttpClientBuilder.create();
        httpClientBuilder.useSystemProperties();
        httpClientBuilder.setRetryHandler((HttpRequestRetryHandler)new StandardHttpRequestRetryHandler());
        RequestConfig.Builder requestConfig = RequestConfig.custom();
        String connectTimeout = System.getProperty("http.connect.timeout", "10");
        requestConfig.setConnectTimeout(Integer.parseInt(connectTimeout) * 1000);
        String connectionRequestTimeout = System.getProperty("http.connect.request.timeout", "60");
        requestConfig.setConnectionRequestTimeout(Integer.parseInt(connectionRequestTimeout) * 1000);
        String socketTimeout = System.getProperty("http.socket.timeout", "60");
        requestConfig.setSocketTimeout(Integer.parseInt(socketTimeout) * 1000);
        request.setConfig(requestConfig.build());
        String host = BitbucketServerAPIClient.getMethodHost(request);
        if (this.authenticator != null) {
            this.authenticator.configureBuilder(httpClientBuilder);
            this.context = HttpClientContext.create();
            this.authenticator.configureContext(this.context, HttpHost.create((String)host));
        }
        this.setClientProxyParams(host, httpClientBuilder);
        return httpClientBuilder.build();
    }

    private void setClientProxyParams(String host, HttpClientBuilder builder) {
        Proxy proxy;
        Jenkins jenkins = Jenkins.get();
        ProxyConfiguration proxyConfig = null;
        if (jenkins != null) {
            proxyConfig = jenkins.proxy;
        }
        if (proxyConfig != null) {
            URI hostURI = URI.create(host);
            proxy = proxyConfig.createProxy(hostURI.getHost());
        } else {
            proxy = Proxy.NO_PROXY;
        }
        if (proxy.type() != Proxy.Type.DIRECT) {
            InetSocketAddress proxyAddress = (InetSocketAddress)proxy.address();
            LOGGER.log(Level.FINE, "Jenkins proxy: {0}", proxy.address());
            builder.setProxy(new HttpHost(proxyAddress.getHostName(), proxyAddress.getPort()));
            String username = proxyConfig.getUserName();
            String password = proxyConfig.getPassword();
            if (username != null && !"".equals(username.trim())) {
                LOGGER.fine("Using proxy authentication (user=" + username + ")");
                BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
                credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(username, password));
                BasicAuthCache authCache = new BasicAuthCache();
                authCache.put(HttpHost.create((String)proxyAddress.getHostName()), (AuthScheme)new BasicScheme());
                this.context = HttpClientContext.create();
                this.context.setCredentialsProvider((CredentialsProvider)credentialsProvider);
                this.context.setAuthCache((AuthCache)authCache);
            }
        }
    }

    /*
     * Exception decompiling
     */
    private int getRequestStatus(String path) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static String getMethodHost(HttpRequestBase method) {
        URI uri = method.getURI();
        String scheme = uri.getScheme() == null ? "http" : uri.getScheme();
        return scheme + "://" + uri.getAuthority();
    }

    private String postRequest(String path, List<? extends NameValuePair> params) throws IOException {
        HttpPost request = new HttpPost(this.baseURL + path);
        request.setEntity((HttpEntity)new UrlEncodedFormEntity(params));
        return this.postRequest(request);
    }

    private String postRequest(String path, String content) throws IOException {
        HttpPost request = new HttpPost(this.baseURL + path);
        request.setEntity((HttpEntity)new StringEntity(content, ContentType.create((String)"application/json", (String)"UTF-8")));
        LOGGER.log(Level.FINEST, content);
        return this.postRequest(request);
    }

    private String nameValueToJson(NameValuePair[] params) {
        JSONObject o = new JSONObject();
        for (NameValuePair pair : params) {
            o.put(pair.getName(), (Object)pair.getValue());
        }
        return o.toString();
    }

    private String postRequest(HttpPost httppost) throws IOException {
        return this.doRequest((HttpRequestBase)httppost);
    }

    /*
     * Exception decompiling
     */
    private String doRequest(HttpRequestBase request) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private String putRequest(String path, String content) throws IOException {
        HttpPut request = new HttpPut(this.baseURL + path);
        request.setEntity((HttpEntity)new StringEntity(content, ContentType.create((String)"application/json", (String)"UTF-8")));
        return this.doRequest((HttpRequestBase)request);
    }

    private String deleteRequest(String path) throws IOException {
        HttpDelete request = new HttpDelete(this.baseURL + path);
        return this.doRequest((HttpRequestBase)request);
    }

    @Override
    public Iterable<SCMFile> getDirectoryContent(BitbucketSCMFile directory) throws IOException, InterruptedException {
        ArrayList<SCMFile> files = new ArrayList<SCMFile>();
        int start = 0;
        UriTemplate template = UriTemplate.fromTemplate((String)"/rest/api/1.0/projects/{owner}/repos/{repo}/browse{/path*}{?at}{&start,limit}").set("owner", (Object)this.getUserCentricOwner()).set("repo", (Object)this.repositoryName).set("path", (Object)directory.getPath().split(Operator.PATH.getSeparator())).set("at", (Object)directory.getRef()).set("start", (Object)start).set("limit", (Object)500);
        String url = template.expand();
        String response = this.getRequest(url);
        Map content = (Map)JsonParser.mapper.readValue(response, (TypeReference)new TypeReference<Map<String, Object>>(){});
        Map page = (Map)content.get("children");
        List values = (List)page.get("values");
        this.collectFileAndDirectories(directory, values, files);
        while (!((Boolean)page.get("isLastPage")).booleanValue()) {
            url = template.set("start", (Object)(start += ((Integer)content.get("size")).intValue())).expand();
            response = this.getRequest(url);
            content = (Map)JsonParser.mapper.readValue(response, (TypeReference)new TypeReference<Map<String, Object>>(){});
            page = (Map)content.get("children");
        }
        return files;
    }

    private void collectFileAndDirectories(BitbucketSCMFile parent, List<Map> values, List<SCMFile> files) {
        for (Map file : values) {
            String type = (String)file.get("type");
            List components = (List)((Map)file.get("path")).get("components");
            SCMFile.Type fileType = null;
            if (type.equals("FILE")) {
                fileType = SCMFile.Type.REGULAR_FILE;
            } else if (type.equals("DIRECTORY")) {
                fileType = SCMFile.Type.DIRECTORY;
            }
            if (components.size() <= 0 || fileType == null) continue;
            files.add(new BitbucketSCMFile(parent, (String)components.get(0), fileType, null));
        }
    }

    @Override
    public InputStream getFileContent(BitbucketSCMFile file) throws IOException, InterruptedException {
        ArrayList<String> lines = new ArrayList<String>();
        int start = 0;
        UriTemplate template = UriTemplate.fromTemplate((String)"/rest/api/1.0/projects/{owner}/repos/{repo}/browse{/path*}{?at}{&start,limit}").set("owner", (Object)this.getUserCentricOwner()).set("repo", (Object)this.repositoryName).set("path", (Object)file.getPath().split(Operator.PATH.getSeparator())).set("at", (Object)file.getRef()).set("start", (Object)start).set("limit", (Object)500);
        String url = template.expand();
        String response = this.getRequest(url);
        Map<String, Object> content = this.collectLines(response, lines);
        while (!((Boolean)content.get("isLastPage")).booleanValue()) {
            url = template.set("start", (Object)(start += ((Integer)content.get("size")).intValue())).expand();
            response = this.getRequest(url);
            content = this.collectLines(response, lines);
        }
        return IOUtils.toInputStream((String)StringUtils.join(lines, (char)'\n'), (String)"UTF-8");
    }

    private Map<String, Object> collectLines(String response, List<String> lines) throws IOException {
        Map content = (Map)JsonParser.mapper.readValue(response, (TypeReference)new TypeReference<Map<String, Object>>(){});
        List lineMap = (List)content.get("lines");
        for (Map line : lineMap) {
            String text = (String)line.get("text");
            if (text == null) continue;
            lines.add(text);
        }
        return content;
    }

    private class CommitClosure
    implements Callable<BitbucketCommit> {
        private final String hash;

        public CommitClosure(String hash) {
            this.hash = hash;
        }

        @Override
        public BitbucketCommit call() throws Exception {
            return BitbucketServerAPIClient.this.resolveCommit(this.hash);
        }
    }
}

