/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.plugins.bitbucket.endpoints;

import com.cloudbees.jenkins.plugins.bitbucket.client.BitbucketCloudApiClient;
import com.cloudbees.jenkins.plugins.bitbucket.endpoints.AbstractBitbucketEndpoint;
import com.cloudbees.jenkins.plugins.bitbucket.endpoints.AbstractBitbucketEndpointDescriptor;
import com.cloudbees.jenkins.plugins.bitbucket.endpoints.Messages;
import com.damnhandy.uri.template.UriTemplate;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.util.FormValidation;
import java.util.List;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.DataBoundConstructor;

public class BitbucketCloudEndpoint
extends AbstractBitbucketEndpoint {
    public static final String SERVER_URL = "https://bitbucket.org";
    public static final String BAD_SERVER_URL = "http://bitbucket.org";
    private final boolean enableCache;
    private final int teamCacheDuration;
    private final int repositoriesCacheDuration;

    public BitbucketCloudEndpoint(boolean manageHooks, @CheckForNull String credentialsId) {
        this(false, 0, 0, manageHooks, credentialsId);
    }

    @Restricted(value={NoExternalUse.class})
    public BitbucketCloudEndpoint(boolean manageHooks, @CheckForNull String credentialsId, String endPointURL) {
        this(manageHooks, credentialsId);
        this.setBitbucketJenkinsRootUrl(endPointURL);
    }

    @DataBoundConstructor
    public BitbucketCloudEndpoint(boolean enableCache, int teamCacheDuration, int repositoriesCacheDuration, boolean manageHooks, @CheckForNull String credentialsId) {
        super(manageHooks, credentialsId);
        this.enableCache = enableCache;
        this.teamCacheDuration = teamCacheDuration;
        this.repositoriesCacheDuration = repositoriesCacheDuration;
    }

    public boolean isEnableCache() {
        return this.enableCache;
    }

    public int getTeamCacheDuration() {
        return this.teamCacheDuration;
    }

    public int getRepositoriesCacheDuration() {
        return this.repositoriesCacheDuration;
    }

    @Override
    public String getDisplayName() {
        return Messages.BitbucketCloudEndpoint_displayName();
    }

    @Override
    @NonNull
    public String getServerUrl() {
        return SERVER_URL;
    }

    @Override
    @NonNull
    public String getRepositoryUrl(@NonNull String repoOwner, @NonNull String repository) {
        UriTemplate template = UriTemplate.fromTemplate((String)"https://bitbucket.org{/owner,repo}").set("owner", (Object)repoOwner).set("repo", (Object)repository);
        return template.expand();
    }

    private Object readResolve() {
        if (this.getBitbucketJenkinsRootUrl() != null) {
            this.setBitbucketJenkinsRootUrl(this.getBitbucketJenkinsRootUrl());
        }
        return this;
    }

    @Extension
    public static class DescriptorImpl
    extends AbstractBitbucketEndpointDescriptor {
        @NonNull
        public String getDisplayName() {
            return Messages.BitbucketCloudEndpoint_displayName();
        }

        public FormValidation doShowStats() {
            List<String> stats = BitbucketCloudApiClient.stats();
            StringBuilder builder = new StringBuilder();
            for (String stat : stats) {
                builder.append(stat).append("<br>");
            }
            return FormValidation.okWithMarkup((String)builder.toString());
        }

        public FormValidation doClear() {
            BitbucketCloudApiClient.clearCaches();
            return FormValidation.ok((String)"Caches cleared");
        }
    }
}

