/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.plugins.bitbucket.client;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;

public class Cache<K, V> {
    private static final int MAX_ENTRIES_DEFAULT = 100;
    private final Map<K, Entry<V>> entries;
    private long expireAfterNanos;

    public Cache(int duration, TimeUnit unit) {
        this(duration, unit, 100);
    }

    public Cache(int duration, TimeUnit unit, int maxEntries) {
        this.expireAfterNanos = unit.toNanos(duration);
        this.entries = new LimitedMap<K, Entry<V>>(maxEntries);
    }

    public synchronized V get(K key, Callable<V> callable) throws ExecutionException {
        V result;
        if (this.isExpired(key)) {
            this.doRemove(key);
        }
        if (this.entries.containsKey(key)) {
            return (V)((Entry)this.entries.get(key)).value;
        }
        try {
            result = callable.call();
        }
        catch (Exception e) {
            throw new ExecutionException("Cannot load value for key: " + key, e);
        }
        return this.doPut(key, result);
    }

    public void evictAll() {
        this.entries.clear();
    }

    public int size() {
        return this.entries.size();
    }

    public void setExpireDuration(int duration, TimeUnit unit) {
        this.expireAfterNanos = unit.toNanos(duration);
    }

    public Stat stats() {
        ArrayList<Long> durations = new ArrayList<Long>();
        if (this.entries.size() > 0) {
            for (Entry<V> e : this.entries.values()) {
                durations.add(System.nanoTime() - ((Entry)e).nanos);
            }
            Collections.sort(durations);
        } else {
            durations.add(0L);
            durations.add(0L);
        }
        return new Stat(this.entries.size(), (Long)durations.get(0), (Long)durations.get(durations.size() - 1));
    }

    private boolean isExpired(K key) {
        Entry<V> entry = this.entries.get(key);
        return entry != null && System.nanoTime() - ((Entry)entry).nanos > this.expireAfterNanos;
    }

    private void doRemove(K key) {
        this.entries.remove(key);
    }

    private V doPut(K key, V value) {
        this.entries.put(key, new Entry<V>(value));
        return value;
    }

    public static class Stat {
        private final int count;
        private final long minDuration;
        private final long maxDuration;

        public Stat(int count, long minDuration, long maxDuration) {
            this.count = count;
            this.minDuration = minDuration;
            this.maxDuration = maxDuration;
        }

        public int getCount() {
            return this.count;
        }

        public long getMinDuration() {
            return this.minDuration;
        }

        public long getMaxDuration() {
            return this.maxDuration;
        }

        public String toString() {
            if (this.count == 0) {
                return "No entry.";
            }
            StringBuilder builder = new StringBuilder();
            if (this.count == 1) {
                builder.append("1 entry, since ").append(TimeUnit.NANOSECONDS.toMinutes(this.minDuration)).append(" minutes");
            } else {
                builder.append(this.count).append(" entries, since ").append(TimeUnit.NANOSECONDS.toMinutes(this.minDuration)).append(" (youngest) to ").append(TimeUnit.NANOSECONDS.toMinutes(this.maxDuration)).append(" (oldest) minutes.");
            }
            return builder.toString();
        }
    }

    private static class Entry<V> {
        private final V value;
        private final long nanos;

        public Entry(V value) {
            this.value = value;
            this.nanos = System.nanoTime();
        }
    }

    private static class LimitedMap<K, V>
    extends LinkedHashMap<K, V> {
        private final int maxEntries;

        public LimitedMap(int maxEntries) {
            this.maxEntries = maxEntries;
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
            return this.size() > this.maxEntries;
        }
    }
}

