/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.plugins.bitbucket.client;

import com.cloudbees.jenkins.plugins.bitbucket.JsonParser;
import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketApi;
import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketAuthenticator;
import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketBuildStatus;
import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketCloudWorkspace;
import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketCommit;
import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketException;
import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketPullRequest;
import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketRepository;
import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketRepositoryProtocol;
import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketRequestException;
import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketTeam;
import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketWebHook;
import com.cloudbees.jenkins.plugins.bitbucket.api.credentials.BitbucketUsernamePasswordAuthenticator;
import com.cloudbees.jenkins.plugins.bitbucket.avatars.AvatarCacheSource;
import com.cloudbees.jenkins.plugins.bitbucket.client.BitbucketCloudPage;
import com.cloudbees.jenkins.plugins.bitbucket.client.Cache;
import com.cloudbees.jenkins.plugins.bitbucket.client.ClosingConnectionInputStream;
import com.cloudbees.jenkins.plugins.bitbucket.client.branch.BitbucketCloudBranch;
import com.cloudbees.jenkins.plugins.bitbucket.client.branch.BitbucketCloudCommit;
import com.cloudbees.jenkins.plugins.bitbucket.client.pullrequest.BitbucketPullRequestCommit;
import com.cloudbees.jenkins.plugins.bitbucket.client.pullrequest.BitbucketPullRequestCommits;
import com.cloudbees.jenkins.plugins.bitbucket.client.pullrequest.BitbucketPullRequestValue;
import com.cloudbees.jenkins.plugins.bitbucket.client.pullrequest.BitbucketPullRequests;
import com.cloudbees.jenkins.plugins.bitbucket.client.repository.BitbucketCloudRepository;
import com.cloudbees.jenkins.plugins.bitbucket.client.repository.BitbucketRepositoryHook;
import com.cloudbees.jenkins.plugins.bitbucket.client.repository.BitbucketRepositoryHooks;
import com.cloudbees.jenkins.plugins.bitbucket.client.repository.BitbucketRepositorySource;
import com.cloudbees.jenkins.plugins.bitbucket.client.repository.PaginatedBitbucketRepository;
import com.cloudbees.jenkins.plugins.bitbucket.client.repository.UserRoleInRepository;
import com.cloudbees.jenkins.plugins.bitbucket.filesystem.BitbucketSCMFile;
import com.cloudbees.plugins.credentials.common.StandardUsernamePasswordCredentials;
import com.damnhandy.uri.template.UriTemplate;
import com.damnhandy.uri.template.impl.Operator;
import com.fasterxml.jackson.core.type.TypeReference;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.ProxyConfiguration;
import hudson.Util;
import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import jenkins.model.Jenkins;
import jenkins.scm.api.SCMFile;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.NameValuePair;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.AuthCache;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.config.SocketConfig;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.BasicAuthCache;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.StandardHttpRequestRetryHandler;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.ProtectedExternally;

public class BitbucketCloudApiClient
implements BitbucketApi {
    private static final Logger LOGGER = Logger.getLogger(BitbucketCloudApiClient.class.getName());
    private static final HttpHost API_HOST = HttpHost.create((String)"https://api.bitbucket.org");
    private static final String V2_API_BASE_URL = "https://api.bitbucket.org/2.0/repositories";
    private static final String V2_WORKSPACES_API_BASE_URL = "https://api.bitbucket.org/2.0/workspaces";
    private static final String REPO_URL_TEMPLATE = "https://api.bitbucket.org/2.0/repositories{/owner,repo}";
    private static final int API_RATE_LIMIT_CODE = 429;
    private static final int MAX_AVATAR_LENGTH = 16384;
    private static final int MAX_PAGE_LENGTH = 100;
    private static final PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager();
    private CloseableHttpClient client;
    private HttpClientContext context;
    private final String owner;
    private final String repositoryName;
    private final boolean enableCache;
    private final BitbucketAuthenticator authenticator;
    private static final Cache<String, BitbucketTeam> cachedTeam = new Cache(6, TimeUnit.HOURS);
    private static final Cache<String, AvatarCacheSource.AvatarImage> cachedAvatar = new Cache(6, TimeUnit.HOURS);
    private static final Cache<String, List<BitbucketCloudRepository>> cachedRepositories = new Cache(3, TimeUnit.HOURS);
    private transient BitbucketRepository cachedRepository;
    private transient String cachedDefaultBranch;

    public static List<String> stats() {
        ArrayList<String> stats = new ArrayList<String>();
        stats.add("Team: " + cachedTeam.stats().toString());
        stats.add("Repositories : " + cachedRepositories.stats().toString());
        return stats;
    }

    public static void clearCaches() {
        cachedTeam.evictAll();
        cachedRepositories.evictAll();
    }

    @Deprecated
    public BitbucketCloudApiClient(boolean enableCache, int teamCacheDuration, int repositoriesCacheDuration, String owner, String repositoryName, StandardUsernamePasswordCredentials credentials) {
        this(enableCache, teamCacheDuration, repositoriesCacheDuration, owner, repositoryName, new BitbucketUsernamePasswordAuthenticator(credentials));
    }

    public BitbucketCloudApiClient(boolean enableCache, int teamCacheDuration, int repositoriesCacheDuration, String owner, String repositoryName, BitbucketAuthenticator authenticator) {
        this.authenticator = authenticator;
        this.owner = owner;
        this.repositoryName = repositoryName;
        this.enableCache = enableCache;
        if (enableCache) {
            cachedTeam.setExpireDuration(teamCacheDuration, TimeUnit.MINUTES);
            cachedRepositories.setExpireDuration(repositoriesCacheDuration, TimeUnit.MINUTES);
        }
        HttpClientBuilder httpClientBuilder = HttpClientBuilder.create();
        httpClientBuilder.setKeepAliveStrategy((__, ___) -> TimeUnit.MILLISECONDS.convert(5L, TimeUnit.SECONDS));
        httpClientBuilder.setConnectionManager((HttpClientConnectionManager)connectionManager);
        httpClientBuilder.setConnectionManagerShared(true);
        httpClientBuilder.setRetryHandler((HttpRequestRetryHandler)new StandardHttpRequestRetryHandler());
        if (authenticator != null) {
            authenticator.configureBuilder(httpClientBuilder);
            this.context = HttpClientContext.create();
            authenticator.configureContext(this.context, API_HOST);
        }
        this.setClientProxyParams("bitbucket.org", httpClientBuilder);
        this.client = httpClientBuilder.build();
    }

    protected void finalize() throws Throwable {
        if (this.client != null) {
            this.client.close();
        }
        super.finalize();
    }

    @Override
    @NonNull
    public String getOwner() {
        return this.owner;
    }

    @Override
    @CheckForNull
    public String getRepositoryName() {
        return this.repositoryName;
    }

    @Override
    @NonNull
    public String getRepositoryUri(@NonNull BitbucketRepositoryProtocol protocol, @CheckForNull String cloneLink, @NonNull String owner, @NonNull String repository) {
        switch (protocol) {
            case HTTP: {
                String username;
                if (this.authenticator != null && !(username = this.authenticator.getUserUri()).isEmpty()) {
                    return "https://" + username + "@bitbucket.org/" + owner + "/" + repository + ".git";
                }
                return "https://bitbucket.org/" + owner + "/" + repository + ".git";
            }
            case SSH: {
                return "git@bitbucket.org:" + owner + "/" + repository + ".git";
            }
        }
        throw new IllegalArgumentException("Unsupported repository protocol: " + (Object)((Object)protocol));
    }

    @NonNull
    public List<BitbucketPullRequestValue> getPullRequests() throws InterruptedException, IOException {
        BitbucketPullRequests page;
        ArrayList<BitbucketPullRequestValue> pullRequests = new ArrayList<BitbucketPullRequestValue>();
        int pageLen = 50;
        UriTemplate template = UriTemplate.fromTemplate((String)"https://api.bitbucket.org/2.0/repositories{/owner,repo}/pullrequests{?page,pagelen}").set("owner", (Object)this.owner).set("repo", (Object)this.repositoryName).set("pagelen", (Object)pageLen);
        int pageNumber = 1;
        do {
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            String url = template.set("page", (Object)pageNumber++).expand();
            String response = this.getRequest(url);
            try {
                page = JsonParser.toJava(response, BitbucketPullRequests.class);
            }
            catch (IOException e) {
                throw new IOException("I/O error when parsing response from URL: " + url, e);
            }
            pullRequests.addAll(page.getValues());
        } while (page.getNext() != null);
        pullRequests.removeIf(this::shouldIgnore);
        for (BitbucketPullRequestValue pullRequest : pullRequests) {
            this.setupClosureForPRBranch(pullRequest);
        }
        return pullRequests;
    }

    private boolean shouldIgnore(BitbucketPullRequest pr) {
        return pr.getSource().getRepository() == null || pr.getSource().getCommit() == null || pr.getDestination().getBranch() == null || pr.getDestination().getCommit() == null;
    }

    private void setupClosureForPRBranch(BitbucketPullRequestValue pullRequest) {
        BitbucketCloudBranch branch = pullRequest.getSource().getBranch();
        if (branch != null) {
            branch.setCommitClosure(new CommitClosure(branch.getRawNode()));
        }
        if ((branch = pullRequest.getDestination().getBranch()) != null) {
            branch.setCommitClosure(new CommitClosure(branch.getRawNode()));
        }
    }

    @Deprecated
    @CheckForNull
    public String getLogin() {
        if (this.authenticator != null) {
            return this.authenticator.getId();
        }
        return null;
    }

    @Override
    @NonNull
    public BitbucketPullRequest getPullRequestById(@NonNull Integer id) throws IOException, InterruptedException {
        String url = UriTemplate.fromTemplate((String)"https://api.bitbucket.org/2.0/repositories{/owner,repo}/pullrequests{/id}").set("owner", (Object)this.owner).set("repo", (Object)this.repositoryName).set("id", (Object)id).expand();
        String response = this.getRequest(url);
        try {
            BitbucketPullRequestValue pr = JsonParser.toJava(response, BitbucketPullRequestValue.class);
            this.setupClosureForPRBranch(pr);
            return pr;
        }
        catch (IOException e) {
            throw new IOException("I/O error when parsing response from URL: " + url, e);
        }
    }

    @Override
    @NonNull
    public BitbucketRepository getRepository() throws IOException, InterruptedException {
        if (this.repositoryName == null) {
            throw new UnsupportedOperationException("Cannot get a repository from an API instance that is not associated with a repository");
        }
        if (!this.enableCache || this.cachedRepository == null) {
            String url = UriTemplate.fromTemplate((String)REPO_URL_TEMPLATE).set("owner", (Object)this.owner).set("repo", (Object)this.repositoryName).expand();
            String response = this.getRequest(url);
            try {
                this.cachedRepository = JsonParser.toJava(response, BitbucketCloudRepository.class);
            }
            catch (IOException e) {
                throw new IOException("I/O error when parsing response from URL: " + url, e);
            }
        }
        return this.cachedRepository;
    }

    @Override
    public void postCommitComment(@NonNull String hash, @NonNull String comment) throws IOException, InterruptedException {
        String path = UriTemplate.fromTemplate((String)"https://api.bitbucket.org/2.0/repositories{/owner,repo}/commit{/hash}/build").set("owner", (Object)this.owner).set("repo", (Object)this.repositoryName).set("hash", (Object)hash).expand();
        try {
            this.postRequest(path, Collections.singletonList(new BasicNameValuePair("content", comment)));
        }
        catch (UnsupportedEncodingException e) {
            throw e;
        }
        catch (IOException e) {
            throw new IOException("Cannot comment on commit, url: " + path, e);
        }
    }

    @Override
    public boolean checkPathExists(@NonNull String branchOrHash, @NonNull String path) throws IOException, InterruptedException {
        String url = UriTemplate.fromTemplate((String)"https://api.bitbucket.org/2.0/repositories{/owner,repo}/src{/branchOrHash,path*}").set("owner", (Object)this.owner).set("repo", (Object)this.repositoryName).set("branchOrHash", (Object)branchOrHash).set("path", (Object)path.split(Operator.PATH.getSeparator())).expand();
        int status = this.headRequestStatus(url);
        if (200 == status) {
            return true;
        }
        if (404 == status) {
            return false;
        }
        if (403 == status) {
            LOGGER.log(Level.FINE, "You currently do not have permissions to pull from repo: {0} at branch {1}", new Object[]{this.repositoryName, branchOrHash});
            return false;
        }
        throw new IOException("Communication error for url: " + path + " status code: " + status);
    }

    @Override
    @CheckForNull
    public String getDefaultBranch() throws IOException, InterruptedException {
        if (!this.enableCache || this.cachedDefaultBranch == null) {
            String response;
            String url = UriTemplate.fromTemplate((String)"https://api.bitbucket.org/2.0/repositories{/owner,repo}/{?fields}").set("owner", (Object)this.owner).set("repo", (Object)this.repositoryName).set("fields", (Object)"mainbranch.name").expand();
            try {
                response = this.getRequest(url);
            }
            catch (FileNotFoundException e) {
                LOGGER.log(Level.FINE, "Could not find default branch for {0}/{1}", new Object[]{this.owner, this.repositoryName});
                return null;
            }
            Map resp = JsonParser.toJava(response, Map.class);
            Map mainbranch = (Map)resp.get("mainbranch");
            if (mainbranch != null) {
                this.cachedDefaultBranch = (String)mainbranch.get("name");
            }
        }
        return this.cachedDefaultBranch;
    }

    @NonNull
    public List<BitbucketCloudBranch> getTags() throws IOException, InterruptedException {
        return this.getBranchesByRef("/refs/tags");
    }

    @NonNull
    public List<BitbucketCloudBranch> getBranches() throws IOException, InterruptedException {
        return this.getBranchesByRef("/refs/branches");
    }

    @NonNull
    public List<BitbucketCloudBranch> getBranchesByFilterText(String filterText) throws IOException, InterruptedException {
        ArrayList<BitbucketCloudBranch> branches = new ArrayList<BitbucketCloudBranch>();
        for (BitbucketCloudBranch branch : this.getBranches()) {
            if (!branch.getName().contains(filterText)) continue;
            branches.add(branch);
        }
        return branches;
    }

    @NonNull
    public List<BitbucketCloudBranch> getTagsByFilterText(String filterText) throws IOException, InterruptedException {
        ArrayList<BitbucketCloudBranch> branches = new ArrayList<BitbucketCloudBranch>();
        for (BitbucketCloudBranch branch : this.getTags()) {
            if (!branch.getName().contains(filterText)) continue;
            branches.add(branch);
        }
        return branches;
    }

    public List<BitbucketCloudBranch> getBranchesByRef(String nodePath) throws IOException, InterruptedException {
        String url = UriTemplate.fromTemplate((String)(REPO_URL_TEMPLATE + nodePath + "{?pagelen}")).set("owner", (Object)this.owner).set("repo", (Object)this.repositoryName).set("pagelen", (Object)100).expand();
        String response = this.getRequest(url);
        try {
            return this.getAllBranches(response);
        }
        catch (IOException e) {
            throw new IOException("I/O error when parsing response from URL: " + url, e);
        }
    }

    @Override
    @CheckForNull
    public BitbucketCommit resolveCommit(@NonNull String hash) throws IOException, InterruptedException {
        String response;
        String url = UriTemplate.fromTemplate((String)"https://api.bitbucket.org/2.0/repositories{/owner,repo}/commit/{hash}").set("owner", (Object)this.owner).set("repo", (Object)this.repositoryName).set("hash", (Object)hash).expand();
        try {
            response = this.getRequest(url);
        }
        catch (FileNotFoundException e) {
            return null;
        }
        try {
            return JsonParser.toJava(response, BitbucketCloudCommit.class);
        }
        catch (IOException e) {
            throw new IOException("I/O error when parsing response from URL: " + url, e);
        }
    }

    @Override
    @NonNull
    public String resolveSourceFullHash(@NonNull BitbucketPullRequest pull) throws IOException, InterruptedException {
        return this.resolveCommit(pull).getHash();
    }

    @Override
    @NonNull
    public BitbucketCommit resolveCommit(@NonNull BitbucketPullRequest pull) throws IOException, InterruptedException {
        String url = UriTemplate.fromTemplate((String)"https://api.bitbucket.org/2.0/repositories{/owner,repo}/pullrequests/{pullId}/commits{?fields,pagelen}").set("owner", (Object)this.owner).set("repo", (Object)this.repositoryName).set("pullId", (Object)pull.getId()).set("fields", (Object)"values.hash,values.author.raw,values.date,values.message").set("pagelen", (Object)1).expand();
        String response = this.getRequest(url);
        try {
            BitbucketPullRequestCommits commits = JsonParser.toJava(response, BitbucketPullRequestCommits.class);
            Iterator iterator = Util.fixNull(commits.getValues()).iterator();
            if (iterator.hasNext()) {
                BitbucketPullRequestCommit commit = (BitbucketPullRequestCommit)iterator.next();
                return commit;
            }
            throw new BitbucketException("Could not determine commit for pull request " + pull.getId());
        }
        catch (IOException e) {
            throw new IOException("I/O error when parsing response from URL: " + url, e);
        }
    }

    @Override
    public void registerCommitWebHook(@NonNull BitbucketWebHook hook) throws IOException, InterruptedException {
        String url = UriTemplate.fromTemplate((String)"https://api.bitbucket.org/2.0/repositories{/owner,repo}/hooks").set("owner", (Object)this.owner).set("repo", (Object)this.repositoryName).expand();
        this.postRequest(url, JsonParser.toJson(hook));
    }

    @Override
    public void updateCommitWebHook(@NonNull BitbucketWebHook hook) throws IOException, InterruptedException {
        String url = UriTemplate.fromTemplate((String)"https://api.bitbucket.org/2.0/repositories{/owner,repo}/hooks/{hook}").set("owner", (Object)this.owner).set("repo", (Object)this.repositoryName).set("hook", (Object)hook.getUuid()).expand();
        this.putRequest(url, JsonParser.toJson(hook));
    }

    @Override
    public void removeCommitWebHook(@NonNull BitbucketWebHook hook) throws IOException, InterruptedException {
        if (StringUtils.isBlank((String)hook.getUuid())) {
            throw new BitbucketException("Hook UUID required");
        }
        String url = UriTemplate.fromTemplate((String)"https://api.bitbucket.org/2.0/repositories{/owner,repo}/hooks/{uuid}").set("owner", (Object)this.owner).set("repo", (Object)this.repositoryName).set("uuid", (Object)hook.getUuid()).expand();
        this.deleteRequest(url);
    }

    @NonNull
    public List<BitbucketRepositoryHook> getWebHooks() throws IOException, InterruptedException {
        ArrayList<BitbucketRepositoryHook> repositoryHooks = new ArrayList<BitbucketRepositoryHook>();
        int pageNumber = 1;
        UriTemplate template = UriTemplate.fromTemplate((String)"https://api.bitbucket.org/2.0/repositories{/owner,repo}/hooks{?page,pagelen}").set("owner", (Object)this.owner).set("repo", (Object)this.repositoryName).set("page", (Object)pageNumber).set("pagelen", (Object)100);
        String url = template.expand();
        try {
            String response = this.getRequest(url);
            BitbucketRepositoryHooks page = this.parsePaginatedRepositoryHooks(response);
            repositoryHooks.addAll(page.getValues());
            while (page.getNext() != null) {
                if (Thread.interrupted()) {
                    throw new InterruptedException();
                }
                url = template.set("page", (Object)(++pageNumber)).expand();
                response = this.getRequest(url);
                page = this.parsePaginatedRepositoryHooks(response);
                repositoryHooks.addAll(page.getValues());
            }
            return repositoryHooks;
        }
        catch (IOException e) {
            throw new IOException("I/O error when parsing response from URL: " + url, e);
        }
    }

    @Override
    public void postBuildStatus(@NonNull BitbucketBuildStatus status) throws IOException, InterruptedException {
        String url = UriTemplate.fromTemplate((String)"https://api.bitbucket.org/2.0/repositories{/owner,repo}/commit/{hash}/statuses/build").set("owner", (Object)this.owner).set("repo", (Object)this.repositoryName).set("hash", (Object)status.getHash()).expand();
        this.postRequest(url, JsonParser.toJson(status));
    }

    @Override
    public boolean isPrivate() throws IOException, InterruptedException {
        return this.getRepository().isPrivate();
    }

    private BitbucketRepositoryHooks parsePaginatedRepositoryHooks(String response) throws IOException {
        BitbucketRepositoryHooks parsedResponse = JsonParser.toJava(response, BitbucketRepositoryHooks.class);
        return parsedResponse;
    }

    @Override
    @CheckForNull
    public BitbucketTeam getTeam() throws IOException, InterruptedException {
        String url = UriTemplate.fromTemplate((String)"https://api.bitbucket.org/2.0/workspaces{/owner}").set("owner", (Object)this.owner).expand();
        Callable<BitbucketTeam> request = () -> {
            try {
                String response = this.getRequest(url);
                return JsonParser.toJava(response, BitbucketCloudWorkspace.class);
            }
            catch (FileNotFoundException e) {
                return null;
            }
            catch (IOException e) {
                throw new IOException("I/O error when parsing response from URL: " + url, e);
            }
        };
        try {
            if (this.enableCache) {
                return cachedTeam.get(this.owner, request);
            }
            return request.call();
        }
        catch (Exception ex) {
            return null;
        }
    }

    @Override
    @CheckForNull
    public AvatarCacheSource.AvatarImage getTeamAvatar() throws IOException, InterruptedException {
        String url;
        BitbucketTeam team = this.getTeam();
        String string = url = team != null ? team.getLink("avatar") : null;
        if (url == null) {
            return AvatarCacheSource.AvatarImage.EMPTY;
        }
        Callable<AvatarCacheSource.AvatarImage> request = () -> {
            try {
                BufferedImage avatar = this.getImageRequest(url);
                return new AvatarCacheSource.AvatarImage(avatar, System.currentTimeMillis());
            }
            catch (FileNotFoundException e) {
                LOGGER.log(Level.FINE, "Failed to get avatar for team {0} from URL: " + url, team.getName());
            }
            catch (IOException e) {
                throw new IOException("I/O error when parsing response from URL: " + url, e);
            }
            return null;
        };
        try {
            if (this.enableCache) {
                return cachedAvatar.get(this.owner, request);
            }
            return request.call();
        }
        catch (Exception ex) {
            try {
                return null;
            }
            catch (Exception ex2) {
                LOGGER.log(Level.FINE, "Unexpected exception while loading team avatar: " + ex2.getMessage(), ex2);
                throw ex2;
            }
        }
    }

    @NonNull
    public List<BitbucketCloudRepository> getRepositories(@CheckForNull UserRoleInRepository role) throws InterruptedException, IOException {
        StringBuilder cacheKey = new StringBuilder();
        cacheKey.append(this.owner);
        if (this.authenticator != null) {
            cacheKey.append("::").append(this.authenticator.getId());
        } else {
            cacheKey.append("::<anonymous>");
        }
        UriTemplate template = UriTemplate.fromTemplate((String)"https://api.bitbucket.org/2.0/repositories{/owner}{?role,page,pagelen}").set("owner", (Object)this.owner).set("pagelen", (Object)100);
        if (role != null && this.authenticator != null) {
            template.set("role", (Object)role.getId());
            cacheKey.append("::").append(role.getId());
        }
        Callable<List> request = () -> {
            PaginatedBitbucketRepository page;
            ArrayList<BitbucketCloudRepository> repositories = new ArrayList<BitbucketCloudRepository>();
            Integer pageNumber = 1;
            do {
                String url = template.set("page", (Object)pageNumber).expand();
                String response = this.getRequest(url);
                try {
                    page = JsonParser.toJava(response, PaginatedBitbucketRepository.class);
                    repositories.addAll(page.getValues());
                }
                catch (IOException e) {
                    throw new IOException("I/O error when parsing response from URL: " + url, e);
                }
                Integer n = pageNumber;
                Integer n2 = pageNumber = Integer.valueOf(pageNumber + 1);
            } while (page.getNext() != null);
            repositories.sort(Comparator.comparing(BitbucketCloudRepository::getRepositoryName));
            return repositories;
        };
        try {
            if (this.enableCache) {
                return cachedRepositories.get(cacheKey.toString(), request);
            }
            return request.call();
        }
        catch (Exception ex) {
            throw new IOException("Error while loading repositories from cache", ex);
        }
    }

    @NonNull
    public List<BitbucketCloudRepository> getRepositories() throws IOException, InterruptedException {
        return this.getRepositories(null);
    }

    private void setClientProxyParams(String host, HttpClientBuilder builder) {
        Jenkins jenkins = Jenkins.getInstanceOrNull();
        ProxyConfiguration proxyConfig = null;
        if (jenkins != null) {
            proxyConfig = jenkins.proxy;
        }
        Proxy proxy = Proxy.NO_PROXY;
        if (proxyConfig != null) {
            proxy = proxyConfig.createProxy(host);
        }
        if (proxy.type() != Proxy.Type.DIRECT) {
            InetSocketAddress proxyAddress = (InetSocketAddress)proxy.address();
            LOGGER.fine("Jenkins proxy: " + proxy.address());
            HttpHost proxyHttpHost = new HttpHost(proxyAddress.getHostName(), proxyAddress.getPort());
            builder.setProxy(proxyHttpHost);
            String username = proxyConfig.getUserName();
            String password = proxyConfig.getPassword();
            if (username != null && !"".equals(username.trim())) {
                CredentialsProvider credentialsProvider;
                LOGGER.fine("Using proxy authentication (user=" + username + ")");
                if (this.context == null) {
                    this.context = HttpClientContext.create();
                }
                if ((credentialsProvider = this.context.getCredentialsProvider()) == null) {
                    credentialsProvider = new BasicCredentialsProvider();
                    this.context.setCredentialsProvider(credentialsProvider);
                }
                credentialsProvider.setCredentials(new AuthScope(proxyHttpHost), (Credentials)new UsernamePasswordCredentials(username, password));
                AuthCache authCache = this.context.getAuthCache();
                if (authCache == null) {
                    authCache = new BasicAuthCache();
                    this.context.setAuthCache(authCache);
                }
                authCache.put(proxyHttpHost, (AuthScheme)new BasicScheme());
            }
        }
    }

    @Restricted(value={ProtectedExternally.class})
    protected CloseableHttpResponse executeMethod(HttpRequestBase httpMethod) throws InterruptedException, IOException {
        return this.executeMethod(API_HOST, httpMethod);
    }

    @Restricted(value={ProtectedExternally.class})
    protected CloseableHttpResponse executeMethod(HttpHost host, HttpRequestBase httpMethod) throws InterruptedException, IOException {
        HttpClientContext requestContext = null;
        if (API_HOST.equals((Object)host)) {
            requestContext = this.context;
            if (this.authenticator != null) {
                this.authenticator.configureRequest((HttpRequest)httpMethod);
            }
        }
        RequestConfig.Builder requestConfig = RequestConfig.custom();
        requestConfig.setConnectTimeout(10000);
        requestConfig.setConnectionRequestTimeout(60000);
        requestConfig.setSocketTimeout(60000);
        httpMethod.setConfig(requestConfig.build());
        CloseableHttpResponse response = this.client.execute(host, (HttpRequest)httpMethod, (HttpContext)requestContext);
        while (response.getStatusLine().getStatusCode() == 429) {
            this.release(httpMethod);
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            LOGGER.fine("Bitbucket Cloud API rate limit reached, sleeping for 5 sec then retry...");
            Thread.sleep(5000L);
            response = this.client.execute(host, (HttpRequest)httpMethod, (HttpContext)requestContext);
        }
        return response;
    }

    private InputStream getRequestAsInputStream(String path) throws IOException, InterruptedException {
        HttpGet httpget = new HttpGet(path);
        HttpHost host = null;
        try {
            URI uri = new URI(path);
            if (uri.isAbsolute() && !uri.isOpaque()) {
                host = HttpHost.create((String)("" + uri.getScheme() + "://" + uri.getAuthority()));
            }
        }
        catch (URISyntaxException uri) {
            // empty catch block
        }
        if (host == null) {
            host = API_HOST;
        }
        try {
            CloseableHttpResponse response = this.executeMethod(host, (HttpRequestBase)httpget);
            if (response.getStatusLine().getStatusCode() == 404) {
                EntityUtils.consume((HttpEntity)response.getEntity());
                response.close();
                throw new FileNotFoundException("URL: " + path);
            }
            if (response.getStatusLine().getStatusCode() != 200) {
                String content = IOUtils.toString((InputStream)response.getEntity().getContent());
                int statusCode = response.getStatusLine().getStatusCode();
                String status = response.getStatusLine().getReasonPhrase();
                EntityUtils.consume((HttpEntity)response.getEntity());
                response.close();
                throw new BitbucketRequestException(statusCode, "HTTP request error. Status: " + statusCode + ": " + status + ".\n" + content);
            }
            return new ClosingConnectionInputStream(response, (HttpRequestBase)httpget, connectionManager);
        }
        catch (BitbucketRequestException | FileNotFoundException e) {
            throw e;
        }
        catch (IOException e) {
            throw new IOException("Communication error for url: " + path, e);
        }
    }

    private String getRequest(String path) throws IOException, InterruptedException {
        try (InputStream inputStream = this.getRequestAsInputStream(path);){
            String string = IOUtils.toString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8);
            return string;
        }
    }

    private BufferedImage getImageRequest(String path) throws IOException, InterruptedException {
        try (InputStream inputStream = this.getRequestAsInputStream(path);){
            BufferedImage image;
            int length = 16384;
            BufferedInputStream bis = new BufferedInputStream(inputStream, length);
            BufferedImage bufferedImage = image = ImageIO.read(bis);
            return bufferedImage;
        }
    }

    /*
     * Exception decompiling
     */
    private int headRequestStatus(String path) throws IOException, InterruptedException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void deleteRequest(String path) throws IOException, InterruptedException {
        HttpDelete httppost = new HttpDelete(path);
        try (CloseableHttpResponse response = this.executeMethod((HttpRequestBase)httppost);){
            EntityUtils.consume((HttpEntity)response.getEntity());
            if (response.getStatusLine().getStatusCode() == 404) {
                throw new FileNotFoundException("URL: " + path);
            }
            if (response.getStatusLine().getStatusCode() != 204) {
                throw new BitbucketRequestException(response.getStatusLine().getStatusCode(), "HTTP request error. Status: " + response.getStatusLine().getStatusCode() + ": " + response.getStatusLine().getReasonPhrase());
            }
        }
        catch (BitbucketRequestException e) {
            throw e;
        }
        catch (IOException e) {
            throw new IOException("Communication error for url: " + path, e);
        }
        finally {
            this.release((HttpRequestBase)httppost);
        }
    }

    /*
     * Exception decompiling
     */
    private String doRequest(HttpRequestBase httppost) throws IOException, InterruptedException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void release(HttpRequestBase method) {
        method.releaseConnection();
        connectionManager.closeExpiredConnections();
    }

    private String getResponseContent(CloseableHttpResponse response) throws IOException {
        String content;
        long len = response.getEntity().getContentLength();
        if (len == 0L) {
            content = "";
        } else {
            ByteArrayOutputStream buf = len > 0L && len <= 0x3FFFFFFFL ? new ByteArrayOutputStream((int)len) : new ByteArrayOutputStream();
            try (InputStream is = response.getEntity().getContent();){
                IOUtils.copy((InputStream)is, (OutputStream)buf);
            }
            content = new String(buf.toByteArray(), StandardCharsets.UTF_8);
        }
        return content;
    }

    private String putRequest(String path, String content) throws IOException, InterruptedException {
        HttpPut request = new HttpPut(path);
        request.setEntity((HttpEntity)new StringEntity(content, ContentType.create((String)"application/json", (String)"UTF-8")));
        return this.doRequest((HttpRequestBase)request);
    }

    private String postRequest(String path, String content) throws IOException, InterruptedException {
        HttpPost httppost = new HttpPost(path);
        httppost.setEntity((HttpEntity)new StringEntity(content, ContentType.create((String)"application/json", (String)"UTF-8")));
        return this.doRequest((HttpRequestBase)httppost);
    }

    private String postRequest(String path, List<? extends NameValuePair> params) throws IOException, InterruptedException {
        HttpPost httppost = new HttpPost(path);
        httppost.setEntity((HttpEntity)new UrlEncodedFormEntity(params));
        return this.doRequest((HttpRequestBase)httppost);
    }

    private List<BitbucketCloudBranch> getAllBranches(String response) throws IOException, InterruptedException {
        ArrayList branches = new ArrayList();
        BitbucketCloudPage page = (BitbucketCloudPage)JsonParser.mapper.readValue(response, (TypeReference)new TypeReference<BitbucketCloudPage<BitbucketCloudBranch>>(){});
        branches.addAll(page.getValues());
        while (!page.isLastPage()) {
            response = this.getRequest(page.getNext());
            page = (BitbucketCloudPage)JsonParser.mapper.readValue(response, (TypeReference)new TypeReference<BitbucketCloudPage<BitbucketCloudBranch>>(){});
            branches.addAll(page.getValues());
        }
        ArrayList<BitbucketCloudBranch> activeBranches = new ArrayList<BitbucketCloudBranch>();
        for (BitbucketCloudBranch branch : branches) {
            if (!branch.isActive()) continue;
            activeBranches.add(branch);
        }
        return activeBranches;
    }

    @Override
    public Iterable<SCMFile> getDirectoryContent(BitbucketSCMFile parent) throws IOException, InterruptedException {
        String url = UriTemplate.fromTemplate((String)"https://api.bitbucket.org/2.0/repositories{/owner,repo}/src{/branchOrHash,path}").set("owner", (Object)this.owner).set("repo", (Object)this.repositoryName).set("branchOrHash", (Object)parent.getHash()).set("path", (Object)parent.getPath()).expand();
        ArrayList<SCMFile> result = new ArrayList<SCMFile>();
        String response = this.getRequest(url);
        BitbucketCloudPage page = (BitbucketCloudPage)JsonParser.mapper.readValue(response, (TypeReference)new TypeReference<BitbucketCloudPage<BitbucketRepositorySource>>(){});
        for (BitbucketRepositorySource source : page.getValues()) {
            result.add(source.toBitbucketScmFile(parent));
        }
        while (!page.isLastPage()) {
            response = this.getRequest(page.getNext());
            page = (BitbucketCloudPage)JsonParser.mapper.readValue(response, (TypeReference)new TypeReference<BitbucketCloudPage<BitbucketRepositorySource>>(){});
            for (BitbucketRepositorySource source : page.getValues()) {
                result.add(source.toBitbucketScmFile(parent));
            }
        }
        return result;
    }

    @Override
    public InputStream getFileContent(BitbucketSCMFile file) throws IOException, InterruptedException {
        String url = UriTemplate.fromTemplate((String)"https://api.bitbucket.org/2.0/repositories{/owner,repo}/src{/branchOrHash,path}").set("owner", (Object)this.owner).set("repo", (Object)this.repositoryName).set("branchOrHash", (Object)file.getHash()).set("path", (Object)file.getPath()).expand();
        return this.getRequestAsInputStream(url);
    }

    static {
        connectionManager.setDefaultMaxPerRoute(20);
        connectionManager.setMaxTotal(22);
        connectionManager.setSocketConfig(API_HOST, SocketConfig.custom().setSoTimeout(60000).build());
    }

    private class CommitClosure
    implements Callable<BitbucketCommit> {
        private final String hash;

        public CommitClosure(String hash) {
            this.hash = hash;
        }

        @Override
        public BitbucketCommit call() throws Exception {
            return BitbucketCloudApiClient.this.resolveCommit(this.hash);
        }
    }
}

