/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.plugins.bitbucket.api.credentials;

import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketAuthenticator;
import com.cloudbees.plugins.credentials.common.StandardCredentials;
import com.cloudbees.plugins.credentials.common.StandardUsernamePasswordCredentials;
import hudson.util.Secret;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.AuthCache;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.BasicAuthCache;
import org.apache.http.impl.client.BasicCredentialsProvider;

public class BitbucketUsernamePasswordAuthenticator
extends BitbucketAuthenticator {
    private static final Logger LOGGER = Logger.getLogger(BitbucketUsernamePasswordAuthenticator.class.getName());
    private final UsernamePasswordCredentials httpCredentials;

    public BitbucketUsernamePasswordAuthenticator(StandardUsernamePasswordCredentials credentials) {
        super((StandardCredentials)credentials);
        this.httpCredentials = new UsernamePasswordCredentials(credentials.getUsername(), Secret.toString((Secret)credentials.getPassword()));
    }

    @Override
    public void configureContext(HttpClientContext context, HttpHost host) {
        BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
        credentialsProvider.setCredentials(new AuthScope(host), (Credentials)this.httpCredentials);
        BasicAuthCache authCache = new BasicAuthCache();
        LOGGER.log(Level.FINE, "Add host={0} to authCache.", host);
        authCache.put(host, (AuthScheme)new BasicScheme());
        context.setCredentialsProvider((CredentialsProvider)credentialsProvider);
        context.setAuthCache((AuthCache)authCache);
    }
}

