/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.plugins.bitbucket;

import com.cloudbees.jenkins.plugins.bitbucket.BitbucketSCMSource;
import com.cloudbees.jenkins.plugins.bitbucket.BranchSCMHead;
import com.cloudbees.jenkins.plugins.bitbucket.PullRequestAction;
import com.cloudbees.jenkins.plugins.bitbucket.PullRequestSCMHead;
import com.cloudbees.jenkins.plugins.bitbucket.PullRequestSCMRevision;
import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketApi;
import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketApiFactory;
import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketPullRequest;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import java.io.IOException;
import java.io.ObjectStreamException;
import java.lang.ref.SoftReference;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.plugins.git.AbstractGitSCMSource;
import jenkins.scm.api.SCMHead;
import jenkins.scm.api.SCMHeadMigration;
import jenkins.scm.api.SCMRevision;
import jenkins.scm.api.mixin.ChangeRequestCheckoutStrategy;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Deprecated
public class SCMHeadWithOwnerAndRepo
extends SCMHead {
    private static final Logger LOGGER = Logger.getLogger(SCMHeadWithOwnerAndRepo.class.getName());
    private static final Map<BitbucketSCMSource, SoftReference<Map<String, String>>> cache = new WeakHashMap<BitbucketSCMSource, SoftReference<Map<String, String>>>();
    private static final long serialVersionUID = 1L;
    private final String repoOwner;
    private final String repoName;
    private transient PullRequestAction metadata;

    public SCMHeadWithOwnerAndRepo(String repoOwner, String repoName, String branchName) {
        super(branchName);
        this.repoOwner = repoOwner;
        this.repoName = repoName;
    }

    private Object readResolve() throws ObjectStreamException {
        if (this.metadata != null) {
            return new PR(this.repoOwner, this.repoName, this.getName(), this.metadata.getId(), new BranchSCMHead("\u0000"));
        }
        return new BranchSCMHead(this.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<String, String> getTargets(BitbucketSCMSource source) {
        Map<BitbucketSCMSource, SoftReference<Map<String, String>>> map = cache;
        synchronized (map) {
            Map<String, String> targets;
            SoftReference<Map<String, String>> ref = cache.get((Object)source);
            Map<String, String> map2 = targets = ref == null ? null : ref.get();
            if (targets != null) {
                return targets;
            }
        }
        HashMap<String, String> targets = new HashMap<String, String>();
        try {
            BitbucketApi bitbucket = BitbucketApiFactory.newInstance(source.getServerUrl(), source.authenticator(), source.getRepoOwner(), source.getRepository());
            for (BitbucketPullRequest bitbucketPullRequest : bitbucket.getPullRequests()) {
                targets.put(bitbucketPullRequest.getId(), bitbucketPullRequest.getDestination().getBranch().getName());
            }
        }
        catch (IOException | InterruptedException | RuntimeException e) {
            LOGGER.log(Level.FINE, "Cannot resolve pull request targets", e);
        }
        Map<BitbucketSCMSource, SoftReference<Map<String, String>>> map3 = cache;
        synchronized (map3) {
            cache.put(source, new SoftReference(targets));
        }
        return targets;
    }

    @Restricted(value={NoExternalUse.class})
    @Extension
    public static class GitMigrationImpl
    extends SCMHeadMigration<BitbucketSCMSource, PR, AbstractGitSCMSource.SCMRevisionImpl> {
        public GitMigrationImpl() {
            super(BitbucketSCMSource.class, PR.class, AbstractGitSCMSource.SCMRevisionImpl.class);
        }

        public PullRequestSCMHead migrate(@NonNull BitbucketSCMSource source, @NonNull PR head) {
            Map targets = SCMHeadWithOwnerAndRepo.getTargets(source);
            String target = (String)targets.get(head.getId());
            if (target == null) {
                LOGGER.log(Level.WARNING, "Could not determine target branch for PR {0}. This may result in a rebuild", head.getId());
                target = "\u0000";
            }
            return new PullRequestSCMHead(head.getName(), head.getRepoOwner(), head.getRepository(), head.getBranchName(), head.getId(), head.getTitle(), new BranchSCMHead(target), source.originOf(head.getRepoOwner(), head.getRepository()), ChangeRequestCheckoutStrategy.HEAD);
        }

        public SCMRevision migrate(@NonNull BitbucketSCMSource source, @NonNull AbstractGitSCMSource.SCMRevisionImpl revision) {
            PullRequestSCMHead head = this.migrate(source, (PR)revision.getHead());
            return head != null ? new PullRequestSCMRevision<AbstractGitSCMSource.SCMRevisionImpl>(head, new AbstractGitSCMSource.SCMRevisionImpl(head.getTarget(), null), new AbstractGitSCMSource.SCMRevisionImpl((SCMHead)head, revision.getHash())) : null;
        }
    }

    @Deprecated
    @Restricted(value={NoExternalUse.class})
    public static class PR
    extends PullRequestSCMHead {
        public PR(String repoOwner, String repository, String branchName, String number, BranchSCMHead target) {
            super(repoOwner, repository, branchName, number, target, null);
        }
    }
}

