/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.plugins.bitbucket;

import com.cloudbees.jenkins.plugins.bitbucket.BitbucketCredentials;
import com.cloudbees.jenkins.plugins.bitbucket.BitbucketDefaultBranch;
import com.cloudbees.jenkins.plugins.bitbucket.BitbucketGitSCMBuilder;
import com.cloudbees.jenkins.plugins.bitbucket.BitbucketGitSCMRevision;
import com.cloudbees.jenkins.plugins.bitbucket.BitbucketLink;
import com.cloudbees.jenkins.plugins.bitbucket.BitbucketRepoMetadataAction;
import com.cloudbees.jenkins.plugins.bitbucket.BitbucketSCMSourceContext;
import com.cloudbees.jenkins.plugins.bitbucket.BitbucketSCMSourceRequest;
import com.cloudbees.jenkins.plugins.bitbucket.BitbucketTagSCMHead;
import com.cloudbees.jenkins.plugins.bitbucket.BitbucketTagSCMRevision;
import com.cloudbees.jenkins.plugins.bitbucket.BranchDiscoveryTrait;
import com.cloudbees.jenkins.plugins.bitbucket.BranchSCMHead;
import com.cloudbees.jenkins.plugins.bitbucket.ForkPullRequestDiscoveryTrait;
import com.cloudbees.jenkins.plugins.bitbucket.LazyIterable;
import com.cloudbees.jenkins.plugins.bitbucket.Messages;
import com.cloudbees.jenkins.plugins.bitbucket.OriginPullRequestDiscoveryTrait;
import com.cloudbees.jenkins.plugins.bitbucket.PublicRepoPullRequestFilterTrait;
import com.cloudbees.jenkins.plugins.bitbucket.PullRequestSCMHead;
import com.cloudbees.jenkins.plugins.bitbucket.PullRequestSCMRevision;
import com.cloudbees.jenkins.plugins.bitbucket.SSHCheckoutTrait;
import com.cloudbees.jenkins.plugins.bitbucket.WebhookRegistration;
import com.cloudbees.jenkins.plugins.bitbucket.WebhookRegistrationTrait;
import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketApi;
import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketApiFactory;
import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketAuthenticator;
import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketBranch;
import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketCommit;
import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketHref;
import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketPullRequest;
import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketRepository;
import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketRepositoryProtocol;
import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketRepositoryType;
import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketRequestException;
import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketTeam;
import com.cloudbees.jenkins.plugins.bitbucket.client.BitbucketCloudApiClient;
import com.cloudbees.jenkins.plugins.bitbucket.client.repository.UserRoleInRepository;
import com.cloudbees.jenkins.plugins.bitbucket.endpoints.AbstractBitbucketEndpoint;
import com.cloudbees.jenkins.plugins.bitbucket.endpoints.BitbucketCloudEndpoint;
import com.cloudbees.jenkins.plugins.bitbucket.endpoints.BitbucketEndpointConfiguration;
import com.cloudbees.jenkins.plugins.bitbucket.hooks.HasPullRequests;
import com.cloudbees.jenkins.plugins.bitbucket.hooks.HasRefsChangedRequest;
import com.cloudbees.plugins.credentials.Credentials;
import com.cloudbees.plugins.credentials.CredentialsNameProvider;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardCredentials;
import com.damnhandy.uri.template.UriTemplate;
import com.fasterxml.jackson.databind.util.StdDateFormat;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Extension;
import hudson.RestrictedSince;
import hudson.Util;
import hudson.console.HyperlinkNote;
import hudson.model.Action;
import hudson.model.Actionable;
import hudson.model.Item;
import hudson.model.TaskListener;
import hudson.plugins.git.GitSCM;
import hudson.scm.SCM;
import hudson.util.FormFillFailure;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.io.IOException;
import java.io.ObjectStreamException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.authentication.tokens.api.AuthenticationTokens;
import jenkins.model.Jenkins;
import jenkins.plugins.git.AbstractGitSCMSource;
import jenkins.plugins.git.traits.GitBrowserSCMSourceTrait;
import jenkins.scm.api.SCMHead;
import jenkins.scm.api.SCMHeadCategory;
import jenkins.scm.api.SCMHeadEvent;
import jenkins.scm.api.SCMHeadObserver;
import jenkins.scm.api.SCMHeadOrigin;
import jenkins.scm.api.SCMRevision;
import jenkins.scm.api.SCMSource;
import jenkins.scm.api.SCMSourceCriteria;
import jenkins.scm.api.SCMSourceDescriptor;
import jenkins.scm.api.SCMSourceEvent;
import jenkins.scm.api.SCMSourceOwner;
import jenkins.scm.api.metadata.ContributorMetadataAction;
import jenkins.scm.api.metadata.ObjectMetadataAction;
import jenkins.scm.api.metadata.PrimaryInstanceMetadataAction;
import jenkins.scm.api.mixin.ChangeRequestCheckoutStrategy;
import jenkins.scm.api.mixin.ChangeRequestSCMHead2;
import jenkins.scm.api.trait.SCMHeadAuthority;
import jenkins.scm.api.trait.SCMSourceRequest;
import jenkins.scm.api.trait.SCMSourceTrait;
import jenkins.scm.api.trait.SCMSourceTraitDescriptor;
import jenkins.scm.impl.ChangeRequestSCMHeadCategory;
import jenkins.scm.impl.TagSCMHeadCategory;
import jenkins.scm.impl.UncategorizedSCMHeadCategory;
import jenkins.scm.impl.form.NamedArrayList;
import jenkins.scm.impl.trait.Discovery;
import jenkins.scm.impl.trait.Selection;
import jenkins.scm.impl.trait.WildcardSCMHeadFilterTrait;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.WordUtils;
import org.jenkinsci.Symbol;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;

public class BitbucketSCMSource
extends SCMSource {
    private static final Logger LOGGER = Logger.getLogger(BitbucketSCMSource.class.getName());
    private static final String CLOUD_REPO_TEMPLATE = "{/owner,repo}";
    private static final String SERVER_REPO_TEMPLATE = "/projects{/owner}/repos{/repo}";
    private static int eventDelaySeconds = Math.min(300, Math.max(0, Integer.getInteger(BitbucketSCMSource.class.getName() + ".eventDelaySeconds", 5)));
    @NonNull
    private String serverUrl = "https://bitbucket.org";
    @CheckForNull
    private String credentialsId;
    @NonNull
    private final String repoOwner;
    @NonNull
    private final String repository;
    @NonNull
    private List<SCMSourceTrait> traits;
    @Deprecated
    @Restricted(value={NoExternalUse.class})
    @RestrictedSince(value="2.2.0")
    private transient String checkoutCredentialsId;
    @Deprecated
    @Restricted(value={NoExternalUse.class})
    @RestrictedSince(value="2.2.0")
    private transient String includes;
    @Deprecated
    @Restricted(value={NoExternalUse.class})
    @RestrictedSince(value="2.2.0")
    private transient String excludes;
    @Deprecated
    @Restricted(value={NoExternalUse.class})
    @RestrictedSince(value="2.2.0")
    private transient boolean autoRegisterHook;
    @Deprecated
    @Restricted(value={NoExternalUse.class})
    @RestrictedSince(value="2.2.0")
    private transient String bitbucketServerUrl;
    @CheckForNull
    private transient BitbucketRepositoryType repositoryType;
    @CheckForNull
    private transient Map<String, String> pullRequestTitleCache;
    @CheckForNull
    private transient Map<String, ContributorMetadataAction> pullRequestContributorCache;
    @CheckForNull
    private transient List<BitbucketHref> cloneLinks = null;
    @CheckForNull
    private transient BitbucketRepository bitbucketRepository = null;

    @DataBoundConstructor
    public BitbucketSCMSource(@NonNull String repoOwner, @NonNull String repository) {
        this.repoOwner = repoOwner;
        this.repository = repository;
        this.traits = new ArrayList<SCMSourceTrait>();
    }

    @Deprecated
    public BitbucketSCMSource(@CheckForNull String id, @NonNull String repoOwner, @NonNull String repository) {
        this(repoOwner, repository);
        this.setId(id);
        this.traits.add(new BranchDiscoveryTrait(true, true));
        this.traits.add(new OriginPullRequestDiscoveryTrait(EnumSet.of(ChangeRequestCheckoutStrategy.MERGE)));
        this.traits.add(new ForkPullRequestDiscoveryTrait(EnumSet.of(ChangeRequestCheckoutStrategy.MERGE), (SCMHeadAuthority<? super BitbucketSCMSourceRequest, ? extends ChangeRequestSCMHead2, ? extends SCMRevision>)new ForkPullRequestDiscoveryTrait.TrustTeamForks()));
    }

    @SuppressFBWarnings(value={"RCN_REDUNDANT_NULLCHECK_OF_NONNULL_VALUE"}, justification="Only non-null after we set them here!")
    private Object readResolve() throws ObjectStreamException {
        if (this.serverUrl == null) {
            this.serverUrl = BitbucketEndpointConfiguration.get().readResolveServerUrl(this.bitbucketServerUrl);
        }
        if (this.serverUrl == null) {
            LOGGER.log(Level.WARNING, "BitbucketSCMSource::readResolve : serverUrl is still empty");
        }
        if (this.traits == null) {
            this.traits = new ArrayList<SCMSourceTrait>();
            if (!"*".equals(this.includes) || !"".equals(this.excludes)) {
                this.traits.add((SCMSourceTrait)new WildcardSCMHeadFilterTrait(this.includes, this.excludes));
            }
            if (this.checkoutCredentialsId != null && !"SAME".equals(this.checkoutCredentialsId) && !this.checkoutCredentialsId.equals(this.credentialsId)) {
                this.traits.add(new SSHCheckoutTrait(this.checkoutCredentialsId));
            }
            this.traits.add(new WebhookRegistrationTrait(this.autoRegisterHook ? WebhookRegistration.ITEM : WebhookRegistration.DISABLE));
            this.traits.add(new BranchDiscoveryTrait(true, true));
            this.traits.add(new OriginPullRequestDiscoveryTrait(EnumSet.of(ChangeRequestCheckoutStrategy.HEAD)));
            this.traits.add(new ForkPullRequestDiscoveryTrait(EnumSet.of(ChangeRequestCheckoutStrategy.HEAD), (SCMHeadAuthority<? super BitbucketSCMSourceRequest, ? extends ChangeRequestSCMHead2, ? extends SCMRevision>)new ForkPullRequestDiscoveryTrait.TrustEveryone()));
            this.traits.add(new PublicRepoPullRequestFilterTrait());
        }
        return this;
    }

    @CheckForNull
    public String getCredentialsId() {
        return this.credentialsId;
    }

    @DataBoundSetter
    public void setCredentialsId(@CheckForNull String credentialsId) {
        this.credentialsId = Util.fixEmpty((String)credentialsId);
    }

    @NonNull
    public String getRepoOwner() {
        return this.repoOwner;
    }

    @NonNull
    public String getRepository() {
        return this.repository;
    }

    @NonNull
    public String getServerUrl() {
        return this.serverUrl;
    }

    @DataBoundSetter
    public void setServerUrl(@CheckForNull String serverUrl) {
        this.serverUrl = BitbucketEndpointConfiguration.normalizeServerUrl(serverUrl);
    }

    @NonNull
    public String getEndpointJenkinsRootUrl() {
        return AbstractBitbucketEndpoint.getEndpointJenkinsRootUrl(this.serverUrl);
    }

    @NonNull
    public List<SCMSourceTrait> getTraits() {
        return Collections.unmodifiableList(this.traits);
    }

    @DataBoundSetter
    public void setTraits(@CheckForNull List<SCMSourceTrait> traits) {
        this.traits = new ArrayList<SCMSourceTrait>(Util.fixNull(traits));
    }

    @Deprecated
    @Restricted(value={NoExternalUse.class})
    @DataBoundSetter
    @RestrictedSince(value="2.2.0")
    public void setBitbucketServerUrl(String url) {
        url = BitbucketEndpointConfiguration.normalizeServerUrl(url);
        AbstractBitbucketEndpoint endpoint = BitbucketEndpointConfiguration.get().findEndpoint(url);
        if (endpoint != null) {
            this.setServerUrl(endpoint.getServerUrl());
            return;
        }
        LOGGER.log(Level.WARNING, "Call to legacy setBitbucketServerUrl({0}) method is configuring a url missing from the global configuration.", url);
        this.setServerUrl(url);
    }

    @Deprecated
    @Restricted(value={NoExternalUse.class})
    @RestrictedSince(value="2.2.0")
    @CheckForNull
    public String getBitbucketServerUrl() {
        String serverUrl = this.getServerUrl();
        if (BitbucketEndpointConfiguration.get().findEndpoint(serverUrl) instanceof BitbucketCloudEndpoint) {
            return null;
        }
        return serverUrl;
    }

    @Deprecated
    @Restricted(value={NoExternalUse.class})
    @RestrictedSince(value="2.2.0")
    @CheckForNull
    public String getCheckoutCredentialsId() {
        for (SCMSourceTrait t : this.traits) {
            if (!(t instanceof SSHCheckoutTrait)) continue;
            return StringUtils.defaultString((String)((SSHCheckoutTrait)t).getCredentialsId(), (String)"ANONYMOUS");
        }
        return "SAME";
    }

    @Deprecated
    @Restricted(value={NoExternalUse.class})
    @DataBoundSetter
    @RestrictedSince(value="2.2.0")
    public void setCheckoutCredentialsId(String checkoutCredentialsId) {
        this.traits.removeIf(trait -> trait instanceof SSHCheckoutTrait);
        if (checkoutCredentialsId != null && !"SAME".equals(checkoutCredentialsId)) {
            this.traits.add(new SSHCheckoutTrait(checkoutCredentialsId));
        }
    }

    @Deprecated
    @Restricted(value={NoExternalUse.class})
    @RestrictedSince(value="2.2.0")
    @NonNull
    public String getIncludes() {
        for (SCMSourceTrait trait : this.traits) {
            if (!(trait instanceof WildcardSCMHeadFilterTrait)) continue;
            return ((WildcardSCMHeadFilterTrait)trait).getIncludes();
        }
        return "*";
    }

    @Deprecated
    @Restricted(value={NoExternalUse.class})
    @DataBoundSetter
    @RestrictedSince(value="2.2.0")
    public void setIncludes(@NonNull String includes) {
        for (int i = 0; i < this.traits.size(); ++i) {
            SCMSourceTrait trait = this.traits.get(i);
            if (!(trait instanceof WildcardSCMHeadFilterTrait)) continue;
            WildcardSCMHeadFilterTrait existing = (WildcardSCMHeadFilterTrait)trait;
            if ("*".equals(includes) && "".equals(existing.getExcludes())) {
                this.traits.remove(i);
            } else {
                this.traits.set(i, (SCMSourceTrait)new WildcardSCMHeadFilterTrait(includes, existing.getExcludes()));
            }
            return;
        }
        if (!"*".equals(includes)) {
            this.traits.add((SCMSourceTrait)new WildcardSCMHeadFilterTrait(includes, ""));
        }
    }

    @Deprecated
    @Restricted(value={NoExternalUse.class})
    @RestrictedSince(value="2.2.0")
    @NonNull
    public String getExcludes() {
        for (SCMSourceTrait trait : this.traits) {
            if (!(trait instanceof WildcardSCMHeadFilterTrait)) continue;
            return ((WildcardSCMHeadFilterTrait)trait).getExcludes();
        }
        return "";
    }

    @Deprecated
    @Restricted(value={NoExternalUse.class})
    @DataBoundSetter
    @RestrictedSince(value="2.2.0")
    public void setExcludes(@NonNull String excludes) {
        for (int i = 0; i < this.traits.size(); ++i) {
            SCMSourceTrait trait = this.traits.get(i);
            if (!(trait instanceof WildcardSCMHeadFilterTrait)) continue;
            WildcardSCMHeadFilterTrait existing = (WildcardSCMHeadFilterTrait)trait;
            if ("*".equals(existing.getIncludes()) && "".equals(excludes)) {
                this.traits.remove(i);
            } else {
                this.traits.set(i, (SCMSourceTrait)new WildcardSCMHeadFilterTrait(existing.getIncludes(), excludes));
            }
            return;
        }
        if (!"".equals(excludes)) {
            this.traits.add((SCMSourceTrait)new WildcardSCMHeadFilterTrait("*", excludes));
        }
    }

    @Deprecated
    @Restricted(value={NoExternalUse.class})
    @DataBoundSetter
    @RestrictedSince(value="2.2.0")
    public void setAutoRegisterHook(boolean autoRegisterHook) {
        this.traits.removeIf(trait -> trait instanceof WebhookRegistrationTrait);
        this.traits.add(new WebhookRegistrationTrait(autoRegisterHook ? WebhookRegistration.ITEM : WebhookRegistration.DISABLE));
    }

    @Deprecated
    @Restricted(value={NoExternalUse.class})
    @RestrictedSince(value="2.2.0")
    public boolean isAutoRegisterHook() {
        for (SCMSourceTrait t : this.traits) {
            if (!(t instanceof WebhookRegistrationTrait)) continue;
            return ((WebhookRegistrationTrait)t).getMode() != WebhookRegistration.DISABLE;
        }
        return true;
    }

    public BitbucketRepositoryType getRepositoryType() throws IOException, InterruptedException {
        if (this.repositoryType == null) {
            BitbucketRepository r = this.getBitbucketRepository();
            this.repositoryType = BitbucketRepositoryType.fromString(r.getScm());
            Map<String, List<BitbucketHref>> links = r.getLinks();
            if (links != null && links.containsKey("clone")) {
                this.cloneLinks = links.get("clone");
            }
        }
        return this.repositoryType;
    }

    public BitbucketApi buildBitbucketClient() {
        return this.buildBitbucketClient(this.repoOwner, this.repository);
    }

    public BitbucketApi buildBitbucketClient(PullRequestSCMHead head) {
        return this.buildBitbucketClient(head.getRepoOwner(), head.getRepository());
    }

    public BitbucketApi buildBitbucketClient(String repoOwner, String repository) {
        return BitbucketApiFactory.newInstance(this.getServerUrl(), this.authenticator(), repoOwner, repository);
    }

    private BitbucketRepository getBitbucketRepository() throws IOException, InterruptedException {
        if (this.bitbucketRepository == null) {
            this.bitbucketRepository = this.buildBitbucketClient().getRepository();
        }
        return this.bitbucketRepository;
    }

    public void afterSave() {
        try {
            this.getRepositoryType();
        }
        catch (IOException | InterruptedException e) {
            LOGGER.log(Level.FINE, "Could not determine repository type of " + this.getRepoOwner() + "/" + this.getRepository() + " on " + this.getServerUrl() + " for " + this.getOwner(), e);
        }
    }

    protected void retrieve(@CheckForNull SCMSourceCriteria criteria, @NonNull SCMHeadObserver observer, final @CheckForNull SCMHeadEvent<?> event, @NonNull TaskListener listener) throws IOException, InterruptedException {
        try (BitbucketSCMSourceRequest request = ((BitbucketSCMSourceContext)new BitbucketSCMSourceContext(criteria, observer).withTraits(this.traits)).newRequest(this, listener);){
            StandardCredentials scanCredentials = this.credentials();
            if (scanCredentials == null) {
                listener.getLogger().format("Connecting to %s with no credentials, anonymous access%n", this.getServerUrl());
            } else {
                listener.getLogger().format("Connecting to %s using %s%n", this.getServerUrl(), CredentialsNameProvider.name((Credentials)scanCredentials));
            }
            listener.getLogger().format("Repository type: %s%n", WordUtils.capitalizeFully((String)this.getRepositoryType().name()));
            if (request.isFetchPRs()) {
                request.setPullRequests((Iterable<BitbucketPullRequest>)new LazyIterable<BitbucketPullRequest>(){

                    @Override
                    protected Iterable<BitbucketPullRequest> create() {
                        try {
                            if (event instanceof HasPullRequests) {
                                HasPullRequests hasPrEvent = (HasPullRequests)event;
                                return hasPrEvent.getPullRequests(BitbucketSCMSource.this);
                            }
                            return BitbucketSCMSource.this.buildBitbucketClient().getPullRequests();
                        }
                        catch (IOException | InterruptedException e) {
                            throw new WrappedException(e);
                        }
                    }
                });
            }
            if (request.isFetchBranches()) {
                request.setBranches((Iterable<BitbucketBranch>)new LazyIterable<BitbucketBranch>(){

                    @Override
                    protected Iterable<BitbucketBranch> create() {
                        try {
                            if (event != null) {
                                TreeSet<BitbucketBranch> branches = new TreeSet<BitbucketBranch>((a, b) -> a.getName().compareTo(b.getName()));
                                if (event instanceof HasRefsChangedRequest) {
                                    HasRefsChangedRequest hasRefsChangedRequest = (HasRefsChangedRequest)event;
                                    hasRefsChangedRequest.getBranches(BitbucketSCMSource.this).forEach(b -> branches.add((BitbucketBranch)b));
                                }
                                if (event instanceof HasPullRequests) {
                                    HasPullRequests hasPrEvent = (HasPullRequests)event;
                                    hasPrEvent.getPullRequests(BitbucketSCMSource.this).forEach(pr -> {
                                        branches.add(pr.getSource().getBranch());
                                        branches.add(pr.getDestination().getBranch());
                                    });
                                }
                                return branches;
                            }
                            return BitbucketSCMSource.this.buildBitbucketClient().getBranches();
                        }
                        catch (IOException | InterruptedException e) {
                            throw new WrappedException(e);
                        }
                    }
                });
            }
            if (request.isFetchTags()) {
                request.setTags((Iterable<BitbucketBranch>)new LazyIterable<BitbucketBranch>(){

                    @Override
                    protected Iterable<BitbucketBranch> create() {
                        try {
                            if (event instanceof HasRefsChangedRequest) {
                                HasRefsChangedRequest hasRefsChangedRequest = (HasRefsChangedRequest)event;
                                return hasRefsChangedRequest.getTags(BitbucketSCMSource.this);
                            }
                            return BitbucketSCMSource.this.buildBitbucketClient().getTags();
                        }
                        catch (IOException | InterruptedException e) {
                            throw new WrappedException(e);
                        }
                    }
                });
            }
            if (request.isFetchBranches() && !request.isComplete()) {
                this.retrieveBranches(request);
            }
            if (request.isFetchPRs() && !request.isComplete()) {
                this.retrievePullRequests(request);
            }
            if (request.isFetchTags() && !request.isComplete()) {
                this.retrieveTags(request);
            }
        }
        catch (WrappedException e) {
            e.unwrap();
        }
    }

    private void retrievePullRequests(final BitbucketSCMSourceRequest request) throws IOException, InterruptedException {
        String fullName = this.repoOwner + "/" + this.repository;
        final BitbucketApi originBitbucket = this.buildBitbucketClient();
        if (request.isSkipPublicPRs() && !originBitbucket.isPrivate()) {
            request.listener().getLogger().printf("Skipping pull requests for %s (public repository)%n", fullName);
            return;
        }
        request.listener().getLogger().printf("Looking up %s for pull requests%n", fullName);
        HashSet<String> livePRs = new HashSet<String>();
        int count = 0;
        Map<Boolean, Set<ChangeRequestCheckoutStrategy>> strategies = request.getPRStrategies();
        for (final BitbucketPullRequest pull : request.getPullRequests()) {
            class Skip
            extends IOException {
                Skip() {
                }
            }
            String originalBranchName = pull.getSource().getBranch().getName();
            request.listener().getLogger().printf("Checking PR-%s from %s and branch %s%n", pull.getId(), pull.getSource().getRepository().getFullName(), originalBranchName);
            boolean fork = !fullName.equalsIgnoreCase(pull.getSource().getRepository().getFullName());
            String pullRepoOwner = pull.getSource().getRepository().getOwnerName();
            String pullRepository = pull.getSource().getRepository().getRepositoryName();
            BitbucketApi pullBitbucket = fork && originBitbucket instanceof BitbucketCloudApiClient ? BitbucketApiFactory.newInstance(this.getServerUrl(), this.authenticator(), pullRepoOwner, pullRepository) : originBitbucket;
            ++count;
            livePRs.add(pull.getId());
            this.getPullRequestTitleCache().put(pull.getId(), StringUtils.defaultString((String)pull.getTitle()));
            this.getPullRequestContributorCache().put(pull.getId(), new ContributorMetadataAction(pull.getAuthorIdentifier(), pull.getAuthorLogin(), pull.getAuthorEmail()));
            try {
                for (ChangeRequestCheckoutStrategy strategy : strategies.get(fork)) {
                    PullRequestSCMHead head;
                    String branchName = "PR-" + pull.getId();
                    if (strategies.get(fork).size() > 1) {
                        branchName = "PR-" + pull.getId() + "-" + strategy.name().toLowerCase(Locale.ENGLISH);
                    }
                    if (!request.process(head = originBitbucket instanceof BitbucketCloudApiClient ? new PullRequestSCMHead(branchName, pullRepoOwner, pullRepository, originalBranchName, pull, this.originOf(pullRepoOwner, pullRepository), strategy) : new PullRequestSCMHead(branchName, this.repoOwner, this.repository, originalBranchName, pull, this.originOf(pullRepoOwner, pullRepository), strategy), () -> new BranchHeadCommit(pull.getSource().getBranch()), new BitbucketProbeFactory(pullBitbucket, request), new BitbucketRevisionFactory<BitbucketCommit>(pullBitbucket){

                        @Override
                        @NonNull
                        public SCMRevision create(@NonNull SCMHead head, @Nullable BitbucketCommit sourceCommit) throws IOException, InterruptedException {
                            try {
                                BranchHeadCommit targetCommit = new BranchHeadCommit(pull.getDestination().getBranch());
                                return super.create(head, sourceCommit, targetCommit);
                            }
                            catch (BitbucketRequestException e) {
                                if (originBitbucket instanceof BitbucketCloudApiClient && e.getHttpCode() == 403) {
                                    request.listener().getLogger().printf("Skipping %s because of %s%n", pull.getId(), HyperlinkNote.encodeTo((String)"https://bitbucket.org/site/master/issues/5814/reify-pull-requests-by-making-them-a-ref", (String)"a permission issue accessing pull requests from forks"));
                                    throw new Skip();
                                }
                                e.printStackTrace(request.listener().getLogger());
                                if (e.getHttpCode() == 403) {
                                    throw new Skip();
                                }
                                throw e;
                            }
                        }
                    }, new SCMSourceRequest.Witness[]{new CriteriaWitness(request)})) continue;
                    request.listener().getLogger().format("%n  %d pull requests were processed (query completed)%n", count);
                    return;
                }
            }
            catch (Skip e) {
                request.listener().getLogger().println("Do not have permission to view PR from " + pull.getSource().getRepository().getFullName() + " and branch " + originalBranchName);
            }
        }
        request.listener().getLogger().format("%n  %d pull requests were processed%n", count);
        this.getPullRequestTitleCache().keySet().retainAll(livePRs);
        this.getPullRequestContributorCache().keySet().retainAll(livePRs);
    }

    private void retrieveBranches(BitbucketSCMSourceRequest request) throws IOException, InterruptedException {
        String fullName = this.repoOwner + "/" + this.repository;
        request.listener().getLogger().println("Looking up " + fullName + " for branches");
        BitbucketApi bitbucket = this.buildBitbucketClient();
        Map<String, List<BitbucketHref>> links = this.getBitbucketRepository().getLinks();
        if (links != null && links.containsKey("clone")) {
            this.cloneLinks = links.get("clone");
        }
        int count = 0;
        for (BitbucketBranch branch : request.getBranches()) {
            request.listener().getLogger().println("Checking branch " + branch.getName() + " from " + fullName);
            ++count;
            if (!request.process(new BranchSCMHead(branch.getName()), () -> new BranchHeadCommit(branch), new BitbucketProbeFactory(bitbucket, request), new BitbucketRevisionFactory(bitbucket), new SCMSourceRequest.Witness[]{new CriteriaWitness(request)})) continue;
            request.listener().getLogger().format("%n  %d branches were processed (query completed)%n", count);
            return;
        }
        request.listener().getLogger().format("%n  %d branches were processed%n", count);
    }

    private void retrieveTags(BitbucketSCMSourceRequest request) throws IOException, InterruptedException {
        String fullName = this.repoOwner + "/" + this.repository;
        request.listener().getLogger().println("Looking up " + fullName + " for tags");
        BitbucketApi bitbucket = this.buildBitbucketClient();
        Map<String, List<BitbucketHref>> links = this.getBitbucketRepository().getLinks();
        if (links != null && links.containsKey("clone")) {
            this.cloneLinks = links.get("clone");
        }
        int count = 0;
        for (BitbucketBranch tag : request.getTags()) {
            request.listener().getLogger().println("Checking tag " + tag.getName() + " from " + fullName);
            ++count;
            if (!request.process((SCMHead)new BitbucketTagSCMHead(tag.getName(), tag.getDateMillis()), tag::getRawNode, new BitbucketProbeFactory(bitbucket, request), new BitbucketRevisionFactory(bitbucket), new SCMSourceRequest.Witness[]{new CriteriaWitness(request)})) continue;
            request.listener().getLogger().format("%n  %d tags were processed (query completed)%n", count);
            return;
        }
        request.listener().getLogger().format("%n  %d tags were processed%n", count);
    }

    protected SCMRevision retrieve(SCMHead head, TaskListener listener) throws IOException, InterruptedException {
        BitbucketApi bitbucket = this.buildBitbucketClient();
        if (head instanceof PullRequestSCMHead) {
            BitbucketCommit sourceRevision;
            PullRequestSCMHead h = (PullRequestSCMHead)head;
            ArrayList<? extends BitbucketBranch> branches = new ArrayList<BitbucketBranch>();
            branches.addAll(bitbucket.getBranchesByFilterText(h.getBranchName()));
            branches.addAll(bitbucket.getBranchesByFilterText(h.getTarget().getName()));
            BitbucketCommit targetRevision = this.findCommit(h.getTarget().getName(), branches, listener);
            if (targetRevision == null) {
                LOGGER.log(Level.WARNING, "No branch found in {0}/{1} with name [{2}]", new Object[]{this.repoOwner, this.repository, h.getTarget().getName()});
                return null;
            }
            if (bitbucket instanceof BitbucketCloudApiClient) {
                if (head.getOrigin() != SCMHeadOrigin.DEFAULT) {
                    branches.clear();
                    branches.addAll(this.buildBitbucketClient(h).getBranchesByFilterText(h.getBranchName()));
                }
                sourceRevision = this.findCommit(h.getBranchName(), branches, listener);
            } else {
                try {
                    BitbucketPullRequest pr = bitbucket.getPullRequestById(Integer.parseInt(h.getId()));
                    sourceRevision = this.findPRCommit(pr, listener);
                }
                catch (NumberFormatException nfe) {
                    LOGGER.log(Level.WARNING, "Cannot parse the PR id {0}", h.getId());
                    sourceRevision = null;
                }
            }
            if (sourceRevision == null) {
                LOGGER.log(Level.WARNING, "No revision found in {0}/{1} for PR-{2} [{3}]", new Object[]{h.getRepoOwner(), h.getRepository(), h.getId(), h.getBranchName()});
                return null;
            }
            return new PullRequestSCMRevision<BitbucketGitSCMRevision>(h, new BitbucketGitSCMRevision(h.getTarget(), targetRevision), new BitbucketGitSCMRevision(h, sourceRevision));
        }
        if (head instanceof BitbucketTagSCMHead) {
            BitbucketTagSCMHead tagHead = (BitbucketTagSCMHead)head;
            List<? extends BitbucketBranch> tags = bitbucket.getTagsByFilterText(head.getName());
            BitbucketCommit revision = this.findCommit(head.getName(), tags, listener);
            if (revision == null) {
                LOGGER.log(Level.WARNING, "No tag found in {0}/{1} with name [{2}]", new Object[]{this.repoOwner, this.repository, head.getName()});
                return null;
            }
            return new BitbucketTagSCMRevision(tagHead, revision);
        }
        List<? extends BitbucketBranch> branches = bitbucket.getBranchesByFilterText(head.getName());
        BitbucketCommit revision = this.findCommit(head.getName(), branches, listener);
        if (revision == null) {
            LOGGER.log(Level.WARNING, "No branch found in {0}/{1} with name [{2}]", new Object[]{this.repoOwner, this.repository, head.getName()});
            return null;
        }
        return new BitbucketGitSCMRevision(head, revision);
    }

    private BitbucketCommit findCommit(@NonNull String branchName, List<? extends BitbucketBranch> branches, TaskListener listener) {
        for (BitbucketBranch bitbucketBranch : branches) {
            if (!branchName.equals(bitbucketBranch.getName())) continue;
            String revision = bitbucketBranch.getRawNode();
            if (revision == null) {
                if ("https://bitbucket.org".equals(this.getServerUrl())) {
                    listener.getLogger().format("Cannot resolve the hash of the revision in branch %s%n", branchName);
                } else {
                    listener.getLogger().format("Cannot resolve the hash of the revision in branch %s. Perhaps you are using Bitbucket Server previous to 4.x%n", branchName);
                }
                return null;
            }
            return new BranchHeadCommit(bitbucketBranch);
        }
        listener.getLogger().format("Cannot find the branch %s%n", branchName);
        return null;
    }

    private BitbucketCommit findPRCommit(BitbucketPullRequest pr, TaskListener listener) {
        BitbucketBranch branch = pr.getSource().getBranch();
        String hash = branch.getRawNode();
        if (hash == null) {
            if ("https://bitbucket.org".equals(this.getServerUrl())) {
                listener.getLogger().format("Cannot resolve the hash of the revision in PR-%s%n", pr.getId());
            } else {
                listener.getLogger().format("Cannot resolve the hash of the revision in PR-%s. Perhaps you are using Bitbucket Server previous to 4.x%n", pr.getId());
            }
            return null;
        }
        return new BranchHeadCommit(branch);
    }

    public SCM build(SCMHead head, SCMRevision revision) {
        BitbucketRepositoryType type;
        if (head instanceof PullRequestSCMHead) {
            type = ((PullRequestSCMHead)head).getRepositoryType();
        } else if (head instanceof BranchSCMHead) {
            type = ((BranchSCMHead)head).getRepositoryType();
        } else if (head instanceof BitbucketTagSCMHead) {
            type = ((BitbucketTagSCMHead)head).getRepositoryType();
        } else {
            throw new IllegalArgumentException("Either PullRequestSCMHead, BitbucketTagSCMHead or BranchSCMHead required as parameter");
        }
        if (type == null) {
            if (revision instanceof AbstractGitSCMSource.SCMRevisionImpl) {
                type = BitbucketRepositoryType.GIT;
            } else {
                try {
                    type = this.getRepositoryType();
                }
                catch (IOException | InterruptedException e) {
                    type = BitbucketRepositoryType.GIT;
                    LOGGER.log(Level.SEVERE, "Could not determine repository type of " + this.getRepoOwner() + "/" + this.getRepository() + " on " + this.getServerUrl() + " for " + this.getOwner() + " assuming " + (Object)((Object)type), e);
                }
            }
        }
        assert (type != null);
        if (this.cloneLinks == null) {
            BitbucketApi bitbucket = this.buildBitbucketClient();
            try {
                BitbucketRepository r = this.getBitbucketRepository();
                Map<String, List<BitbucketHref>> links = r.getLinks();
                if (links != null && links.containsKey("clone")) {
                    this.cloneLinks = links.get("clone");
                }
            }
            catch (IOException | InterruptedException e) {
                LOGGER.log(Level.SEVERE, "Could not determine clone links of " + this.getRepoOwner() + "/" + this.getRepository() + " on " + this.getServerUrl() + " for " + this.getOwner() + " falling back to generated links", e);
                this.cloneLinks = new ArrayList<BitbucketHref>();
                this.cloneLinks.add(new BitbucketHref("ssh", bitbucket.getRepositoryUri(BitbucketRepositoryProtocol.SSH, null, this.getRepoOwner(), this.getRepository())));
                this.cloneLinks.add(new BitbucketHref("https", bitbucket.getRepositoryUri(BitbucketRepositoryProtocol.HTTP, null, this.getRepoOwner(), this.getRepository())));
            }
        }
        switch (type) {
            default: 
        }
        return ((BitbucketGitSCMBuilder)new BitbucketGitSCMBuilder(this, head, revision, this.getCredentialsId()).withCloneLinks(this.cloneLinks).withTraits(this.traits)).build();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NonNull
    public SCMRevision getTrustedRevision(@NonNull SCMRevision revision, @NonNull TaskListener listener) throws IOException, InterruptedException {
        if (!(revision instanceof PullRequestSCMRevision)) return revision;
        PullRequestSCMHead head = (PullRequestSCMHead)revision.getHead();
        try (BitbucketSCMSourceRequest request = ((BitbucketSCMSourceContext)new BitbucketSCMSourceContext(null, (SCMHeadObserver)SCMHeadObserver.none()).withTraits(this.traits)).newRequest(this, listener);){
            if (request.isTrusted(head)) {
                SCMRevision sCMRevision = revision;
                return sCMRevision;
            }
        }
        catch (WrappedException wrapped) {
            wrapped.unwrap();
        }
        PullRequestSCMRevision rev = (PullRequestSCMRevision)revision;
        listener.getLogger().format("Loading trusted files from base branch %s at %s rather than %s%n", head.getTarget().getName(), rev.getTarget(), rev.getPull());
        return rev.getTarget();
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    @CheckForNull
    StandardCredentials credentials() {
        return BitbucketCredentials.lookupCredentials(this.getServerUrl(), this.getOwner(), this.getCredentialsId(), StandardCredentials.class);
    }

    @CheckForNull
    BitbucketAuthenticator authenticator() {
        return (BitbucketAuthenticator)AuthenticationTokens.convert(BitbucketAuthenticator.authenticationContext(this.getServerUrl()), (Credentials)this.credentials());
    }

    @NonNull
    protected List<Action> retrieveActions(@CheckForNull SCMSourceEvent event, @NonNull TaskListener listener) throws IOException, InterruptedException {
        ArrayList<Action> result = new ArrayList<Action>();
        BitbucketApi bitbucket = this.buildBitbucketClient();
        BitbucketRepository r = this.getBitbucketRepository();
        Map<String, List<BitbucketHref>> links = r.getLinks();
        if (links != null && links.containsKey("clone")) {
            this.cloneLinks = links.get("clone");
        }
        result.add((Action)new BitbucketRepoMetadataAction(r));
        String defaultBranch = bitbucket.getDefaultBranch();
        if (StringUtils.isNotBlank((String)defaultBranch)) {
            result.add((Action)new BitbucketDefaultBranch(this.repoOwner, this.repository, defaultBranch));
        }
        UriTemplate template = "https://bitbucket.org".equals(this.getServerUrl()) ? UriTemplate.fromTemplate((String)(this.getServerUrl() + CLOUD_REPO_TEMPLATE)) : UriTemplate.fromTemplate((String)(this.getServerUrl() + SERVER_REPO_TEMPLATE));
        template.set("owner", (Object)this.repoOwner).set("repo", (Object)this.repository);
        String url = template.expand();
        result.add(new BitbucketLink("icon-bitbucket-repo", url));
        result.add((Action)new ObjectMetadataAction(r.getRepositoryName(), null, url));
        return result;
    }

    @NonNull
    protected List<Action> retrieveActions(@NonNull SCMHead head, @CheckForNull SCMHeadEvent event, @NonNull TaskListener listener) throws IOException, InterruptedException {
        PullRequestSCMHead pr;
        UriTemplate template;
        ArrayList<Action> result = new ArrayList<Action>();
        String title = null;
        if ("https://bitbucket.org".equals(this.getServerUrl())) {
            template = UriTemplate.fromTemplate((String)(this.getServerUrl() + CLOUD_REPO_TEMPLATE + "/{branchOrPR}/{prIdOrHead}")).set("owner", (Object)this.repoOwner).set("repo", (Object)this.repository);
            if (head instanceof PullRequestSCMHead) {
                pr = (PullRequestSCMHead)head;
                template.set("branchOrPR", (Object)"pull-requests").set("prIdOrHead", (Object)pr.getId());
            } else {
                template.set("branchOrPR", (Object)"branch").set("prIdOrHead", (Object)head.getName());
            }
        } else if (head instanceof PullRequestSCMHead) {
            pr = (PullRequestSCMHead)head;
            template = UriTemplate.fromTemplate((String)(this.getServerUrl() + SERVER_REPO_TEMPLATE + "/pull-requests/{id}/overview")).set("owner", (Object)this.repoOwner).set("repo", (Object)this.repository).set("id", (Object)pr.getId());
        } else {
            template = UriTemplate.fromTemplate((String)(this.getServerUrl() + SERVER_REPO_TEMPLATE + "/compare/commits{?sourceBranch}")).set("owner", (Object)this.repoOwner).set("repo", (Object)this.repository).set("sourceBranch", (Object)("refs/heads/" + head.getName()));
        }
        if (head instanceof PullRequestSCMHead) {
            pr = (PullRequestSCMHead)head;
            title = this.getPullRequestTitleCache().get(pr.getId());
            ContributorMetadataAction contributor = this.getPullRequestContributorCache().get(pr.getId());
            if (contributor != null) {
                result.add((Action)contributor);
            }
        }
        String url = template.expand();
        result.add(new BitbucketLink("icon-bitbucket-branch", url));
        result.add((Action)new ObjectMetadataAction(title, null, url));
        SCMSourceOwner owner = this.getOwner();
        if (owner instanceof Actionable) {
            for (BitbucketDefaultBranch p : ((Actionable)owner).getActions(BitbucketDefaultBranch.class)) {
                if (!StringUtils.equals((String)this.getRepoOwner(), (String)p.getRepoOwner()) || !StringUtils.equals((String)this.repository, (String)p.getRepository()) || !StringUtils.equals((String)p.getDefaultBranch(), (String)head.getName())) continue;
                result.add((Action)new PrimaryInstanceMetadataAction());
                break;
            }
        }
        return result;
    }

    @NonNull
    private synchronized Map<String, String> getPullRequestTitleCache() {
        if (this.pullRequestTitleCache == null) {
            this.pullRequestTitleCache = new ConcurrentHashMap<String, String>();
        }
        return this.pullRequestTitleCache;
    }

    @NonNull
    private synchronized Map<String, ContributorMetadataAction> getPullRequestContributorCache() {
        if (this.pullRequestContributorCache == null) {
            this.pullRequestContributorCache = new ConcurrentHashMap<String, ContributorMetadataAction>();
        }
        return this.pullRequestContributorCache;
    }

    @NonNull
    public SCMHeadOrigin originOf(@NonNull String repoOwner, @NonNull String repository) {
        if (this.repository.equalsIgnoreCase(repository)) {
            if (this.repoOwner.equalsIgnoreCase(repoOwner)) {
                return SCMHeadOrigin.DEFAULT;
            }
            return new SCMHeadOrigin.Fork(repoOwner);
        }
        return new SCMHeadOrigin.Fork(repoOwner + "/" + repository);
    }

    public static int getEventDelaySeconds() {
        return eventDelaySeconds;
    }

    @Restricted(value={NoExternalUse.class})
    public static void setEventDelaySeconds(int eventDelaySeconds) {
        BitbucketSCMSource.eventDelaySeconds = Math.min(300, Math.max(0, eventDelaySeconds));
    }

    private static class WrappedException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public WrappedException(Throwable cause) {
            super(cause);
        }

        public void unwrap() throws IOException, InterruptedException {
            Throwable cause = this.getCause();
            if (cause instanceof IOException) {
                throw (IOException)cause;
            }
            if (cause instanceof InterruptedException) {
                throw (InterruptedException)cause;
            }
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw this;
        }
    }

    private static class BranchHeadCommit
    implements BitbucketCommit {
        private final BitbucketBranch branch;

        public BranchHeadCommit(@NonNull BitbucketBranch branch) {
            this.branch = branch;
        }

        @Override
        public String getAuthor() {
            return this.branch.getAuthor();
        }

        @Override
        public String getMessage() {
            return this.branch.getMessage();
        }

        @Override
        public String getDate() {
            return new StdDateFormat().format(new Date(this.branch.getDateMillis()));
        }

        @Override
        public String getHash() {
            return this.branch.getRawNode();
        }

        @Override
        public long getDateMillis() {
            return this.branch.getDateMillis();
        }
    }

    private class BitbucketRevisionFactory<I>
    implements SCMSourceRequest.LazyRevisionLambda<SCMHead, SCMRevision, I> {
        private final BitbucketApi client;

        public BitbucketRevisionFactory(BitbucketApi client) {
            this.client = client;
        }

        @NonNull
        public SCMRevision create(@NonNull SCMHead head, @Nullable I input) throws IOException, InterruptedException {
            return this.create(head, input, null);
        }

        @NonNull
        public SCMRevision create(@NonNull SCMHead head, @Nullable I sourceInput, @Nullable I targetInput) throws IOException, InterruptedException {
            BitbucketCommit sourceCommit = this.asCommit(sourceInput);
            BitbucketCommit targetCommit = this.asCommit(targetInput);
            if (head instanceof PullRequestSCMHead) {
                PullRequestSCMHead prHead = (PullRequestSCMHead)head;
                SCMHead targetHead = prHead.getTarget();
                return new PullRequestSCMRevision<BitbucketGitSCMRevision>(prHead, new BitbucketGitSCMRevision(targetHead, targetCommit), new BitbucketGitSCMRevision(prHead, sourceCommit));
            }
            BitbucketGitSCMRevision revision = new BitbucketGitSCMRevision(head, sourceCommit);
            return revision;
        }

        private BitbucketCommit asCommit(I input) throws IOException, InterruptedException {
            if (input instanceof String) {
                return this.client.resolveCommit((String)input);
            }
            if (input instanceof BitbucketCommit) {
                return (BitbucketCommit)input;
            }
            return null;
        }
    }

    private static class BitbucketProbeFactory<I>
    implements SCMSourceRequest.ProbeLambda<SCMHead, I> {
        private final BitbucketApi bitbucket;
        private final BitbucketSCMSourceRequest request;

        public BitbucketProbeFactory(BitbucketApi bitbucket, BitbucketSCMSourceRequest request) {
            this.bitbucket = bitbucket;
            this.request = request;
        }

        @NonNull
        public SCMSourceCriteria.Probe create(final @NonNull SCMHead head, final @CheckForNull I revisionInfo) throws IOException, InterruptedException {
            final String hash = revisionInfo instanceof BitbucketCommit ? ((BitbucketCommit)revisionInfo).getHash() : (String)revisionInfo;
            return new SCMSourceCriteria.Probe(){
                private static final long serialVersionUID = 1L;

                public String name() {
                    return head.getName();
                }

                public long lastModified() {
                    try {
                        BitbucketCommit commit = null;
                        if (hash != null) {
                            BitbucketCommit bitbucketCommit = commit = revisionInfo instanceof BitbucketCommit ? (BitbucketCommit)revisionInfo : bitbucket.resolveCommit(hash);
                        }
                        if (commit == null) {
                            request.listener().getLogger().format("Can not resolve commit by hash [%s] on repository %s/%s%n", hash, bitbucket.getOwner(), bitbucket.getRepositoryName());
                            return 0L;
                        }
                        return commit.getDateMillis();
                    }
                    catch (IOException | InterruptedException e) {
                        request.listener().getLogger().format("Can not resolve commit by hash [%s] on repository %s/%s%n", hash, bitbucket.getOwner(), bitbucket.getRepositoryName());
                        return 0L;
                    }
                }

                public boolean exists(@NonNull String path) throws IOException {
                    if (hash == null) {
                        request.listener().getLogger().format("Can not resolve path for hash [%s] on repository %s/%s%n", hash, bitbucket.getOwner(), bitbucket.getRepositoryName());
                        return false;
                    }
                    try {
                        return bitbucket.checkPathExists(hash, path);
                    }
                    catch (InterruptedException e) {
                        throw new IOException("Interrupted", e);
                    }
                }
            };
        }
    }

    private static class CriteriaWitness
    implements SCMSourceRequest.Witness {
        private final BitbucketSCMSourceRequest request;

        public CriteriaWitness(BitbucketSCMSourceRequest request) {
            this.request = request;
        }

        public void record(@NonNull SCMHead scmHead, SCMRevision revision, boolean isMatch) {
            if (revision == null) {
                this.request.listener().getLogger().println("    Skipped");
            } else if (isMatch) {
                this.request.listener().getLogger().println("    Met criteria");
            } else {
                this.request.listener().getLogger().println("    Does not meet criteria");
                return;
            }
        }
    }

    @Symbol(value={"bitbucket"})
    @Extension
    public static class DescriptorImpl
    extends SCMSourceDescriptor {
        public static final String ANONYMOUS = "ANONYMOUS";
        public static final String SAME = "SAME";

        public String getDisplayName() {
            return "Bitbucket";
        }

        public FormValidation doCheckCredentialsId(@AncestorInPath @CheckForNull SCMSourceOwner context, @QueryParameter String value, @QueryParameter String serverUrl) {
            return BitbucketCredentials.checkCredentialsId(context, value, serverUrl);
        }

        public static FormValidation doCheckServerUrl(@QueryParameter String value) {
            if (BitbucketEndpointConfiguration.get().findEndpoint(value) == null) {
                return FormValidation.error((String)("Unregistered Server: " + value));
            }
            return FormValidation.ok();
        }

        public boolean isServerUrlSelectable() {
            return BitbucketEndpointConfiguration.get().isEndpointSelectable();
        }

        public ListBoxModel doFillServerUrlItems() {
            return BitbucketEndpointConfiguration.get().getEndpointItems();
        }

        public ListBoxModel doFillCredentialsIdItems(@AncestorInPath SCMSourceOwner context, @QueryParameter String serverUrl) {
            return BitbucketCredentials.fillCredentialsIdItems(context, serverUrl);
        }

        public ListBoxModel doFillRepositoryItems(@AncestorInPath SCMSourceOwner context, @QueryParameter String serverUrl, @QueryParameter String credentialsId, @QueryParameter String repoOwner) throws IOException, InterruptedException {
            if ((repoOwner = Util.fixEmptyAndTrim((String)repoOwner)) == null) {
                return new ListBoxModel();
            }
            if (context == null && !Jenkins.get().hasPermission(Jenkins.ADMINISTER) || context != null && !context.hasPermission(Item.EXTENDED_READ)) {
                return new ListBoxModel();
            }
            if (context != null && !context.hasPermission(CredentialsProvider.USE_ITEM)) {
                return new ListBoxModel();
            }
            String serverUrlFallback = "https://bitbucket.org";
            if (BitbucketEndpointConfiguration.get().getEndpointItems().size() > 0) {
                serverUrlFallback = ((ListBoxModel.Option)BitbucketEndpointConfiguration.get().getEndpointItems().get((int)0)).value;
            }
            serverUrl = StringUtils.defaultIfBlank((String)serverUrl, (String)serverUrlFallback);
            ListBoxModel result = new ListBoxModel();
            StandardCredentials credentials = BitbucketCredentials.lookupCredentials(serverUrl, context, credentialsId, StandardCredentials.class);
            BitbucketAuthenticator authenticator = (BitbucketAuthenticator)AuthenticationTokens.convert(BitbucketAuthenticator.authenticationContext(serverUrl), (Credentials)credentials);
            try {
                BitbucketApi bitbucket = BitbucketApiFactory.newInstance(serverUrl, authenticator, repoOwner, null);
                BitbucketTeam team = bitbucket.getTeam();
                List<? extends BitbucketRepository> repositories = bitbucket.getRepositories(team != null ? null : UserRoleInRepository.CONTRIBUTOR);
                if (repositories.isEmpty()) {
                    throw FormFillFailure.error((String)Messages.BitbucketSCMSource_NoMatchingOwner(repoOwner)).withSelectionCleared();
                }
                for (BitbucketRepository bitbucketRepository : repositories) {
                    result.add(bitbucketRepository.getRepositoryName());
                }
                return result;
            }
            catch (FormFillFailure | OutOfMemoryError e) {
                throw e;
            }
            catch (IOException e) {
                if (e instanceof BitbucketRequestException ? ((BitbucketRequestException)e).getHttpCode() == 401 : e.getCause() instanceof BitbucketRequestException && ((BitbucketRequestException)e.getCause()).getHttpCode() == 401) {
                    throw FormFillFailure.error((String)(credentials == null ? Messages.BitbucketSCMSource_UnauthorizedAnonymous(repoOwner) : Messages.BitbucketSCMSource_UnauthorizedOwner(repoOwner))).withSelectionCleared();
                }
                LOGGER.log(Level.SEVERE, e.getMessage(), e);
                throw FormFillFailure.error((String)e.getMessage());
            }
            catch (Throwable e) {
                LOGGER.log(Level.SEVERE, e.getMessage(), e);
                throw FormFillFailure.error((String)e.getMessage());
            }
        }

        @NonNull
        protected SCMHeadCategory[] createCategories() {
            return new SCMHeadCategory[]{new UncategorizedSCMHeadCategory(Messages._BitbucketSCMSource_UncategorizedSCMHeadCategory_DisplayName()), new ChangeRequestSCMHeadCategory(Messages._BitbucketSCMSource_ChangeRequestSCMHeadCategory_DisplayName()), new TagSCMHeadCategory(Messages._BitbucketSCMSource_TagSCMHeadCategory_DisplayName())};
        }

        public List<NamedArrayList<? extends SCMSourceTraitDescriptor>> getTraitsDescriptorLists() {
            ArrayList all = new ArrayList();
            all.addAll(SCMSourceTrait._for((SCMSourceDescriptor)this, BitbucketSCMSourceContext.class, null));
            all.addAll(SCMSourceTrait._for((SCMSourceDescriptor)this, null, BitbucketGitSCMBuilder.class));
            HashSet<SCMSourceTraitDescriptor> dedup = new HashSet<SCMSourceTraitDescriptor>();
            Iterator iterator = all.iterator();
            while (iterator.hasNext()) {
                SCMSourceTraitDescriptor d = (SCMSourceTraitDescriptor)iterator.next();
                if (dedup.contains(d) || d instanceof GitBrowserSCMSourceTrait.DescriptorImpl) {
                    iterator.remove();
                    continue;
                }
                dedup.add(d);
            }
            ArrayList<NamedArrayList<? extends SCMSourceTraitDescriptor>> result = new ArrayList<NamedArrayList<? extends SCMSourceTraitDescriptor>>();
            NamedArrayList.select(all, (String)"Within repository", (NamedArrayList.Predicate)NamedArrayList.anyOf((NamedArrayList.Predicate[])new NamedArrayList.Predicate[]{NamedArrayList.withAnnotation(Discovery.class), NamedArrayList.withAnnotation(Selection.class)}), (boolean)true, result);
            int insertionPoint = result.size();
            NamedArrayList.select(all, (String)"Git", it -> GitSCM.class.isAssignableFrom(it.getScmClass()), (boolean)true, result);
            NamedArrayList.select(all, (String)"General", null, (boolean)true, result, (int)insertionPoint);
            return result;
        }

        public List<SCMSourceTrait> getTraitsDefaults() {
            return Arrays.asList(new SCMSourceTrait[]{new BranchDiscoveryTrait(true, false), new OriginPullRequestDiscoveryTrait(EnumSet.of(ChangeRequestCheckoutStrategy.MERGE)), new ForkPullRequestDiscoveryTrait(EnumSet.of(ChangeRequestCheckoutStrategy.MERGE), (SCMHeadAuthority<? super BitbucketSCMSourceRequest, ? extends ChangeRequestSCMHead2, ? extends SCMRevision>)new ForkPullRequestDiscoveryTrait.TrustTeamForks())});
        }
    }
}

