/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.plugins.bitbucket;

import com.cloudbees.jenkins.plugins.bitbucket.BitbucketSCMNavigatorContext;
import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketRepository;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import jenkins.scm.api.SCMNavigator;
import jenkins.scm.api.SCMSourceObserver;
import jenkins.scm.api.trait.SCMNavigatorContext;
import jenkins.scm.api.trait.SCMNavigatorRequest;

public class BitbucketSCMNavigatorRequest
extends SCMNavigatorRequest {
    private final Map<String, BitbucketRepository> repositoryMap = new TreeMap<String, BitbucketRepository>();

    protected BitbucketSCMNavigatorRequest(@NonNull SCMNavigator source, @NonNull BitbucketSCMNavigatorContext context, @NonNull SCMSourceObserver observer) {
        super(source, (SCMNavigatorContext)context, observer);
    }

    public void withRepositories(List<? extends BitbucketRepository> repositories) {
        this.repositoryMap.clear();
        for (BitbucketRepository bitbucketRepository : repositories) {
            this.repositoryMap.put(bitbucketRepository.getRepositoryName(), bitbucketRepository);
        }
    }

    public Collection<BitbucketRepository> repositories() {
        return this.repositoryMap.values();
    }

    public BitbucketRepository getBitbucketRepository(String repositoryName) {
        return this.repositoryMap.get(repositoryName);
    }
}

