/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.plugins.bitbucket;

import com.cloudbees.jenkins.plugins.bitbucket.BitbucketCredentials;
import com.cloudbees.jenkins.plugins.bitbucket.BitbucketSCMSource;
import com.cloudbees.jenkins.plugins.bitbucket.PullRequestSCMHead;
import com.cloudbees.jenkins.plugins.bitbucket.PullRequestSCMRevision;
import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketApi;
import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketHref;
import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketRepositoryProtocol;
import com.cloudbees.jenkins.plugins.bitbucket.client.BitbucketCloudApiClient;
import com.cloudbees.jenkins.plugins.bitbucket.endpoints.AbstractBitbucketEndpoint;
import com.cloudbees.jenkins.plugins.bitbucket.endpoints.BitbucketEndpointConfiguration;
import com.cloudbees.jenkins.plugins.bitbucket.endpoints.BitbucketServerEndpoint;
import com.cloudbees.jenkins.plugins.sshcredentials.SSHUserPrivateKey;
import com.cloudbees.plugins.credentials.common.StandardCredentials;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Util;
import hudson.plugins.git.GitSCM;
import hudson.plugins.git.browser.BitbucketWeb;
import hudson.plugins.git.browser.GitRepositoryBrowser;
import hudson.plugins.git.extensions.GitSCMExtension;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import jenkins.plugins.git.AbstractGitSCMSource;
import jenkins.plugins.git.GitSCMBuilder;
import jenkins.plugins.git.MergeWithGitSCMExtension;
import jenkins.scm.api.SCMHead;
import jenkins.scm.api.SCMRevision;
import jenkins.scm.api.mixin.ChangeRequestCheckoutStrategy;
import jenkins.scm.api.mixin.TagSCMHead;
import org.apache.commons.lang.StringUtils;

public class BitbucketGitSCMBuilder
extends GitSCMBuilder<BitbucketGitSCMBuilder> {
    @NonNull
    private final BitbucketSCMSource scmSource;
    @NonNull
    private List<BitbucketHref> cloneLinks = Collections.emptyList();
    @NonNull
    private BitbucketRepositoryProtocol protocol = BitbucketRepositoryProtocol.HTTP;

    public BitbucketGitSCMBuilder(@NonNull BitbucketSCMSource scmSource, @NonNull SCMHead head, @CheckForNull SCMRevision revision, @CheckForNull String credentialsId) {
        super(head, revision, scmSource.getServerUrl(), credentialsId);
        this.withoutRefSpecs();
        if (head instanceof PullRequestSCMHead) {
            if (scmSource.buildBitbucketClient() instanceof BitbucketCloudApiClient) {
                String branchName = ((PullRequestSCMHead)head).getBranchName();
                this.withRefSpec("+refs/heads/" + branchName + ":refs/remotes/@{remote}/" + head.getName());
            } else {
                String pullId = ((PullRequestSCMHead)head).getId();
                this.withRefSpec("+refs/pull-requests/" + pullId + "/from:refs/remotes/@{remote}/" + head.getName());
            }
        } else if (head instanceof TagSCMHead) {
            this.withRefSpec("+refs/tags/" + head.getName() + ":refs/tags/" + head.getName());
        } else {
            this.withRefSpec("+refs/heads/" + head.getName() + ":refs/remotes/@{remote}/" + head.getName());
        }
        this.scmSource = scmSource;
        AbstractBitbucketEndpoint endpoint = BitbucketEndpointConfiguration.get().findEndpoint(scmSource.getServerUrl());
        if (endpoint == null) {
            endpoint = new BitbucketServerEndpoint(null, scmSource.getServerUrl(), false, null);
        }
        this.withBrowser((GitRepositoryBrowser)new BitbucketWeb(endpoint.getRepositoryUrl(scmSource.getRepoOwner(), scmSource.getRepository())));
        this.withCredentials(credentialsId, null);
    }

    public BitbucketGitSCMBuilder withCloneLinks(List<BitbucketHref> cloneLinks) {
        this.cloneLinks = new ArrayList<BitbucketHref>(Util.fixNull(cloneLinks));
        return this.withBitbucketRemote();
    }

    @NonNull
    public BitbucketSCMSource scmSource() {
        return this.scmSource;
    }

    @NonNull
    public List<BitbucketHref> cloneLinks() {
        return Collections.unmodifiableList(this.cloneLinks);
    }

    @NonNull
    public BitbucketGitSCMBuilder withCredentials(String credentialsId, BitbucketRepositoryProtocol protocol) {
        if (StringUtils.isNotBlank((String)credentialsId)) {
            StandardCredentials credentials = BitbucketCredentials.lookupCredentials(this.scmSource.getServerUrl(), this.scmSource.getOwner(), credentialsId, StandardCredentials.class);
            if (protocol == null) {
                protocol = credentials instanceof SSHUserPrivateKey ? BitbucketRepositoryProtocol.SSH : BitbucketRepositoryProtocol.HTTP;
            }
        } else if (protocol == null) {
            protocol = BitbucketRepositoryProtocol.HTTP;
        }
        this.protocol = protocol;
        return (BitbucketGitSCMBuilder)this.withCredentials(credentialsId);
    }

    @NonNull
    public BitbucketGitSCMBuilder withBitbucketRemote() {
        PullRequestSCMHead head;
        String repository;
        String repoOwner;
        SCMHead h = this.head();
        BitbucketApi bitbucket = this.scmSource().buildBitbucketClient();
        if (h instanceof PullRequestSCMHead && bitbucket instanceof BitbucketCloudApiClient) {
            repoOwner = ((PullRequestSCMHead)h).getRepoOwner();
            repository = ((PullRequestSCMHead)h).getRepository();
        } else {
            repoOwner = this.scmSource.getRepoOwner();
            repository = this.scmSource.getRepository();
        }
        String cloneLink = null;
        for (BitbucketHref link : this.cloneLinks()) {
            if (!this.protocol.getType().equals(link.getName())) continue;
            cloneLink = link.getHref();
            break;
        }
        this.withRemote(bitbucket.getRepositoryUri(this.protocol, cloneLink, repoOwner, repository));
        AbstractBitbucketEndpoint endpoint = BitbucketEndpointConfiguration.get().findEndpoint(this.scmSource.getServerUrl());
        if (endpoint == null) {
            endpoint = new BitbucketServerEndpoint(null, this.scmSource.getServerUrl(), false, null);
        }
        this.withBrowser((GitRepositoryBrowser)new BitbucketWeb(endpoint.getRepositoryUrl(repoOwner, repository)));
        SCMRevision r = this.revision();
        if (h instanceof PullRequestSCMHead && (head = (PullRequestSCMHead)h).getCheckoutStrategy() == ChangeRequestCheckoutStrategy.MERGE) {
            String name = head.getTarget().getName();
            String localName = head.getBranchName().equals(name) ? "upstream-" + name : name;
            String remoteName = this.remoteName().equals("upstream") ? "upstream-upstream" : "upstream";
            this.withAdditionalRemote(remoteName, bitbucket.getRepositoryUri(this.protocol, cloneLink, this.scmSource().getRepoOwner(), this.scmSource().getRepository()), new String[]{"+refs/heads/" + name + ":refs/remotes/@{remote}/" + localName});
            if (r instanceof PullRequestSCMRevision && ((PullRequestSCMRevision)r).getTarget() instanceof AbstractGitSCMSource.SCMRevisionImpl) {
                this.withExtension((GitSCMExtension)new MergeWithGitSCMExtension("remotes/" + remoteName + "/" + localName, ((AbstractGitSCMSource.SCMRevisionImpl)((PullRequestSCMRevision)r).getTarget()).getHash()));
            } else {
                this.withExtension((GitSCMExtension)new MergeWithGitSCMExtension("remotes/" + remoteName + "/" + localName, null));
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public GitSCM build() {
        this.withBitbucketRemote();
        SCMHead h = this.head();
        SCMRevision r = this.revision();
        try {
            if (h instanceof PullRequestSCMHead) {
                this.withHead(new SCMHead(((PullRequestSCMHead)h).getBranchName()));
                if (r instanceof PullRequestSCMRevision) {
                    this.withRevision((SCMRevision)((PullRequestSCMRevision)r).getPull());
                }
            }
            GitSCM gitSCM = super.build();
            return gitSCM;
        }
        finally {
            this.withHead(h);
            this.withRevision(r);
        }
    }
}

