/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.claim.messages;

import hudson.model.User;
import hudson.tasks.Mailer;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Collections;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import jenkins.model.JenkinsLocationConfiguration;

abstract class ClaimMessage {
    private static final Logger LOGGER = Logger.getLogger("claim-plugin");
    protected static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private String item;
    private String url;
    private String claimedByUser;

    ClaimMessage(String item, String url, String claimedByUser) {
        this.item = item;
        this.url = url;
        this.claimedByUser = claimedByUser;
    }

    protected String getItem() {
        return this.item;
    }

    protected String getClaimedByUser() {
        return this.claimedByUser;
    }

    public void send() throws MessagingException, IOException {
        if (this.mustBeSent()) {
            MimeMessage message = this.createMessage();
            ClaimMessage.sendMessage(message);
        }
    }

    protected abstract boolean mustBeSent();

    protected abstract String getMessage();

    protected abstract String getSubject();

    protected abstract Iterable<? extends String> getToRecipients();

    @Nonnull
    protected String buildJenkinsUrl() {
        return ClaimMessage.getJenkinsLocationConfiguration().getUrl() + this.url;
    }

    @Nonnull
    private static JenkinsLocationConfiguration getJenkinsLocationConfiguration() {
        JenkinsLocationConfiguration jlc = JenkinsLocationConfiguration.get();
        if (jlc == null) {
            throw new IllegalStateException("JenkinsLocationConfiguration not available");
        }
        return jlc;
    }

    @Nonnull
    private MimeMessage createMessage() throws MessagingException, UnsupportedEncodingException {
        Mailer.DescriptorImpl mailDescriptor = new Mailer.DescriptorImpl();
        MimeMessage msg = ClaimMessage.createMimeMessage(mailDescriptor);
        msg.setSentDate(new Date());
        msg.setSubject(this.getSubject(), mailDescriptor.getCharset());
        msg.setText(this.getMessage());
        for (String string : this.getToRecipients()) {
            Address userEmail = ClaimMessage.getUserEmail(string, mailDescriptor);
            if (userEmail == null) continue;
            msg.setRecipient(Message.RecipientType.TO, userEmail);
        }
        return msg;
    }

    @Nonnull
    private static MimeMessage createMimeMessage(Mailer.DescriptorImpl mailDescriptor) throws MessagingException, UnsupportedEncodingException {
        MimeMessage msg = new MimeMessage(mailDescriptor.createSession());
        msg.setFrom((Address)Mailer.stringToAddress((String)ClaimMessage.getJenkinsLocationConfiguration().getAdminAddress(), (String)mailDescriptor.getCharset()));
        return msg;
    }

    private static void sendMessage(MimeMessage msg) throws MessagingException {
        Address[] recipients = msg.getAllRecipients();
        if (recipients != null && recipients.length > 0) {
            Transport.send((Message)msg);
        }
    }

    @CheckForNull
    private static Address getUserEmail(String claimedByUser, Mailer.DescriptorImpl mailDescriptor) {
        User user = User.get((String)claimedByUser, (boolean)false, Collections.emptyMap());
        if (user != null) {
            try {
                Mailer.UserProperty mailProperty = (Mailer.UserProperty)user.getProperty(Mailer.UserProperty.class);
                if (mailProperty != null && mailProperty.getAddress() != null) {
                    return new InternetAddress(mailProperty.getAddress());
                }
                return new InternetAddress(user.getId() + mailDescriptor.getDefaultSuffix());
            }
            catch (AddressException e) {
                LOGGER.log(Level.WARNING, "Cannot get email address for user " + user.getId(), e);
            }
        }
        return null;
    }
}

