/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.claim.http;

import com.google.inject.Injector;
import hudson.Extension;
import hudson.XmlFile;
import hudson.init.InitMilestone;
import hudson.init.Initializer;
import hudson.model.Saveable;
import hudson.model.listeners.SaveableListener;
import hudson.plugins.claim.ClaimConfig;
import hudson.plugins.claim.http.AutoRefreshControlHttpResponse;
import hudson.util.PluginServletFilter;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import jenkins.model.Jenkins;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.StaplerResponse;

@Restricted(value={NoExternalUse.class})
@Extension
public class PreventRefreshFilter
extends SaveableListener
implements Filter {
    private static final String NO_REFRESH_HEADER = PreventRefreshFilter.class.getName();
    private static PreventRefreshFilter installedFilter;

    public static void preventRefresh(StaplerResponse response) {
        response.addHeader(NO_REFRESH_HEADER, "");
    }

    @Initializer(after=InitMilestone.PLUGINS_STARTED)
    public static void initAutoRefreshFilter() throws ServletException {
        PreventRefreshFilter.initAutoRefreshFilter(ClaimConfig.get());
    }

    private static synchronized void initAutoRefreshFilter(ClaimConfig config) throws ServletException {
        boolean installed;
        boolean newInstalled = config.isBlockAutoRefreshWhileClaiming();
        boolean bl = installed = installedFilter != null;
        if (newInstalled != installed) {
            Injector inj = Jenkins.getInstance().getInjector();
            if (newInstalled) {
                installedFilter = (PreventRefreshFilter)((Object)inj.getInstance(PreventRefreshFilter.class));
                PluginServletFilter.addFilter((Filter)installedFilter);
            } else {
                PluginServletFilter.removeFilter((Filter)installedFilter);
                installedFilter = null;
            }
        }
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        Object actualResponse = response;
        if (response instanceof HttpServletResponse) {
            actualResponse = new AutoRefreshControlHttpResponse((HttpServletResponse)response, NO_REFRESH_HEADER);
        }
        chain.doFilter(request, actualResponse);
    }

    public void destroy() {
    }

    public void onChange(Saveable o, XmlFile file) {
        if (o instanceof ClaimConfig) {
            try {
                PreventRefreshFilter.initAutoRefreshFilter((ClaimConfig)o);
            }
            catch (ServletException e) {
                Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.SEVERE, "Unable to update the servlet filters following configuration change", e);
            }
        }
    }
}

