/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.claim.http;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;

final class AutoRefreshControlHttpResponse
extends HttpServletResponseWrapper {
    private final List<String> refreshHeaderValues = Lists.newArrayList();
    private final String noRefreshHeader;
    private boolean isRefreshHeaderRemoved = false;

    AutoRefreshControlHttpResponse(HttpServletResponse response, String noRefreshHeader) {
        super(response);
        this.noRefreshHeader = noRefreshHeader;
    }

    public void addHeader(String name, String value) {
        this.addHeader(name, value, true);
    }

    private void addHeader(String name, String value, boolean suppress) {
        if (name.equals(this.noRefreshHeader)) {
            this.isRefreshHeaderRemoved = true;
        } else if (suppress && name.equalsIgnoreCase("Refresh")) {
            this.refreshHeaderValues.add(value);
        } else {
            super.addHeader(name, value);
        }
    }

    public ServletOutputStream getOutputStream() throws IOException {
        this.addRefreshHeadersIfNeeded();
        return super.getOutputStream();
    }

    public PrintWriter getWriter() throws IOException {
        this.addRefreshHeadersIfNeeded();
        return super.getWriter();
    }

    private void addRefreshHeadersIfNeeded() {
        if (!this.isRefreshHeaderRemoved) {
            this.refreshHeaderValues.forEach(value -> this.addHeader("Refresh", (String)value, false));
        }
    }
}

