/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.claim;

import hudson.Extension;
import hudson.model.Action;
import hudson.model.ModelObject;
import hudson.model.TransientUserActionFactory;
import hudson.model.User;
import hudson.plugins.claim.AbstractAssignedClaimsReport;
import hudson.plugins.claim.AbstractClaimBuildAction;
import hudson.plugins.claim.Messages;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import javax.annotation.Nonnull;

public class UserClaimsAction
extends AbstractAssignedClaimsReport {
    @Nonnull
    private final User targetUser;

    public UserClaimsAction(@Nonnull User user) {
        this.targetUser = user;
    }

    @Override
    public ModelObject getOwner() {
        return this.targetUser;
    }

    @Override
    protected boolean isDisplayed(AbstractClaimBuildAction<?> claimAction) {
        return super.isDisplayed(claimAction) && User.get((String)claimAction.getClaimedBy(), (boolean)false, Collections.emptyMap()).getId().equals(this.targetUser.getId());
    }

    @Override
    public String getDisplayName() {
        User currentUser = User.current();
        if (currentUser != null && Objects.equals(this.targetUser.getId(), currentUser.getId())) {
            return Messages.UserClaimsAction_DisplayName_MyClaims();
        }
        return Messages.UserClaimsAction_DisplayName_AssignedClaims();
    }

    @Override
    public String getUrlName() {
        return "claims";
    }

    @Extension(ordinal=-1000.0)
    public static class TransientUserClaimsActionactoryImpl
    extends TransientUserActionFactory {
        public Collection<? extends Action> createFor(User target) {
            return Collections.singleton(new UserClaimsAction(target));
        }
    }
}

