/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.claim;

import hudson.Extension;
import hudson.model.Action;
import hudson.model.Api;
import hudson.model.Job;
import hudson.model.ModelObject;
import hudson.model.Run;
import hudson.plugins.claim.AbstractAssignedClaimsReport;
import hudson.plugins.claim.ClaimTestAction;
import hudson.tasks.test.AbstractTestResultAction;
import hudson.tasks.test.TestResult;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import jenkins.model.TransientActionFactory;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;

@ExportedBean
public class JobClaimsAction
extends AbstractAssignedClaimsReport {
    private final Job targetJob;

    public JobClaimsAction(Job target) {
        this.targetJob = target;
    }

    @Override
    public ModelObject getOwner() {
        return this.targetJob;
    }

    @Override
    protected List<Job> getJobs() {
        return Collections.singletonList(this.targetJob);
    }

    @Override
    public String getDisplayName() {
        return "Claims";
    }

    @Override
    public String getUrlName() {
        return "claims";
    }

    public Api getApi() {
        return new Api((Object)this);
    }

    private AbstractTestResultAction<?> getTestResultAction(Job<?, ?> job) {
        Run run = job.getLastCompletedBuild();
        if (run != null) {
            return (AbstractTestResultAction)run.getAction(AbstractTestResultAction.class);
        }
        return null;
    }

    @Exported
    public int getNbUnclaimedTestFailures() {
        AbstractTestResultAction<?> testResultAction = this.getTestResultAction(this.targetJob);
        int nbUnclaimedTsetFailures = -1;
        if (testResultAction != null) {
            nbUnclaimedTsetFailures = 0;
            List failedTests = testResultAction.getFailedTests();
            for (TestResult failedTest : failedTests) {
                ClaimTestAction x = (ClaimTestAction)((Object)failedTest.getTestAction(ClaimTestAction.class));
                if (x != null && x.isClaimed()) continue;
                ++nbUnclaimedTsetFailures;
            }
        }
        return nbUnclaimedTsetFailures;
    }

    @Extension(ordinal=-1000.0)
    public static class TransientJobClaimsActionactoryImpl
    extends TransientActionFactory<Job> {
        public Class<Job> type() {
            return Job.class;
        }

        @Nonnull
        public Collection<? extends Action> createFor(@Nonnull Job job) {
            if (job.getLastCompletedBuild() != null) {
                return Collections.singleton(new JobClaimsAction(job));
            }
            return Collections.emptySet();
        }
    }
}

